<?php
$img        = wp_get_attachment_image( get_post_thumbnail_id(), 'medium' );
$site_url   = get_post_meta( $post->ID, 'site_url', 1 );
$site_label = get_post_meta( $post->ID, 'site_label', 1 );

if ( $site_url ) {
	$link_type = 'a';
	$link_attr = 'href="' . $site_url . '" target="_blank" rel="noopener noreferrer"';
}
else {
	$link_type = 'span';
	$link_attr = '';
}

$phones     = get_post_meta( $post->ID, 'phone', 1 );
$phones_arr = [];
if ( $phones ) {
	$phones_arr = explode( "\n", str_replace( "\r", '', trim( $phones ) ) );
}
?>
<div class="partners-item">
	<?php
	if ( $img ) {
		printf( '<%1$s class="partners-item__img" %2$s>' . $img . '</%1$s>', $link_type, $link_attr );
	}
	?>
    <div class="partners-item__body">
		<?php printf( '<%1$s class="partners-item__name" %2$s>' . get_the_title() . '</%1$s>', $link_type, $link_attr ); ?>
		<?php if ( $post->post_content ) { ?>
            <div class="partners-item__text"><?php echo $post->post_content; ?></div>
		<?php } ?>
		<?php if ( $site_url || $phones_arr ) { ?>
            <div class="partners-item__contacts">
				<?php if ( $site_url && $site_label ) { ?>
                    <div class="partners-item__contacts-item">
                        <span><?php _e( 'Сайт', 'wescle' ); ?></span>
                        <a href="<?php echo $site_url; ?>" target="_blank" rel="noopener noreferrer"><?php echo $site_label; ?></a>
                    </div>
				<?php } ?>
				<?php if ( $phones_arr ) { ?>
                    <div class="partners-item__contacts-item"><span><?php _e( 'Телефон', 'wescle' ); ?></span>
						<?php foreach ( $phones_arr as $item ) { ?>
                            <a href="tel:<?php echo Helper::phone_number_format( $item ); ?>"><?php echo Helper::phone_number_mask( $item ); ?></a>
						<?php } ?>
                    </div>
				<?php } ?>
            </div>
		<?php } ?>
    </div>
</div>
