<?php
$license_timer              = $args['license_timer'] ?? '';
$timer_data_attr            = $args['timer_data_attr'] ?? '';
$home_licenses_action_label = $args['home_licenses_action_label'] ?? '';
$btn_flare                  = $args['btn_flare'] ?? '';

$terms = get_terms( [
	'taxonomy' => 'licensecat_wescle'
] );
?>
<div class="_tabs">
	<?php if ( $terms || $license_timer ) { ?>
        <nav class="licenses-nav">
			<?php if ( $terms ) { ?>
                <div class="licenses-nav__col">
                    <ul class="licenses-tabs-nav">
						<?php foreach ( $terms as $key_term => $term ) { ?>
							<?php
							$tab_class = $key_term === 0 ? ' _active' : '';
							$img_id    = get_term_meta( $term->term_id, '_thumbnail_id', 1 );
							?>
                            <li>
                                <button class="btn btn-main _tabs-item<?php echo $tab_class; ?>" type="button" aria-label="<?php _e( 'Кнопка переключения вкладки', 'wescle' ); ?>">
									<?php if ( $img_id ) { ?>
										<?php echo wp_get_attachment_image( $img_id, 'thumbnail' ); ?>
									<?php } ?>
                                    <span><?php echo $term->name; ?></span>
                                </button>
                            </li>
						<?php } ?>
                    </ul>
                </div>
			<?php } ?>
			<?php if ( $license_timer ) { ?>
                <div class="licenses-nav__col">
                    <div class="licenses-timer small-timer-block" id="licenses-timer-<?php echo get_the_ID(); ?>" <?php echo $timer_data_attr; ?>>
                        <div class="small-timer-block__text"><?php echo $home_licenses_action_label; ?></div>
                        <div class="small-timer-block__time">
                            <div class="small-timer-block__item"><span class="days" data-days="">00</span></div>
                            <div class="small-timer-block__separator"></div>
                            <div class="small-timer-block__item"><span class="hours" data-hours="">00</span></div>
                            <div class="small-timer-block__separator"></div>
                            <div class="small-timer-block__item"><span class="minutes" data-minutes="">00</span></div>
                            <div class="small-timer-block__separator"></div>
                            <div class="small-timer-block__item"><span class="seconds" data-seconds="">00</span></div>
                        </div>
                    </div>
                </div>
			<?php } ?>
	        <?php if ( ! $terms || ! $license_timer ) { ?>
                <div class="licenses-nav__col"></div>
	        <?php } ?>
	        <?php /*
            <div class="licenses-nav__col">
                <div class="licenses__currency _currency _dropdown">
                    <button class="btn btn-main _dropdown-btn" type="button"><span>Валюта</span><span>&#36;</span></button>
                    <div class="_dropdown-body">
                        <div><a href="#dollars" data-currency="&amp;#36;" data-currency-name="currency-usd">&#36; - dollars</a><a href="#euro" data-currency="&amp;euro;" data-currency-name="currency-euro">&euro; - euro</a><a href="#rub" data-currency="&amp;#8381;" data-currency-name="currency-rub">&#8381; - рубли</a><a href="#hryvnia" data-currency="&amp;#8372" data-currency-name="currency-uah">&#8372; - гривны</a></div>
                    </div>
                </div>
            </div>
            */ ?>
        </nav>
		<?php
	}

	if ( ! $terms ) {
		$terms         = [ 0 ];
		$posts_license = get_posts( [
			'post_type'      => 'license_wescle',
			'posts_per_page' => - 1,
			'orderby'        => [ 'menu_order' => 'ASC', 'date' => 'DESC' ]
		] );
	}
	?>
    <ul class="licenses-tabs">
		<?php foreach ( $terms as $key_term => $term ) { ?>
			<?php
			$tab_class = $key_term === 0 ? ' _active' : '';
			if ( $term !== 0 ) {
				$posts_license = get_posts( [
					'post_type'      => 'license_wescle',
					'posts_per_page' => - 1,
					'orderby'        => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
					'tax_query'      => [
						[
							'taxonomy' => 'licensecat_wescle',
							'terms'    => [ $term->term_id ],
						]
					],
				] );
			}
			?>
            <li class="_tabs-block _fade <?php echo $tab_class; ?>">
                <div class="licenses-tabs__content">
					<?php foreach ( $posts_license as $post ) {
						setup_postdata( $post );

						get_template_part( 'template-parts/content/license-item', '', [ 'btn_flare' => $btn_flare ] );
					}
					wp_reset_postdata();
					?>
                </div>
            </li>
			<?php
		}
		?>
    </ul>
</div>