<?php
$is_special = get_post_meta( $post->ID, 'is_special', 1 );

$related_product_id = intval( get_post_meta( $post->ID, 'related_product', 1 ) );
if ( $related_product_id ) {
	$regular_price = $sale_price = $current_price = '';

	$related_product = wc_get_product( $related_product_id );
	if ( $related_product ) {
		$regular_price      = $related_product->get_regular_price();
		$sale_price         = $related_product->get_sale_price();
		$regular_price_html = wc_price( $regular_price );

		$current_price = wc_price( $regular_price );
		if ( $sale_price && $sale_price < $regular_price ) {
			$current_price = wc_price( $sale_price );
		}
	}
}
else {
	$regular_price      = get_post_meta( $post->ID, 'price', 1 );
	$regular_price_html = $regular_price;
	$sale_price         = get_post_meta( $post->ID, 'sale_price', 1 );
	if ( $sale_price ) {
		$current_price = $sale_price;
	}
	else {
		$current_price = $regular_price;
	}
}

$button_label = get_post_meta( $post->ID, 'label_button', 1 );

$list_info = get_post_meta( $post->ID, 'wescle_license_info', 1 );

$url = trim( get_post_meta( $post->ID, 'button_url', 1 ) );
if ( ! $url || $url == '#' ) {
	if ( $related_product_id && $related_product ) {
		$url = get_permalink( $related_product_id );
	}
	else {
		$url = '#modal-order_license';
	}
}
$url = apply_filters( 'wescle_license_button_url', $url, $related_product_id );

$btn_flare = '';
if ( Helper::is_frontpage_assets() && get_theme_mod( 'license_button_type' ) == 'animation' ) {
	$btn_flare = 'btn-flare';
}
else {
	$btn_flare = $args['btn_flare'] ?? '';
}

$class_tab_item = '';
if ( $is_special ) {
	$class_tab_item = 'licenses-tab-item_agency';
}

$styles = [];
$color  = get_post_meta( $post->ID, 'color_text', 1 );
if ( $color ) {
	$styles[] = 'color:' . $color;

}
$color = get_post_meta( $post->ID, 'color_bg', 1 );
if ( $color ) {
	$styles[] = 'background-color:' . $color;
}

$style = '';
if ( $styles ) {
	$style = ' style="' . implode( '; ', $styles ) . '"';
}
?>
<div class="licenses-tabs__col">
    <div class="licenses-tab-item licenses-tab-item-<?php echo $post->ID; ?> <?php echo $class_tab_item; ?>"<?php echo $style; ?>>
        <div class="licenses-tab-item__title"><?php the_title(); ?></div>
		<?php if ( $current_price ) { ?>
            <div class="licenses-tab-item__price">
                <span class="licenses-tab-item__price-current"><?php echo $current_price; ?></span>
				<?php if ( $sale_price ) { ?>
                    <span class="licenses-tab-item__price-old"><?php echo $regular_price_html; ?></span>
				<?php } ?>
            </div>
		<?php } ?>
		<?php if ( $post->post_content ) { ?>
            <div class="licenses-tab-item__text"><?php echo $post->post_content; ?></div>
		<?php } ?>
		<?php if ( $list_info ) { ?>
            <ul class="licenses-tab-item__list">
				<?php foreach ( $list_info as $item ) { ?>
					<?php
					$li_class_arr = [];
					if ( $item['type'] === 'minus' ) {
						$li_class_arr[] = 'cancel';
					}
					if ( $item['text'] ) {
						$li_class_arr[] = '_with-tooltip';
					}
					$li_class = $li_class_arr ? ' class="' . implode( ' ', $li_class_arr ) . '"' : '';
					?>

                    <li<?php echo $li_class; ?>>
						<?php if ( $item['type'] === 'minus' ) { ?>
                            <svg role="img" xmlns="http://www.w3.org/2000/svg" width="48px" height="48px" viewbox="0 0 24 24" aria-labelledby="cancelIconTitle" stroke="red" stroke-width="1" stroke-linecap="square" stroke-linejoin="miter" fill="none" color="red">
                                <path d="M15.5355339 15.5355339L8.46446609 8.46446609M15.5355339 8.46446609L8.46446609 15.5355339"></path>
                                <path d="M4.92893219,19.0710678 C1.02368927,15.1658249 1.02368927,8.83417511 4.92893219,4.92893219 C8.83417511,1.02368927 15.1658249,1.02368927 19.0710678,4.92893219 C22.9763107,8.83417511 22.9763107,15.1658249 19.0710678,19.0710678 C15.1658249,22.9763107 8.83417511,22.9763107 4.92893219,19.0710678 Z"></path>
                            </svg>

						<?php } else { ?>
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="22" height="22" viewbox="0 0 22 22">
                                <g transform="translate(5.224 2.764)">
                                    <path class="radial-orange" d="M137.715,64.571a.829.829,0,0,0-1.172,0L126.6,74.49l-3.589-3.9a.829.829,0,0,0-1.22,1.123l4.173,4.532a.828.828,0,0,0,.592.267h.018a.83.83,0,0,0,.585-.242l10.558-10.53A.829.829,0,0,0,137.715,64.571Z" transform="translate(-121.568 -64.327)"></path>
                                </g>
                                <path class="radial-orange" d="M21.171,10.171a.829.829,0,0,0-.829.829A9.342,9.342,0,1,1,11,1.658.829.829,0,1,0,11,0,11,11,0,1,0,22,11,.829.829,0,0,0,21.171,10.171Z"></path>
                            </svg>
						<?php } ?>
                        <p><?php echo $item['title']; ?>
							<?php if ( $item['text'] ) { ?>
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 1024 1024">
                                    <path d="M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448s448-200.6 448-448S759.4 64 512 64zm32 664c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V456c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v272zm-32-344a48.01 48.01 0 0 1 0-96a48.01 48.01 0 0 1 0 96z" fill="#626262"></path>
                                </svg>
                                <span class="tooltip tooltip_top tooltip_top_right"><?php echo $item['text']; ?></span>
							<?php } ?>
                        </p>
                    </li>
				<?php } ?>
            </ul>
		<?php } ?>

		<?php if ( $url == '#modal-order_license' ) { ?>
            <a class="licenses-tab-item__btn btn btn-main _popup-link <?php echo $btn_flare; ?>" data-name="<?php echo esc_attr( $post->post_title ); ?>" href="<?php echo $url; ?>"><span><?php echo $button_label; ?></span></a>
		<?php } elseif ( Helper::is_external_url( $url ) ) { ?>
            <span class="licenses-tab-item__btn btn btn-main js-link <?php echo $btn_flare; ?>" data-link="<?php echo $url; ?>"><span><?php echo $button_label; ?></span></span>
		<?php } else { ?>
            <a class="licenses-tab-item__btn btn btn-main <?php echo $btn_flare; ?>" href="<?php echo $url; ?>"><span><?php echo $button_label; ?></span></a>
		<?php } ?>
    </div>
</div>