<?php
$btn_flare = '';
if ( Helper::is_frontpage_assets() && get_theme_mod( 'events_button_type' ) == 'animation' ) {
	$btn_flare = 'btn-flare ';
}
elseif ( isset( $args['btn_flare'] ) && $args['btn_flare'] ) {
	$btn_flare = 'btn-flare';
}
?>
<div class="events-block-item">
    <div class="events-block-item__top">
        <div class="events-block-item__img">
			<?php the_post_thumbnail( 'medium' ); ?>
        </div>
		<?php
		$event_date = get_post_meta( $post->ID, 'event_date', 1 );
		if ( $event_date ) {
			$strtotime  = strtotime( $event_date );
			$day        = date( 'd', $strtotime );
			$month_year = date( 'F Y', $strtotime );
			if ( get_locale() == 'ru_RU' || get_locale() == 'uk' ) {
				$month_year = Helper::russian_time( $month_year );
			}
			?>
            <div class="events-block-item__planned">
                <time datetime="<?php echo date( 'Y-m-d', $strtotime ); ?>"><span><?php echo $day; ?></span><span><?php echo $month_year; ?></span></time>
            </div>
			<?php
		}
		?>
	    <?php if ( $event_info = get_post_meta( $post->ID, 'event_info', 1 ) ) { ?>
            <span class="events-block-item__time"><?php echo $event_info; ?></span>
	    <?php } ?>
    </div>
    <div class="events-block-item__body">
        <div class="events-block-item__title"><?php the_title(); ?></div>
        <div class="events-block-item__text">
			<?php
			if ( $post->post_excerpt ) {
				echo $post->post_excerpt;
			}
			else {
				echo Helper::short_string( wp_strip_all_tags( $post->post_content ), 150 );
			}
			?>
        </div>
        <a class="btn btn-main btn-main_blue <?php echo $btn_flare; ?>" href="<?php the_permalink(); ?>"><?php echo apply_filters( 'wescle_read_more_event', __( 'Подробнее', 'wescle' ) ); ?></a>
    </div>
</div>