<?php
global $post;

if ( ! get_theme_mod( 'module_catalog_enabled' ) ) {
	return;
}

$is_short          = $args['short'] ?? false;
$checkbox_disabled = $args['checkbox_disabled'] ?? false;
$input_type        = apply_filters( 'wescle_catalog_input_type', 'checkbox', $post );

$html_badges     = wescle_catalog_item_badges();
$post_terms      = get_the_terms( $post, 'catalogcat_wescle' );
$post_term_links = [];
if ( $post_terms ) {
	foreach ( $post_terms as $term ) {
		$post_term_links[] = '<a href="' . get_term_link( $term ) . '">' . $term->name . '</a>';
	}
}

$html_characteristics = '';
$advantages_title     = get_post_meta( $post->ID, 'wescle_advantages_title', 1 );
if ( $advantages_title ) {
	$texts = [];
	foreach ( $advantages_title as $item ) {
		$texts[] = '<span>' . $item['text'] . '</span>';
	}
	if ( $texts ) {
		$html_characteristics = '<div class="wescle-transport-item__characteristics">' . implode( '', $texts ) . '</div>';
	}
}

$images = Helper::get_catalog_images( $post );

$custom_link = get_post_meta( $post->ID, 'custom_url', 1 );
if ( ! $custom_link && ! Catalog::is_public() ) {
	$custom_link = '#';
}
if ( $custom_link ) {
	$link_open  = '<span class="wescle-transport-item__title js-link" data-link="' . $custom_link . '">';
	$link_close = '</span>';
}
else {
	$link_open  = '<a class="wescle-transport-item__title" href="' . get_permalink( $post ) . '">';
	$link_close = '</a>';
}
if ( $is_short ) {
	$link_open  = '<span class="wescle-transport-item__title">';
	$link_close = '</span>';
}

$button_text  = get_post_meta( $post->ID, 'button_text', 1 );
$button_url   = get_post_meta( $post->ID, 'button_link', 1 );
$target_blank = get_post_meta( $post->ID, 'button_link_is_blank', 1 ) ? 'target="_blank" rel="noopener noreferrer"' : '';

if ( get_post_meta( $post->ID, 'related_product', 1 ) && Helper::is_woocommerce_active() ) {
	$url         = Catalog::is_public() ? get_permalink( $post ) : home_url();
	$for_catalog = Catalog::is_public() ? false : $post->ID;
	$button_url  = add_query_arg( [ 'add-to-cart' => '', 'for-catalog' => $for_catalog ], $url );
	if ( ! $button_text ) {
		$button_text = __( 'Купить', 'wescle' );
	}
}

$classes = [ 'wescle-transport-item' ];
if ( get_post_meta( $post->ID, 'object_fit_contain', 1 ) ) {
	$classes[] = '_contain';
}

$btn_flare = '';
if ( get_theme_mod( 'catalog_button_type' ) == 'animation' ) {
	$btn_flare = ' btn-flare';
}
?>
<div class="<?php echo implode( ' ', $classes ); ?>" data-slider="<?php echo $post->ID; ?>">
	<?php if ( ! $is_short ) { ?>
        <div class="wescle-transport-item__img">
			<?php if ( $html_badges ) { ?>
                <div class="wescle-transport-item__label"><?php echo $html_badges; ?></div>
			<?php } ?>
			<?php if ( $post_term_links ) { ?>
                <div class="wescle-transport-item__category"><?php echo implode( ' ', $post_term_links ); ?></div>
			<?php } ?>
			<?php
			if ( count( $images ) > 1 ) {
				$limit = get_theme_mod( 'module_catalog_gallery_count', 3 );
				echo '<div class="wescle-transport-item__slider"><div class="swiper-wrapper">';
				foreach ( $images as $key_img => $img_id ) {
					if ( $key_img == $limit ) {
						break;
					}

					echo '<div class="swiper-slide"><div class="wescle-transport-item__slide">';
					echo $link_open;
					echo wp_get_attachment_image( $img_id, 'medium_large' );
					echo $link_close;
					echo '</div></div>';
				}
				echo '</div></div>';
			}
			else {
				echo $link_open;
				echo wp_get_attachment_image( get_post_thumbnail_id(), 'medium_large' );
				echo $link_close;
			}
			?>
        </div>
		<?php if ( count( $images ) > 1 ) { ?>
            <div class="wescle-transport-item__nav">
                <div class="_slider-fraction"></div>
                <div class="_slider-navigation">
                    <button class="_slider-navigation__prev" type="button" aria-label="prev">
                        <svg width="11" height="19" viewbox="0 0 11 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M9.0419 1.02075L1 9.06265L9.0419 17.1046" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                        </svg>
                    </button>
                    <button class="_slider-navigation__next" type="button" aria-label="next">
                        <svg width="11" height="19" viewbox="0 0 11 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M1.59189 17.1045L9.63379 9.06259L1.59189 1.02069" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                        </svg>
                    </button>
                </div>
            </div>
		<?php } ?>
	<?php } ?>

	<?php echo $html_characteristics; ?>
	<?php echo $link_open . get_the_title() . $link_close; ?>
	<?php echo Catalog::html_stock_status( $post ); ?>
	<?php
	$items = get_post_meta( $post->ID, 'wescle_advantages', 1 );
	if ( $items ) {
		echo '<ul class="wescle-transport-item__specifications">';
		foreach ( $items as $item ) {
			$img_id = $item['img_id'];
			$title  = $item['title'];
			$text   = $item['text'];

			echo '<li>';
			if ( $img_id ) {
				echo wp_get_attachment_image( $img_id );
			}
			echo '<div>';
			if ( ! $text ) {
				echo '<span class="wescle-transport-item__specifications-value">' . $title . '</span>';
			}
			else {
				echo '<span class="wescle-transport-item__specifications-title">' . $title . '</span>';
				echo '<span class="wescle-transport-item__specifications-value">' . $text . '</span>';
			}
			echo '</div>';
			echo '</li>';
		}
		echo '</ul>';
	}
	?>

	<?php
	$items = get_post_meta( $post->ID, 'info_items', 1 );
	if ( $items ) {
		foreach ( $items as $key => $item ) {
			if ( ! isset( $item['price'] ) ) {
				$items[ $key ]['price'] = '';
			}

			$classes = [];
			if ( $item['title_strong'] ) {
				$classes[] = '_strong';
			}
			if ( $item['title_color'] ) {
				$classes[] = '_accent';
			}
			$items[ $key ]['classes_title'] = $classes ? ' ' . implode( ' ', $classes ) : '';

			$classes = [];
			if ( $item['text_strong'] ) {
				$classes[] = '_strong';
			}
			if ( $item['text_color'] ) {
				$classes[] = '_accent';
			}
			$items[ $key ]['classes_text'] = $classes ? ' ' . implode( ' ', $classes ) : '';

			$classes = [];
			if ( $item['text2_strong'] ) {
				$classes[] = '_strong';
			}
			if ( $item['text2_color'] ) {
				$classes[] = '_accent';
			}
			$items[ $key ]['classes_text2'] = $classes ? ' ' . implode( ' ', $classes ) : '';
		}
		if ( get_post_meta( $post->ID, 'info_items_as_list', 1 ) ) {
			?>
            <ul class="wescle-transport-item__list">
				<?php foreach ( $items as $item ) { ?>
                    <li>
						<?php if ( $is_short && ! $checkbox_disabled ) { ?>
                            <span>
                                <input type="<?php echo $input_type; ?>" name="order_keys" class="catalog-order_keys" value="<?php echo $key; ?>">
                            </span>
						<?php } ?>
	                    <?php if ( $item['title'] ) { ?>
                            <span class="wescle-transport-item__list-title<?php echo $item['classes_title']; ?>"><?php echo $item['title']; ?></span>
	                    <?php } ?>
	                    <?php if ( $item['text'] ) { ?>
                            <span class="wescle-transport-item__list-label<?php echo $item['classes_text']; ?>"><?php echo $item['text']; ?></span>
	                    <?php } ?>
	                    <?php if ( $item['text2'] ) { ?>
                            <span class="wescle-transport-item__list-value<?php echo $item['classes_text2']; ?>"><?php echo $item['text2']; ?></span>
	                    <?php } ?>
	                    <?php if ( $item['price'] ) { ?>
                            <span class="wescle-transport-item__list-value _strong _accent"><?php echo catalog_price( $item['price'] ); ?></span>
	                    <?php } ?>
                    </li>
					<?php
				}
				?>
            </ul>
			<?php
		}
		else {
			?>
            <div class="wescle-transport-item__table">
                <table>
                    <thead>
					<?php foreach ( $items as $item ) { ?>
                        <tr>
							<?php if ( $is_short && ! $checkbox_disabled ) { ?>
                                <th></th>
							<?php } ?>
							<?php $attr_class = $item['classes_title'] ? ' class="' . $item['classes_title'] . '"' : ''; ?>
                            <th<?php echo $attr_class; ?>><?php echo $item['title']; ?></th>

							<?php $attr_class = $item['classes_text'] ? ' class="' . $item['classes_text'] . '"' : ''; ?>
                            <th<?php echo $attr_class; ?>><?php echo $item['text']; ?></th>

							<?php if ( $item['text2'] ) { ?>
								<?php $attr_class = $item['classes_text2'] ? ' class="' . $item['classes_text2'] . '"' : ''; ?>
                                <th<?php echo $attr_class; ?>><?php echo $item['text2']; ?></th>
							<?php } ?>
                        </tr>
						<?php
						break;
					} ?>
                    </thead>
                    <tbody>
					<?php
					foreach ( $items as $key => $item ) {
						if ( $key == 0 ) {
							continue;
						}
						?>
                        <tr>
							<?php if ( $is_short && ! $checkbox_disabled ) { ?>
                                <td>
                                    <input type="<?php echo $input_type; ?>" name="order_keys" class="catalog-order_keys" value="<?php echo $key; ?>">
                                </td>
							<?php } ?>
	                        <?php $attr_class = $item['classes_title'] ? ' class="' . $item['classes_title'] . '"' : ''; ?>
                            <td<?php echo $attr_class; ?>><?php echo $item['title']; ?></td>

	                        <?php $attr_class = $item['classes_text'] ? ' class="' . $item['classes_text'] . '"' : ''; ?>
                            <td<?php echo $attr_class; ?>><?php echo $item['text']; ?></td>

	                        <?php if ( $item['text2'] ) { ?>
		                        <?php $attr_class = $item['classes_text2'] ? ' class="' . $item['classes_text2'] . '"' : ''; ?>
                                <td<?php echo $attr_class; ?>><?php echo $item['text2']; ?></td>
	                        <?php } ?>

	                        <?php if ( $item['price'] ) { ?>
                                <td class="_strong _accent"><?php echo catalog_price( $item['price'] ); ?></td>
	                        <?php } ?>
                        </tr>
						<?php
					}
					?>
                    </tbody>
                </table>
            </div>
			<?php
		}
	}
	?>
	<?php if ( $button_text && $button_url && Catalog::get_stock_status( $post ) !== 'outofstock' ) { ?>
		<?php $btn_short = $is_short ? ' short' : ''; ?>
        <a class="btn btn-main btn-order_catalog<?php echo $btn_flare; ?><?php echo $btn_short; ?>" href="<?php echo $button_url; ?>" <?php echo $target_blank; ?> data-name="<?php echo esc_attr( $post->post_title ); ?>" data-url="<?php echo esc_url( get_permalink( $post ) ); ?>"><?php echo $button_text; ?></a>
	<?php } ?>
	<?php
	if ( $is_short ) {
		$button_text  = get_post_meta( $post->ID, 'button2_text', 1 );
		$button_url   = get_post_meta( $post->ID, 'button2_link', 1 );
		$target_blank = get_post_meta( $post->ID, 'button2_link_is_blank', 1 ) ? 'target="_blank" rel="noopener noreferrer"' : '';
		$btn_short    = $is_short ? ' short' : '';
		if ( $button_text && $button_url ) {
			?>
            <a class="btn btn-main btn-order_catalog<?php echo $btn_flare; ?><?php echo $btn_short; ?>" href="<?php echo $button_url; ?>" <?php echo $target_blank; ?> data-name="<?php echo esc_attr( $post->post_title ); ?>" data-url="<?php echo esc_url( get_permalink( $post ) ); ?>"><?php echo $button_text; ?></a>
			<?php
		}
	}
	?>
</div>