<?php
$breadcrumb_enabled = get_theme_mod( 'module_breadcrumb_enabled', true );
if ( apply_filters( 'wescle_breadcrumb_enabled', $breadcrumb_enabled ) ) :

	$type = '';

	if ( function_exists( 'bcn_display' ) ) {
		$type = 'breadcrumb_navxt';
	}
    elseif ( function_exists( 'bbp_breadcrumb' ) && ( is_singular( [ 'forum', 'topic' ] ) || is_post_type_archive( 'forum' ) ) ) {
		$type = 'bbpress';
	}
    elseif ( function_exists( 'yoast_breadcrumb' ) ) {
		$wpseo_titles = get_option( 'wpseo_titles' );
		if ( $wpseo_titles['breadcrumbs-enable'] ) {
			$type = 'yoast';
		}
	}

	if ( $type == 'breadcrumb_navxt' ) {
		$html = str_replace( 'taxonomy category', 'taxonomy category-item', bcn_display( true ) );
		if ( $html ) {
			echo '<div class="breadcrumb">';
			echo $html;
			echo '</div>';
		}
	}
    elseif ( $type == 'bbpress' ) {
		?>
        <div class="breadcrumb"><?php bbp_breadcrumb(); ?></div>
		<?php
	}
    elseif ( $type == 'yoast' ) {
	    $breadcrumb = yoast_breadcrumb( '<div class="breadcrumb" id="breadcrumbs">', '</div>', false );

	    if ( ! get_theme_mod( 'module_breadcrumb_show_single_link', false ) ) {
		    $breadcrumb = str_replace( [ '<span>', '</span>' ], '', $breadcrumb );

		    if ( strpos( $breadcrumb, 'breadcrumb_last' ) !== false ) {
			    $breadcrumb = str_replace( '</div>', '</span></div>', $breadcrumb );
		    }
	    }

	    echo $breadcrumb;
    }
	else {
		echo WsclBreadcrumbs::getInstance()->wscl_crumbs_output();
	}

endif;