<?php
if ( ! is_author() ) { ?>
    <div class="content-title">
        <div class="container">
			<?php get_template_part( 'template-parts/breadcrumbs' ); ?>

			<?php if ( $wp_query->is_posts_page ) { ?>

				<?php
				echo '<h1 class="title">' . get_the_title( get_option( 'page_for_posts' ) ) . '</h1>';
				?>

			<?php } elseif ( is_archive() ) { ?>

				<?php
				if ( is_tax( 'catalogcat_wescle' ) && ! Helper::is_catalog_cat_map() ) {
					echo '<div class="title__top">';
					the_archive_title( '<h1 class="title">', '</h1>' );
					if ( get_theme_mod( 'catalog_archive_show_button_map', true ) && get_theme_mod( 'google_map_api_key' ) ) {
						$btn_flare = get_theme_mod( 'catalog_map_button_type' ) == 'animation' ? ' btn-flare' : '';
						echo '<a class="btn btn-main btn-catalog_map' . $btn_flare . '" href="?map">' . get_theme_mod( 'catalog_archive_button_map_label', __( 'Кнопка', 'wescle' ) ) . '</a>';
					}
					echo '</div>';
				}
				else {
					the_archive_title( '<h1 class="title">', '</h1>' );
				}

				if ( ! is_paged() ) {
					the_archive_description( '<div class="text content-top entry-content section-post__editor">', '</div>' );
				}
				?>

			<?php } elseif ( get_option( 'show_on_front' ) != 'posts' ) { ?>

				<?php
				if ( is_search() ) {
					$archive_title = sprintf(
						'<h1 class="title">%1$s %2$s</h1>',
						'<span class="color-accent">' . __( 'Поиск:', 'wescle' ) . '</span>',
						'&ldquo;' . get_search_query() . '&rdquo;'
					);
					echo $archive_title;
				}
				?>

			<?php } ?>
        </div>
    </div>
<?php } ?>