<?php
$terms = $args['terms'];

if ( ! $terms ) {
	return;
}
?>
<div class="section-tags">
    <div class="tags__title visually-hidden"><?php _e( 'Метки', 'wescle' ); ?></div>
    <div class="section-tags-wrapper">
        <div class="section-tags-nav">
            <button class="section-tags-prev" type="button">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                    <g fill="none">
                        <path d="M8 4l8 8l-8 8" stroke="#0088cc" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"></path>
                    </g>
                </svg>
            </button>
            <button class="section-tags-next" type="button">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                    <g fill="none">
                        <path d="M8 4l8 8l-8 8" stroke="#0088cc" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"></path>
                    </g>
                </svg>
            </button>
        </div>
        <div class="section-tags__row">
			<?php foreach ( $terms as $term ) { ?>
                <a class="category" href="<?php echo get_term_link( $term ); ?>">
					<?php
					$img_id = get_term_meta( $term->term_id, '_thumbnail_id', 1 );
					if ( $img_id ) {
						echo '<div class="category__img">' . wp_get_attachment_image( $img_id, 'thumbnail' ) . '</div>';
					}
					?>
                    <span class="category__title">#<?php echo $term->name; ?></span><span class="category__count"><?php echo $term->count; ?></span>
                </a>
			<?php } ?>
        </div>
    </div>
</div>