<?php
$terms = $args['terms'];

if ( ! $terms ) {
	return;
}

$slides_count = get_theme_mod( 'woo_archive_brands_slider_count', 6 );
?>
<section class="brands" id="brands">
    <div class="container">
		<?php if ( get_theme_mod( 'woo_archive_brands_slider' ) ) { ?>
            <div class="brands-slider-wrapper slider-wrapper _hide-arrows-mobile">
                <div class="brands-buttons slider-buttons">
                    <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                            <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                        </svg>
                    </button>
                    <button class="slider-buttons__item slider-buttons__item_next" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                            <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                        </svg>
                    </button>
                </div>
                <div class="brands__slider" data-slides="<?php echo $slides_count; ?>" data-autoplay-speed="5000" data-dots="false" data-arrows="true">
					<?php foreach ( $terms as $term ) { ?>
						<?php
						$image_html = get_brand_image_html( $term );
						if ( ! $image_html ) {
							continue;
						}
						?>
                        <div class="brands__slide">
                            <a class="brands-item" href="<?php echo get_term_link( $term ); ?>">
                                <div class="brands-item__image">
									<?php echo $image_html; ?>
                                </div>
                            </a>
                        </div>
					<?php } ?>
                </div>
            </div>
		<?php } else { ?>
            <div class="brands__grid">
				<?php foreach ( $terms as $term ) { ?>
					<?php
					$image_html = get_brand_image_html( $term );
					if ( ! $image_html ) {
						continue;
					}
					?>
                    <a class="brands-item" href="<?php echo get_term_link( $term ); ?>">
                        <div class="brands-item__image">
							<?php echo $image_html; ?>
                        </div>
                    </a>
				<?php } ?>
            </div>
		<?php } ?>
    </div>
</section>