<?php
$args    = get_query_var( 'template_args' );
$user_id = $args['user_id'];
if ( ! $user_id ) {
	return;
}
$text = isset( $args['text'] ) ? $args['text'] : '';

$vkontakte     = get_user_meta( $user_id, 'vkontakte', 1 );
$odnoklassniki = get_user_meta( $user_id, 'odnoklassniki', 1 );
$facebook      = get_user_meta( $user_id, 'facebook', 1 );
$twitter       = get_user_meta( $user_id, 'twitter', 1 );
$instagram     = get_user_meta( $user_id, 'instagram', 1 );
$telegram      = get_user_meta( $user_id, 'telegram', 1 );
$youtube       = get_user_meta( $user_id, 'youtube', 1 );
$linkedin      = get_user_meta( $user_id, 'linkedin', 1 );
$pinterest     = get_user_meta( $user_id, 'pinterest', 1 );

$markup = wescle_markup_external_link( 'author-social__link', true );

if ( $vkontakte || $facebook || $twitter || $instagram || $telegram || $youtube || $linkedin || $pinterest || $odnoklassniki ) { ?>
    <div class="author-info__social author-social">
		<?php if ( $text ) { ?>
            <div class="author-social__label"><span><?php echo $text; ?></span>
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(-90deg); -webkit-transform: rotate(-90deg); transform: rotate(-90deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 32 32">
                    <g fill="none" stroke="#626262" stroke-linecap="round" stroke-linejoin="round" stroke-width="4">
                        <path d="M30 12L16 24L2 12"></path>
                    </g>
                </svg>
            </div>
		<?php } ?>
        <ul class="author-social__list">
			<?php if ( $vkontakte ) { ?>
                <li>
					<?php echo str_replace( '%url%', $vkontakte, $markup['tag_open'] ); ?>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 20 20">
                        <path d="M10 .4C4.698.4.4 4.698.4 10s4.298 9.6 9.6 9.6s9.6-4.298 9.6-9.6S15.302.4 10 .4zm3.692 10.831s.849.838 1.058 1.227c.006.008.009.016.011.02c.085.143.105.254.063.337c-.07.138-.31.206-.392.212h-1.5c-.104 0-.322-.027-.586-.209c-.203-.142-.403-.375-.598-.602c-.291-.338-.543-.63-.797-.63a.305.305 0 0 0-.095.015c-.192.062-.438.336-.438 1.066c0 .228-.18.359-.307.359h-.687c-.234 0-1.453-.082-2.533-1.221c-1.322-1.395-2.512-4.193-2.522-4.219c-.075-.181.08-.278.249-.278h1.515c.202 0 .268.123.314.232c.054.127.252.632.577 1.2c.527.926.85 1.302 1.109 1.302a.3.3 0 0 0 .139-.036c.338-.188.275-1.393.26-1.643c0-.047-.001-.539-.174-.775c-.124-.171-.335-.236-.463-.26a.55.55 0 0 1 .199-.169c.232-.116.65-.133 1.065-.133h.231c.45.006.566.035.729.076c.33.079.337.292.308 1.021c-.009.207-.018.441-.018.717c0 .06-.003.124-.003.192c-.01.371-.022.792.24.965a.216.216 0 0 0 .114.033c.091 0 .365 0 1.107-1.273a9.718 9.718 0 0 0 .595-1.274c.015-.026.059-.106.111-.137a.266.266 0 0 1 .124-.029h1.781c.194 0 .327.029.352.104c.044.119-.008.482-.821 1.583l-.363.479c-.737.966-.737 1.015.046 1.748z"
                              fill="#626262"></path>
                    </svg>
					<?php echo $markup['tag_close']; ?>
                </li>
			<?php } ?>
			<?php if ( $odnoklassniki ) { ?>
                <li>
					<?php echo str_replace( '%url%', $odnoklassniki, $markup['tag_open'] ); ?>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512.5 512.5">
                        <path d="M256.2 277.3c76.6 0 138.7-62.1 138.7-138.7S332.8 0 256.2 0 117.6 62.1 117.6 138.7C117.7 215.2 179.7 277.2 256.2 277.3zM256.2 64c41.2 0 74.7 33.4 74.7 74.7s-33.4 74.7-74.7 74.7 -74.7-33.4-74.7-74.7S215 64 256.2 64z" fill="#626262"></path>
                        <path d="M392.1 343c15.1-9.9 24.2-26.8 24.2-44.8 0.2-15-8.2-28.7-21.7-35.3 -13.8-6.9-30.4-5.3-42.7 4 -57 41.5-134.3 41.5-191.3 0 -12.3-9.3-28.8-10.9-42.7-4 -13.4 6.6-21.9 20.3-21.7 35.3 0 18 9.1 34.9 24.2 44.8 19.3 12.9 40.4 22.9 62.5 29.9 3.8 1.2 7.6 2.2 11.6 3.2l-64.5 63c-16.9 16.4-17.3 43.4-0.9 60.3 16.4 16.9 43.4 17.3 60.3 0.9 0.4-0.3 0.7-0.7 1-1l65.7-68 65.8 68.1c16.4 16.9 43.4 17.4 60.3 1 16.9-16.4 17.4-43.4 1-60.3 -0.3-0.4-0.7-0.7-1-1l-64.4-63c4-1 7.9-2.1 11.7-3.3C351.7 365.9 372.8 355.9 392.1 343z"
                              fill="#626262"></path>
                    </svg>
					<?php echo $markup['tag_close']; ?>
                </li>
			<?php } ?>
			<?php if ( $facebook ) { ?>
                <li>
					<?php echo str_replace( '%url%', $facebook, $markup['tag_open'] ); ?>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                        <path d="M13.397 20.997v-8.196h2.765l.411-3.209h-3.176V7.548c0-.926.258-1.56 1.587-1.56h1.684V3.127A22.336 22.336 0 0 0 14.201 3c-2.444 0-4.122 1.492-4.122 4.231v2.355H7.332v3.209h2.753v8.202h3.312z" fill="#ffffff"></path>
                    </svg>
					<?php echo $markup['tag_close']; ?>
                </li>
			<?php } ?>
			<?php if ( $twitter ) { ?>
                <li>
					<?php echo str_replace( '%url%', $twitter, $markup['tag_open'] ); ?>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 1024 1024">
                        <path d="M928 254.3c-30.6 13.2-63.9 22.7-98.2 26.4a170.1 170.1 0 0 0 75-94a336.64 336.64 0 0 1-108.2 41.2A170.1 170.1 0 0 0 672 174c-94.5 0-170.5 76.6-170.5 170.6c0 13.2 1.6 26.4 4.2 39.1c-141.5-7.4-267.7-75-351.6-178.5a169.32 169.32 0 0 0-23.2 86.1c0 59.2 30.1 111.4 76 142.1a172 172 0 0 1-77.1-21.7v2.1c0 82.9 58.6 151.6 136.7 167.4a180.6 180.6 0 0 1-44.9 5.8c-11.1 0-21.6-1.1-32.2-2.6C211 652 273.9 701.1 348.8 702.7c-58.6 45.9-132 72.9-211.7 72.9c-14.3 0-27.5-.5-41.2-2.1C171.5 822 261.2 850 357.8 850C671.4 850 843 590.2 843 364.7c0-7.4 0-14.8-.5-22.2c33.2-24.3 62.3-54.4 85.5-88.2z"
                              fill="#ffffff"></path>
                    </svg>
					<?php echo $markup['tag_close']; ?>
                </li>
			<?php } ?>
			<?php if ( $instagram ) { ?>
                <li>
					<?php echo str_replace( '%url%', $instagram, $markup['tag_open'] ); ?>
                    <svg class="icon-instagram" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 50 50">
                        <g fill-rule="evenodd">
                            <path d="M25 12c-3.53 0-3.973.015-5.36.078c-1.384.063-2.329.283-3.156.604a6.372 6.372 0 0 0-2.302 1.5a6.372 6.372 0 0 0-1.5 2.303c-.321.826-.54 1.771-.604 3.155C12.015 21.027 12 21.47 12 25c0 3.53.015 3.973.078 5.36c.063 1.384.283 2.329.604 3.155c.333.855.777 1.58 1.5 2.303a6.372 6.372 0 0 0 2.302 1.5c.827.32 1.772.54 3.156.604c1.387.063 1.83.078 5.36.078c3.53 0 3.973-.015 5.36-.078c1.384-.063 2.329-.283 3.155-.604a6.371 6.371 0 0 0 2.303-1.5a6.372 6.372 0 0 0 1.5-2.303c.32-.826.54-1.771.604-3.155c.063-1.387.078-1.83.078-5.36c0-3.53-.015-3.973-.078-5.36c-.063-1.384-.283-2.329-.605-3.155a6.372 6.372 0 0 0-1.499-2.303a6.371 6.371 0 0 0-2.303-1.5c-.826-.32-1.771-.54-3.155-.604C28.973 12.015 28.53 12 25 12m0 2.342c3.471 0 3.882.014 5.253.076c1.267.058 1.956.27 2.414.448c.607.236 1.04.517 1.495.972c.455.455.736.888.972 1.495c.178.458.39 1.146.448 2.414c.062 1.37.076 1.782.076 5.253s-.014 3.882-.076 5.253c-.058 1.268-.27 1.956-.448 2.414a4.028 4.028 0 0 1-.972 1.495a4.027 4.027 0 0 1-1.495.972c-.458.178-1.147.39-2.414.448c-1.37.062-1.782.076-5.253.076s-3.883-.014-5.253-.076c-1.268-.058-1.956-.27-2.414-.448a4.027 4.027 0 0 1-1.495-.972a4.03 4.03 0 0 1-.972-1.495c-.178-.458-.39-1.146-.448-2.414c-.062-1.37-.076-1.782-.076-5.253s.014-3.882.076-5.253c.058-1.268.27-1.956.448-2.414c.236-.607.517-1.04.972-1.495a4.028 4.028 0 0 1 1.495-.972c.458-.178 1.146-.39 2.414-.448c1.37-.062 1.782-.076 5.253-.076"
                                  fill="#ffffff"></path>
                            <path d="M25 18a7 7 0 1 0 0 14a7 7 0 0 0 0-14m0 11.5a4.5 4.5 0 1 1 0-9a4.5 4.5 0 0 1 0 9m8.7-11.4a1.6 1.6 0 1 1-3.2 0a1.6 1.6 0 0 1 3.2 0" fill="#ffffff"></path>
                        </g>
                    </svg>
					<?php echo $markup['tag_close']; ?>
                </li>
			<?php } ?>
			<?php if ( $telegram ) { ?>
                <li>
					<?php echo str_replace( '%url%', $telegram, $markup['tag_open'] ); ?>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 32 32">
                        <path d="M16 .5C7.437.5.5 7.438.5 16S7.438 31.5 16 31.5c8.563 0 15.5-6.938 15.5-15.5S24.562.5 16 .5zm7.613 10.619l-2.544 11.988c-.188.85-.694 1.056-1.4.656l-3.875-2.856l-1.869 1.8c-.206.206-.381.381-.781.381l.275-3.944l7.181-6.488c.313-.275-.069-.431-.482-.156l-8.875 5.587l-3.825-1.194c-.831-.262-.85-.831.175-1.231l14.944-5.763c.694-.25 1.3.169 1.075 1.219z" fill="#626262"></path>
                    </svg>
					<?php echo $markup['tag_close']; ?>
                </li>
			<?php } ?>
			<?php if ( $linkedin ) { ?>
                <li>
					<?php echo str_replace( '%url%', $linkedin, $markup['tag_open'] ); ?>
                    <svg enable-background="new 0 0 24 24" height="512" viewBox="0 0 24 24" width="512" xmlns="http://www.w3.org/2000/svg">
                        <g fill="#626262">
                            <path d="m23.994 24v-.001h.006v-8.802c0-4.306-.927-7.623-5.961-7.623-2.42 0-4.044 1.328-4.707 2.587h-.07v-2.185h-4.773v16.023h4.97v-7.934c0-2.089.396-4.109 2.983-4.109 2.549 0 2.587 2.384 2.587 4.243v7.801z"></path>
                            <path d="m.396 7.977h4.976v16.023h-4.976z"></path>
                            <path d="m2.882 0c-1.591 0-2.882 1.291-2.882 2.882s1.291 2.909 2.882 2.909 2.882-1.318 2.882-2.909c-.001-1.591-1.292-2.882-2.882-2.882z"></path>
                        </g>
                    </svg>
					<?php echo $markup['tag_close']; ?>
                </li>
			<?php } ?>
			<?php if ( $pinterest ) { ?>
                <li>
					<?php echo str_replace( '%url%', $pinterest, $markup['tag_open'] ); ?>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512.9 512.9">
                        <path d="M256.4 0c-141.2 0-256 114.8-256 256 0 105 62.7 195.1 153.6 234.8 -0.9-17.7 0-39.7 4.4-59.1 5.3-21.2 32.7-139.5 32.7-139.5s-7.9-16.8-7.9-40.6c0-38 22.1-66.2 49.4-66.2 23 0 34.4 17.7 34.4 38.8 0 23-15 58.3-23 90.9 -6.2 27.4 13.2 49.4 40.6 49.4 48.6 0 81.2-62.7 81.2-135.9 0-56.5-38-98-106.8-98 -77.7 0-126.2 58.3-126.2 122.7 0 22.1 6.2 38 16.8 50.3 4.4 5.3 5.3 7.9 3.5 14.1 -0.9 4.4-4.4 15.9-5.3 20.3 -1.8 6.2-7.1 8.8-13.2 6.2 -36.2-15-52.1-53.8-52.1-98 0-72.4 60.9-159.8 182.7-159.8 98 0 162.4 70.6 162.4 146.5 0 100.6-55.6 175.7-137.7 175.7 -27.4 0-53.8-15-62.7-31.8 0 0-15 59.1-17.7 70.6 -5.3 19.4-15.9 39.7-25.6 54.7 23 7.1 47.7 10.6 72.4 10.6 141.2 0 256-114.8 256-256S397.7 0 256.4 0"
                              fill="#626262"></path>
                    </svg>
					<?php echo $markup['tag_close']; ?>
                </li>
			<?php } ?>
			<?php if ( $youtube ) { ?>
                <li>
					<?php echo str_replace( '%url%', $youtube, $markup['tag_open'] ); ?>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 1024 1024">
                        <path d="M941.3 296.1a112.3 112.3 0 0 0-79.2-79.3C792.2 198 512 198 512 198s-280.2 0-350.1 18.7A112.12 112.12 0 0 0 82.7 296C64 366 64 512 64 512s0 146 18.7 215.9c10.3 38.6 40.7 69 79.2 79.3C231.8 826 512 826 512 826s280.2 0 350.1-18.8c38.6-10.3 68.9-40.7 79.2-79.3C960 658 960 512 960 512s0-146-18.7-215.9zM423 646V378l232 133l-232 135z" fill="#ffffff"></path>
                    </svg>
					<?php echo $markup['tag_close']; ?>
                </li>
			<?php } ?>
        </ul>
    </div>
<?php } ?>