<?php
$user_id     = get_queried_object_id();
$user_author = get_user_by( 'id', $user_id );

$header_image_id = get_user_meta( $user_id, 'header_image', 1 );
$address         = get_user_meta( $user_id, 'address', 1 );
?>
<div class="block-author-info">
    <div class="author-info">
        <div class="author-info__image image-overlay image-overlay_gradient">
			<?php
			if ( $header_image_id ) {
				echo wp_get_attachment_image( $header_image_id, 'full' );
			}
			?>
        </div>
        <div class="author-info__body">
            <div class="author-info__photo">
				<?php echo get_avatar( $user_id, 120 ); ?>
            </div>
            <h1 class="author-info__name"><?php echo Helper::get_author_name( $user_author ); ?></h1>
            <div class="author-info__about">
                <div class="author-info__posts-count">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 26 26">
                        <path d="M20.094.25a2.245 2.245 0 0 0-1.625.656l-1 1.031l6.593 6.625l1-1.03a2.319 2.319 0 0 0 0-3.282L21.75.937A2.36 2.36 0 0 0 20.094.25zm-3.75 2.594l-1.563 1.5l6.875 6.875L23.25 9.75l-6.906-6.906zM13.78 5.438L2.97 16.155a.975.975 0 0 0-.5.625L.156 24.625a.975.975 0 0 0 1.219 1.219l7.844-2.313a.975.975 0 0 0 .781-.656l10.656-10.563l-1.468-1.468L8.25 21.813l-4.406 1.28l-.938-.937l1.344-4.593L15.094 6.75L13.78 5.437zm2.375 2.406l-10.968 11l1.593.343l.219 1.47l11-10.97l-1.844-1.843z"
                              fill="#ffffff"></path>
                    </svg>
                    <span><?php _e( 'Всего записей', 'wescle' ); ?></span>
                    <span class="count"> <?php echo count_user_posts( $user_id, 'post', true ); ?></span>
                </div>
				<?php if ( $address ) { ?>
                    <div class="author-info__location">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                            <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5a2.5 2.5 0 0 1 0-5a2.5 2.5 0 0 1 0 5z" fill="#2178ff"></path>
                        </svg>
                        <span><?php echo $address; ?></span>
                    </div>
				<?php } ?>
            </div>
			<?php if ( $user_author->description ) { ?>
                <div class="author-info__text"><?php echo nl2br( $user_author->description ); ?></div>
	        <?php } ?>
	        <?php
	        set_query_var( 'template_args', [ 'user_id' => $user_author->ID ] );
	        get_template_part( 'template-parts/archive/author', 'social' );
	        ?>
        </div>
    </div>
</div>
