<?php
$pages      = WsclWidgetLogic::global_pages();
$taxonomies = WsclWidgetLogic::global_taxonomies();
$types      = WsclWidgetLogic::global_types();
$categories = WsclWidgetLogic::global_categories();

$misc = array(
	'home'     => __( 'Главная страница', 'wescle' ),
	'blog'     => __( 'Блог', 'wescle' ),
	'store'    => __( 'Магазин', 'wescle' ),
	'archives' => __( 'Архивы', 'wescle' ),
	'404'      => __( '404', 'wescle' ),
	'search'   => __( 'Страница поиска', 'wescle' )
);
if ( ! Helper::is_woocommerce_active() ) {
	unset( $misc['store'] );
}

//get saved values
$options_values = '';
$selected_tab   = 0;
$misc_values    = array();
$ids_values     = '';
$term_ids       = '';
$types_values   = array();
$cat_values     = array();
$tax_values     = array();

if ( isset( $args['params'] ) && isset( $args['params']['visibility'] ) ) {
	if ( isset( $args['params']['visibility']['options'] ) ) {
		$options_values = $args['params']['visibility']['options'];
	}

	if ( isset( $args['params']['visibility']['selected_tab'] ) ) {
		$selected_tab = $args['params']['visibility']['selected_tab'];
	}

	if ( isset( $args['params']['visibility']['misc'] ) ) {
		$misc_values = $args['params']['visibility']['misc'];
	}

	if ( isset( $args['params']['visibility']['ids'] ) ) {
		$ids_values = $args['params']['visibility']['ids'];
	}

	if ( isset( $args['params']['visibility']['term_ids'] ) ) {
		$term_ids = $args['params']['visibility']['term_ids'];
	}

	if ( isset( $args['params']['visibility']['types'] ) ) {
		$types_values = $args['params']['visibility']['types'];
	}

	if ( isset( $args['params']['visibility']['categories'] ) ) {
		$cat_values = $args['params']['visibility']['categories'];
	}

	if ( isset( $args['params']['visibility']['taxonomies'] ) ) {
		$tax_values = $args['params']['visibility']['taxonomies'];
	}
}

?>
<div class="wescle-widget-logic">
    <p><strong><?php _e( 'Логика отображения', 'wescle' ); ?></strong>
        <select class="widefat" name="<?php echo $args['namespace']; ?>[wescle_widget_logic][visibility][options]">
            <option value="hide" <?php selected( $options_values, 'hide' ); ?>><?php _e( 'Спрятать на отмеченных', 'wescle' ); ?></option>
            <option value="show" <?php selected( $options_values, 'show' ); ?>><?php _e( 'Показать на отмеченных', 'wescle' ); ?></option>
        </select>
    </p>

    <div class="wescle-widget-logic-tabs" id="wescle-widget-logic-tabs-<?php echo $args['id']; ?>">
        <input type="hidden" class="wescle-widget-logic-selected_tab" value="<?php echo $selected_tab; ?>" name="<?php echo $args['namespace']; ?>[wescle_widget_logic][visibility][selected_tab]"/>
        <!--  start tab nav -->
        <ul class="nav-tab-wrapper wescle-nav-tab-wrapper">
            <li class="nav-tab wescle-nav-tab">
                <a href="#wescle-widget-logic-visibility-tab-<?php echo $args['id']; ?>-misc"><?php _e( 'Общее', 'wescle' ); ?></a>
            </li>
            <li class="nav-tab wescle-nav-tab">
                <a href="#wescle-widget-logic-visibility-tab-<?php echo $args['id']; ?>-ids">IDs</a>
            </li>
            <li class="nav-tab wescle-nav-tab">
                <a href="#wescle-widget-logic-visibility-tab-<?php echo $args['id']; ?>-tax"><?php _e( 'Таксономии', 'wescle' ); ?></a>
            </li>
            <li class="nav-tab wescle-nav-tab">
                <a href="#wescle-widget-logic-visibility-tab-<?php echo $args['id']; ?>-types"><?php _e( 'Типы записей', 'wescle' ); ?></a>
            </li>
        </ul><!--  end tab nav -->
        <div class="wescle-widget-logic-clearfix"></div>

        <!--  start misc tab content -->
        <div id="wescle-widget-logic-visibility-tab-<?php echo $args['id']; ?>-misc" class="wescle-widget-logic-tabcontent">
            <div class="wescle-widget-logic-misc">
				<?php foreach ( $misc as $key => $value ) {
					if ( isset( $misc_values[ $key ] ) && $misc_values[ $key ] == '1' ) {
						$checked = 'checked="checked"';
					}
					else {
						$checked = '';
					}
					?>
                    <p>
                        <input type="checkbox" name="<?php echo $args['namespace']; ?>[wescle_widget_logic][visibility][misc][<?php echo $key; ?>]" id="<?php echo $args['id']; ?>-wescle-misc-<?php echo $key; ?>" value="1" <?php echo $checked; ?> />
                        <label for="<?php echo $args['id']; ?>-wescle-misc-<?php echo $key; ?>"><?php echo $value; ?></label>
                    </p>
				<?php } ?>
            </div>
        </div><!--  end misc tab content -->

        <!--  start misc tab content -->
        <div id="wescle-widget-logic-visibility-tab-<?php echo $args['id']; ?>-ids" class="wescle-widget-logic-tabcontent">
            <div class="wescle-widget-logic-ids">
                <h4><?php _e( 'ID записей/страниц/товаров через запятую', 'wescle' ); ?></h4>
                <p>
                    <input type="text" class="widefat" name="<?php echo $args['namespace']; ?>[wescle_widget_logic][visibility][ids]" id="<?php echo $args['id']; ?>-wescle-visibility-ids" value="<?php echo $ids_values; ?>">
                </p>
            </div>

            <div class="wescle-widget-logic-ids">
                <h4><?php _e( 'ID категорий/таксономий через запятую', 'wescle' ); ?></h4>
                <p>
                    <input type="text" class="widefat" name="<?php echo $args['namespace']; ?>[wescle_widget_logic][visibility][term_ids]" id="<?php echo $args['id']; ?>-wescle-visibility-term_ids" value="<?php echo $term_ids; ?>">
                </p>
            </div>
        </div><!--  end misc tab content -->

        <!--  start tax tab content -->
        <div id="wescle-widget-logic-visibility-tab-<?php echo $args['id']; ?>-tax" class="wescle-widget-logic-tabcontent">
            <div class="wescle-widget-logic-inner-lists" style="height: 230px;padding: 5px;overflow:auto;">
                <h4 id="wescle-widget-logic-taxonomies"><?php _e( 'Таксономии', 'wescle' ); ?></h4>
                <div class="wescle-widget-logic-taxonomies">
					<?php foreach ( $taxonomies as $taxonomy ) {
						if ( isset( $tax_values[ $taxonomy->name ] ) && $tax_values[ $taxonomy->name ] == '1' ) {
							$checked = 'checked="checked"';
						}
						else {
							$checked = '';
						}
						?>
                        <p>
                            <input type="checkbox" name="<?php echo $args['namespace']; ?>[wescle_widget_logic][visibility][taxonomies][<?php echo $taxonomy->name; ?>]" id="<?php echo $args['id']; ?>-wescle-taxonomies-<?php echo $taxonomy->name; ?>" value="1" <?php echo $checked; ?> />
                            <label for="<?php echo $args['id']; ?>-wescle-taxonomies-<?php echo $taxonomy->name; ?>"><?php echo $taxonomy->label; ?></label> <?php if ( isset( $taxonomy->object_type ) && isset( $taxonomy->object_type[0] ) ) {
								echo ' <small>- ' . $taxonomy->object_type[0] . '</small>';
							} ?>
                        </p>
					<?php } ?>
                </div>

                <h4 id="wescle-widget-logic-categories"><?php _e( 'Категории', 'wescle' ); ?></h4>
                <div class="wescle-widget-logic-categories">
                    <p>
                        <input type="checkbox" name="wescle_widget_logic-<?php echo $args['id']; ?>[wescle_widget_logic][visibility][categories][all_categories]" id="<?php echo $args['id']; ?>-wescle-categories-all" value="1" <?php if ( isset( $cat_values['all_categories'] ) ) {
							echo 'checked="checked"';
						}; ?> />
                        <label for="<?php echo $args['id']; ?>-wescle-categories-all"><?php _e( 'Все категории', 'wescle' ); ?></label>
                    </p>
					<?php foreach ( $categories as $cat ) {
						if ( isset( $cat_values[ $cat->cat_ID ] ) && $cat_values[ $cat->cat_ID ] == '1' ) {
							$checked = 'checked="checked"';
						}
						else {
							$checked = '';
						}
						?>
                        <p>
                            <input type="checkbox" name="<?php echo $args['namespace']; ?>[wescle_widget_logic][visibility][categories][<?php echo $cat->cat_ID; ?>]" id="<?php echo $args['id']; ?>-wescle-categories-<?php echo $cat->cat_ID; ?>" value="1" <?php echo $checked; ?> />
                            <label for="<?php echo $args['id']; ?>-wescle-categories-<?php echo $cat->cat_ID; ?>"><?php echo $cat->cat_name; ?></label>
                        </p>
					<?php } ?>
                </div>
            </div>
        </div><!--  end tax tab content -->

        <!--  start types tab content -->
        <div id="wescle-widget-logic-visibility-tab-<?php echo $args['id']; ?>-types" class="wescle-widget-logic-tabcontent">
            <div class="wescle-widget-logic-inner-lists" style="height: 230px;padding: 5px;overflow:auto;">
                <h4 id="wescle-widget-logic-types"><?php _e( 'Кастомный тип записи', 'wescle' ); ?></h4>
                <div class="wescle-widget-logic-types">
					<?php foreach ( $types as $ptype => $type ) {
						if ( isset( $types_values[ $ptype ] ) && $types_values[ $ptype ] == '1' ) {
							$checked = 'checked="checked"';
						}
						else {
							$checked = '';
						}
						?>
                        <p>
                            <input type="checkbox" name="<?php echo $args['namespace']; ?>[wescle_widget_logic][visibility][types][<?php echo $ptype; ?>]" id="<?php echo $args['id']; ?>-wescle-types-<?php echo $ptype; ?>" value="1" <?php echo $checked; ?> />
                            <label for="<?php echo $args['id']; ?>-wescle-types-<?php echo $ptype; ?>"><?php echo stripslashes( $type->labels->name ); ?></label>
                        </p>
					<?php } ?>
                </div>
            </div>
        </div><!--  end types tab content -->

    </div><!--  end .wescle-widget-logic-visibility-tabs -->
</div><!-- End WordPress Pages tab -->
