<div class="wrap">
	<?php include get_template_directory() . '/template-parts/admin/settings-header.php' ?>
    <div class="_site-settings">
		<?php include get_template_directory() . '/template-parts/admin/settings-navigation.php' ?>
        <div class="_site-settings__grid">
            <div class="_site-settings__categories">
                <button class="_categories-toggle" type="button">
                    <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M11 1L1 6L11 11L21 6L11 1Z" stroke="#1D2327" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M1 16L11 21L21 16" stroke="#1D2327" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M1 11L11 16L21 11" stroke="#1D2327" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                    <span><?php _e( 'Категории', 'wescle' ); ?></span>
                </button>
                <div class="_categories-list">
                    <ul>
						<?php
						$loop = 0;
						foreach ( $sections as $section_tab => $fields ) {
							$loop ++;
							$active_class = $loop == 1 ? 'class="_active"' : '';
							?>
                            <li><a <?php echo $active_class; ?> href="#<?php echo $section_tab; ?>"><?php echo $sections_label[ $section_tab ]; ?></a></li>
							<?php
						}
						?>
                    </ul>
                </div>
            </div>
            <form action="?page=<?php echo $menu_slug; ?>&saved=1" class="_site-settings__content" method="post">
				<?php
				foreach ( $sections as $section_tab => $fields ) {
					?>
                    <div class="_site-settings__section" id="<?php echo $section_tab; ?>"><h2><?php echo $sections_label[ $section_tab ]; ?></h2>
                        <div class="_content-blocks">
							<?php
							$default_img_src = get_template_directory_uri() . '/assets/admin/img/placeholder.jpg';
							foreach ( $fields as $key => $field ) {
								$is_label = isset( $field['is_label'] ) && ! $field['is_label'] ? false : true;
								if ( ! $is_label ) {
									continue;
								}

								$label = Helper::get_default_theme_data( 'home_block_titles', $key );
								if ( $field['key_enabled'] ) {
									$value = get_theme_mod( $field['key_enabled'], $field['default'] );
								}
								else {
									$value = isset( $customizer_sections[ $key ] );
								}

								$img = '<img src="' . $default_img_src . '" alt="' . esc_attr( $label ) . '" loading="lazy"/>';
								if ( $field['image'] ) {
									$img = $field['image'];
								}
								?>
                                <div class="_content-block">
                                    <div class="_content-block__img"><?php echo $img; ?></div>
                                    <div class="_content-block__title"><?php echo $label; ?></div>
									<?php /*<div class="_content-block__text"> Описание блока, описание блока, описание блока</div>*/ ?>
                                    <div class="_site-settings__checkbox">
                                        <label>
                                            <input name="customizer_sections[<?php echo $key; ?>]" type="checkbox" class="customizer_sections_checkbox" <?php checked( $value ); ?> value="1">
                                            <div><span><?php _e( 'Вкл', 'wescle' ); ?></span> <span><?php _e( 'Выкл', 'wescle' ); ?></span></div>
                                        </label>
                                    </div>
                                </div>
								<?php
							}
							?>
                        </div>
                    </div>
					<?php
				}
				?>
	            <?php submit_button(); ?>
                <input type="hidden" name="save_customizer_sections" value="1">
            </form>
            <div class="_site-settings__recommended">
                <h2><?php _e( 'Wescle рекомендует', 'wescle' ); ?></h2>
                <div class="_site-settings__banners">
                    <div class="_site-settings-banner">
                        <div class="_site-settings-banner__img"><img src="<?php echo get_template_directory_uri(); ?>/assets/admin/img/wescle-youtube.jpg" alt="" loading="lazy"/></div>
                        <div class="_site-settings-banner__body">
                            <div class="_site-settings-banner__title"><?php _e( 'Подпишитесь на YouTube канал и получайте бесплатные уроки по настройке шаблона Wescle', 'wescle' ); ?></div>
                        </div>
                        <div class="_actions">
                            <a class="button button-primary" href="https://www.youtube.com/channel/UCIOS-IpaZW_VZBu-Ry_E9SA" target="_blank" rel="noopener noreferrer"><?php _e( 'Перейти на канал', 'wescle' ); ?></a>
                        </div>
                    </div>
                    <div class="_site-settings-banner">
                        <!--<div class="_site-settings-banner__img"><img src="./placeholder.jpg" alt="Image" width="180" height="110" loading="lazy"/></div>-->
                        <div class="_site-settings-banner__video">
                            <iframe width="560" height="315" src="https://www.youtube.com/embed/feVgXt4NLvc" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                        </div>
                        <div class="_site-settings-banner__body">
                            <div class="_site-settings-banner__title"><?php _e( 'Настройка блоков', 'wescle' ); ?></div>
                            <div class="_site-settings-banner__text"><?php _e( 'Обучение по работе с настройкой блоков и кастомайзера', 'wescle' ); ?></div>
                            <div class="_actions">
                                <a class="button button-primary" href="https://www.youtube.com/watch?v=feVgXt4NLvc" target="_blank" rel="noopener noreferrer"><?php _e( 'Посмотреть', 'wescle' ); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

	<?php include get_template_directory() . '/template-parts/admin/settings-footer.php' ?>
</div>