<?php
$current_user_id = get_current_user_id();
$pin_posts       = $args['pin_posts'];
?>
    <div class="annotation-wrap">
        <button class="btn-annotation" type="button" aria-expanded="true">
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                <path d="M20 2H4c-1.103 0-2 .894-2 1.992v12.016C2 17.106 2.897 18 4 18h3v4l6.351-4H20c1.103 0 2-.894 2-1.992V3.992A1.998 1.998 0 0 0 20 2zM8.999 14.999H7V13l5.53-5.522l1.998 1.999l-5.529 5.522zm6.472-6.464l-1.999-1.999l1.524-1.523l1.999 1.999l-1.524 1.523z" fill="#626262"></path>
            </svg>
            <span></span>
        </button>
        <button class="btn-close" type="button">
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                <path fill="#626262" d="M13.41 12l4.3-4.29a1 1 0 1 0-1.42-1.42L12 10.59l-4.29-4.3a1 1 0 0 0-1.42 1.42l4.3 4.29l-4.3 4.29a1 1 0 0 0 0 1.42a1 1 0 0 0 1.42 0l4.29-4.3l4.29 4.3a1 1 0 0 0 1.42 0a1 1 0 0 0 0-1.42z"></path>
            </svg>
        </button>
        <div class="annotation js-hide">
            <div class="annotation-body">
                <div class="annotation-desc">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                        <path d="M5.656 20.479A1 1 0 0 1 4 19.743V17.5a2 2 0 0 1-2-2v-7a2 2 0 0 1 2-2h11a2 2 0 0 1 2 2v7a2 2 0 0 1-2 2h-4.997l-4.347 2.979zM18 12.517a7.136 7.136 0 0 0 0 .369v-.37c.005-.107.006-1.447.004-4.019a3 3 0 0 0-3-2.997H7v-1a2 2 0 0 1 2-2h11a2 2 0 0 1 2 2v7a2 2 0 0 1-2 2v2.243a1 1 0 0 1-1.656.736L18 16.243v-3.726z" fill="#626262"></path>
                    </svg>
                    <div class="annotation-desc__title"><?php _e( 'Есть что сказать?', 'wescle' ); ?></div>
                    <div class="annotation-desc__text"><?php _e( 'Оставьте комментарий, чтобы начать обсуждение, сделайте заметку или добавьте примечание к монтажной области.', 'wescle' ); ?></div>
                </div>
                <div class="annotation-list" id="annotation-list" data-spollers>
					<?php
					$pins = [];
					$loop = 0;
					foreach ( $pin_posts as $post ) {
						setup_postdata( $post );

						$pin_number = '';
						$left       = get_post_meta( $post->ID, 'left', 1 );
						$top        = get_post_meta( $post->ID, 'right', 1 );
						if ( floatval( $left ) || floatval( $top ) ) {
							$pins[ $post->ID ] = 'position: absolute; z-index: 1000; left: ' . $left . 'px; top: ' . $top . 'px;';
							$loop ++;
							$pin_number = $loop;
						}
						get_template_part( 'template-parts/admin/annotation-item', null, [ 'pin_number' => $pin_number ] );
					}
					wp_reset_postdata();
					?>
                </div>
            </div>
            <div class="annotation-main-form">
                <form class="annotation-comment-form" action="#" id="annotation-main-form">
                    <div class="annotation-comment-form__top form-textarea" tabindex="0">
                        <textarea id="annotation-input" name="text" placeholder="<?php _e( 'Написать комментарий', 'wescle' ); ?>"></textarea>
                        <div class="annotation-comment-form__actions">
                            <div class="annotation-comment-form__for"><span><?php _e( 'Кому', 'wescle' ); ?>:</span><span class="annotation-comment-form__name"></span></div>
                            <button class="btn-mention" type="button" aria-label="Упомянуть пользователя">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 36 36">
                                    <path class="clr-i-outline clr-i-outline-path-1" d="M18 17a7.46 7.46 0 1 0-7.45-7.46A7.46 7.46 0 0 0 18 17zm0-12.93a5.46 5.46 0 1 1-5.45 5.45A5.46 5.46 0 0 1 18 4.07z" fill="#626262"></path>
                                    <path class="clr-i-outline clr-i-outline-path-2" d="M6 31.89v-6.12a16.13 16.13 0 0 1 12-5a16.61 16.61 0 0 1 8.71 2.33l1.35-1.51A18.53 18.53 0 0 0 18 18.74A17.7 17.7 0 0 0 4.21 24.8a1 1 0 0 0-.21.6v6.49A2.06 2.06 0 0 0 6 34h12.39l-1.9-2z" fill="#626262"></path>
                                    <path class="clr-i-outline clr-i-outline-path-3" d="M30 31.89V32h-3.15l-1.8 2H30a2.06 2.06 0 0 0 2-2.07V26.2l-2 2.23z" fill="#626262"></path>
                                    <path class="clr-i-outline clr-i-outline-path-4" d="M34.76 18.62a1 1 0 0 0-1.41.08l-11.62 13l-5.2-5.59a1 1 0 0 0-1.41-.11a1 1 0 0 0-.06 1.42l6.69 7.2L34.84 20a1 1 0 0 0-.08-1.38z" fill="#626262"></path>
                                </svg>
                            </button>
                        </div>
                        <div class="annotation-comment-form__users">
                            <div class="annotation-comment-form__users-list">
								<?php
								$users = get_users( [
									'role__in' => [ 'administrator', 'editor' ]
								] );
								foreach ( $users as $user ) {
									if ( $current_user_id == $user->ID ) {
										continue;
									}

									echo '<a href="#" data-id="' . $user->ID . '">@' . $user->display_name . '</a>';
								}
								?>
                            </div>
                        </div>
                    </div>
                    <div class="annotation-comment-form__bottom">
                        <button class="btn btn-main _hide" type="reset"><?php _e( 'Отмена', 'wescle' ); ?></button>
                        <button class="btn btn-main" type="button" id="annotation-button-submit"><?php _e( 'Отправить', 'wescle' ); ?></button>
                        <input type="hidden" name="object_type" id="input_object_type" value="<?php echo $args['object_type']; ?>">
                        <input type="hidden" name="object_id" id="input_object_id" value="<?php echo $args['object_id']; ?>">
                        <input type="hidden" name="rel_users" id="input_rel_users" value="">
                        <input type="hidden" name="pin_id" id="input_pin_id" value="">
                        <input type="hidden" name="comment_id" id="input_comment_id" value="">
                        <input type="hidden" name="comment_post_ID" id="input_comment_post_ID" value="">
                        <input type="hidden" name="comment_parent" id="input_comment_parent" value="">
                        <input type="hidden" name="action" id="annotation_form_action" value="create_new_pin">
                    </div>
                </form>
            </div>
            <div class="annotation-bottom">
		        <?php
		        $is_hide = ' hide';
		        if ( $pin_posts ) {
			        $is_hide = '';
		        }
		        ?>
                <div class="annotation-filters<?php echo $is_hide; ?>">
                    <button class="annotation-filters__btn" type="button"><strong><?php _e( 'Фильтр по', 'wescle' ); ?>:</strong><span><?php _ex( 'Все', 'pins', 'wescle' ); ?></span></button>
                    <div class="annotation-filters__dropdown">
                        <div class="annotation-filters__dropdown-list">
                            <a href="#" class="current" data-type="all"><?php _ex( 'Все', 'pins', 'wescle' ); ?></a>
                            <a href="#" data-type="my"><?php _ex( 'Мои', 'pins', 'wescle' ); ?></a>
                            <a href="#" data-type="completed"><?php _ex( 'Выполнено', 'pins', 'wescle' ); ?></a>
                        </div>
                    </div>
                </div>
                <button class="btn-hide-comment" type="button" aria-expanded="true">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                        <path d="M20 12v4c0 1.11-.89 2-2 2h-4.1l-3.7 3.71c-.2.18-.44.29-.7.29H9a1 1 0 0 1-1-1v-3H4a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h5.5c-.55.67-1 1.42-1.36 2.25L7.85 7l.29.75C9.43 10.94 12.5 13 16 13c1.44 0 2.8-.37 4-1m-4-6c.56 0 1 .44 1 1s-.44 1-1 1s-1-.44-1-1s.44-1 1-1m0-3c2.73 0 5.06 1.66 6 4c-.94 2.34-3.27 4-6 4s-5.06-1.66-6-4c.94-2.34 3.27-4 6-4m0 1.5A2.5 2.5 0 0 0 13.5 7A2.5 2.5 0 0 0 16 9.5A2.5 2.5 0 0 0 18.5 7A2.5 2.5 0 0 0 16 4.5" fill="#626262"></path>
                    </svg>
                </button>
            </div>
        </div>
    </div>
<?php
if ( $pin_posts ) {
	$loop = 0;
	foreach ( $pins as $pin_id => $pin_style ) {
		$loop ++;

		$move_access = $current_user_id == $post->post_author ? 'true' : 'false';
		echo '<span class="annotation-id clone" data-pin-number="' . $loop . '" data-pin-id="' . $pin_id . '" data-access="' . $move_access . '" style="' . $pin_style . '">' . $loop . '</span>';
	}
}
?>