<?php
global $post;

$current_user_id = get_current_user_id();

$pin_number  = $args['pin_number'] ?? '';
$author_id   = $post->post_author;
$author      = get_user_by( 'id', $author_id );
$h_time      = sprintf( __( '%s ago' ), human_time_diff( get_the_time( 'U' ), current_time( 'U' ) ) );
$edit_access = ( $current_user_id == $post->post_author ) || current_user_can( 'administrator' );
$move_access = $current_user_id == $post->post_author;
if ( $post->post_status != 'pending' ) {
	$move_access = false;
}
$item_active_class = '';
if ( $pin_number && $post->post_status == 'pending' ) {
	$item_active_class = 'js-active';
}
?>
<div class="annotation-item annotation-item-post <?php echo $item_active_class; ?>" id="annotation-item-<?php echo $post->ID; ?>" data-pin-number="<?php echo $pin_number; ?>" data-pin-id="<?php echo $post->ID; ?>">
    <div class="annotation-item__info">
        <div class="annotation-item__photo">
            <picture>
				<?php echo get_avatar( $author_id, 35 ); ?>
            </picture>
            <span class="annotation-id"><?php echo $pin_number; ?></span>
        </div>
        <div class="annotation-item__user">
            <div class="annotation-item__name"><?php echo $author->display_name; ?></div>
            <div class="annotation-item__time"><?php echo $h_time; ?></div>
        </div>
		<?php if ( $edit_access ) { ?>
            <div class="annotation-item__actions">
                <button class="btn-actions" type="button" aria-label="<?php _e( 'Действия', 'wescle' ); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 16 16">
                        <g fill="#626262">
                            <path d="M3 9.5a1.5 1.5 0 1 1 0-3a1.5 1.5 0 0 1 0 3zm5 0a1.5 1.5 0 1 1 0-3a1.5 1.5 0 0 1 0 3zm5 0a1.5 1.5 0 1 1 0-3a1.5 1.5 0 0 1 0 3z"></path>
                        </g>
                    </svg>
                </button>
                <div class="annotation-item__actions-body annotation-item__buttons js-hide">
					<?php if ( $post->post_status == 'pending' ) { ?>
                        <button class="btn-allow" type="button" data-type="success" aria-label="<?php _e( 'Выполнено', 'wescle' ); ?>" data-post_id="<?php echo $post->ID; ?>">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1.18em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 1179 1000">
                                <path d="M1179 72Q929 294 579 822l-115 179Q320 821 0 501l107-107l286 250q150-150 279-271.5T877.5 185T1009 74t77-59l21-14q4 0 11 2t26 19.5t35 49.5z" fill="#626262"></path>
                            </svg>
                            <span><?php _e( 'Выполнено', 'wescle' ); ?></span>
                        </button>
                        <button class="btn-change" type="button" data-type="change" aria-label="<?php _e( 'Изменить', 'wescle' ); ?>" data-post_id="<?php echo $post->ID; ?>">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                <path d="M16 2.012l3 3L16.713 7.3l-3-3z" fill="#626262"></path>
                                <path d="M4 14v3h3l8.299-8.287l-3-3zm0 6h16v2H4z" fill="#626262"></path>
                            </svg>
                            <span><?php _e( 'Изменить', 'wescle' ); ?></span>
                        </button>
					<?php } ?>
                    <button class="btn-delete" type="button" data-type="delete" aria-label="<?php _e( 'Удалить', 'wescle' ); ?>" data-post_id="<?php echo $post->ID; ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                            <g fill="none">
                                <path d="M21.5 6a1 1 0 0 1-.883.993L20.5 7h-.845l-1.231 12.52A2.75 2.75 0 0 1 15.687 22H8.313a2.75 2.75 0 0 1-2.737-2.48L4.345 7H3.5a1 1 0 0 1 0-2h5a3.5 3.5 0 1 1 7 0h5a1 1 0 0 1 1 1zm-7.25 3.25a.75.75 0 0 0-.743.648L13.5 10v7l.007.102a.75.75 0 0 0 1.486 0L15 17v-7l-.007-.102a.75.75 0 0 0-.743-.648zm-4.5 0a.75.75 0 0 0-.743.648L9 10v7l.007.102a.75.75 0 0 0 1.486 0L10.5 17v-7l-.007-.102a.75.75 0 0 0-.743-.648zM12 3.5A1.5 1.5 0 0 0 10.5 5h3A1.5 1.5 0 0 0 12 3.5z"
                                      fill="#626262"></path>
                            </g>
                        </svg>
                        <span><?php _e( 'Удалить', 'wescle' ); ?></span>
                    </button>
                </div>
            </div>
		<?php } ?>
    </div>
	<?php
	$text = nl2br( $post->post_content );
	$text = str_replace( '<a ', '<a target="_blank"', $text );

	$rel_user_name = WsclAdminAnnotation::get_rel_user_name( null, $post );
	?>
    <div class="annotation-item__text" id="annotation-item__text-<?php echo $post->ID; ?>"><?php echo $rel_user_name; ?><?php echo $text; ?></div>
    <div class="hide" data-username="<?php echo strip_tags( $rel_user_name ); ?>" id="annotation-item__hidden-text-<?php echo $post->ID; ?>"><?php echo $text; ?></div>
    <div class="annotation-item__bottom">
		<?php if ( $move_access ) { ?>
            <button class="btn-pin" type="button" aria-label="<?php _e( 'Поставить метку', 'wescle' ); ?>">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 16 16">
                    <g fill="#626262">
                        <path d="M9.828.722a.5.5 0 0 1 .354.146l4.95 4.95a.5.5 0 0 1 0 .707c-.48.48-1.072.588-1.503.588c-.177 0-.335-.018-.46-.039l-3.134 3.134a5.927 5.927 0 0 1 .16 1.013c.046.702-.032 1.687-.72 2.375a.5.5 0 0 1-.707 0l-2.829-2.828l-3.182 3.182c-.195.195-1.219.902-1.414.707c-.195-.195.512-1.22.707-1.414l3.182-3.182l-2.828-2.829a.5.5 0 0 1 0-.707c.688-.688 1.673-.767 2.375-.72a5.922 5.922 0 0 1 1.013.16l3.134-3.133a2.772 2.772 0 0 1-.04-.461c0-.43.108-1.022.589-1.503a.5.5 0 0 1 .353-.146z"></path>
                    </g>
                </svg>
            </button>
		<?php } ?>
		<?php if ( $post->post_status == 'pending' ) { ?>
            <button class="btn btn-main btn-answer btn-answer-pin" data-pin_id="<?php echo $post->ID; ?>" type="button"><?php _e( 'Ответить', 'wescle' ); ?></button>
		<?php } ?>
		<?php
		$attr_hidden = '';
		if ( ! get_comments_number() ) {
			$attr_hidden = 'hidden';
		}
		?>
        <div class="annotation-answers" <?php echo $attr_hidden; ?>>
            <button class="annotation-answers-count" type="button" data-spoller="">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" preserveAspectRatio="xMidYMid meet" viewBox="0 0 20 20">
                    <path d="M5 6l5 5l5-5l2 1l-7 7l-7-7z" fill="#626262"></path>
                </svg>
                <span><?php echo WsclAdminAnnotation::str_count_answers( get_comments_number() ); ?></span>
            </button>
            <div class="annotation-answers__body" hidden>
				<?php
				$comments = get_comments( [
					'post_id'      => $post->ID,
					'order'        => 'ASC',
					'hierarchical' => 'threaded',
					'type'         => 'pin_comment',
				] );
				WsclAdminAnnotation::annotation_html_comments( $comments );
				?>
            </div>
        </div>
    </div>
</div>
