<?php
$comment = $args['comment'];
$post    = get_post( $comment->comment_post_ID );
$author  = get_user_by( 'id', $comment->user_id );
$h_time  = sprintf( __( '%s ago' ), human_time_diff( get_comment_date( 'U', $comment ), current_time( 'U' ) ) );
// 2
?>
<div class="annotation-item" id="annotation-comment-<?php echo $comment->comment_ID; ?>">
    <div class="annotation-item__info">
        <div class="annotation-item__photo">
			<?php echo get_avatar( $author->ID, 35 ); ?>
        </div>
        <div class="annotation-item__user">
            <div class="annotation-item__name"><?php echo $author->display_name; ?></div>
            <div class="annotation-item__time"><?php echo $h_time; ?></div>
        </div>
		<?php if ( $author->ID == get_current_user_id() && 'pending' == $post->post_status ) { ?>
            <div class="annotation-item__actions">
                <button class="btn-actions" type="button" aria-label="<?php _e( 'Действия', 'wescle' ); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 16 16">
                        <g fill="#626262">
                            <path d="M3 9.5a1.5 1.5 0 1 1 0-3a1.5 1.5 0 0 1 0 3zm5 0a1.5 1.5 0 1 1 0-3a1.5 1.5 0 0 1 0 3zm5 0a1.5 1.5 0 1 1 0-3a1.5 1.5 0 0 1 0 3z"></path>
                        </g>
                    </svg>
                </button>
                <div class="annotation-item__actions-body annotation-comment__buttons js-hide">
                    <button class="btn-change" type="button" data-type="change" aria-label="<?php _e( 'Изменить', 'wescle' ); ?>" data-id="<?php echo $comment->comment_ID; ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 24 24">
                            <path d="M16 2.012l3 3L16.713 7.3l-3-3z" fill="#626262"></path>
                            <path d="M4 14v3h3l8.299-8.287l-3-3zm0 6h16v2H4z" fill="#626262"></path>
                        </svg>
                        <span><?php _e( 'Изменить', 'wescle' ); ?></span>
                    </button>
                    <button class="btn-delete" type="button" data-type="delete" aria-label="<?php _e( 'Удалить', 'wescle' ); ?>" data-id="<?php echo $comment->comment_ID; ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 24 24">
                            <g fill="none">
                                <path d="M21.5 6a1 1 0 0 1-.883.993L20.5 7h-.845l-1.231 12.52A2.75 2.75 0 0 1 15.687 22H8.313a2.75 2.75 0 0 1-2.737-2.48L4.345 7H3.5a1 1 0 0 1 0-2h5a3.5 3.5 0 1 1 7 0h5a1 1 0 0 1 1 1zm-7.25 3.25a.75.75 0 0 0-.743.648L13.5 10v7l.007.102a.75.75 0 0 0 1.486 0L15 17v-7l-.007-.102a.75.75 0 0 0-.743-.648zm-4.5 0a.75.75 0 0 0-.743.648L9 10v7l.007.102a.75.75 0 0 0 1.486 0L10.5 17v-7l-.007-.102a.75.75 0 0 0-.743-.648zM12 3.5A1.5 1.5 0 0 0 10.5 5h3A1.5 1.5 0 0 0 12 3.5z"
                                      fill="#626262"></path>
                            </g>
                        </svg>
                        <span><?php _e( 'Удалить', 'wescle' ); ?></span>
                    </button>
                </div>
            </div>
		<?php } ?>
    </div>
	<?php
	$text = nl2br( $comment->comment_content );
	$text = str_replace( '<a ', '<a target="_blank"', $text );

	$rel_user_name = WsclAdminAnnotation::get_rel_user_name( $comment );
	?>
    <div class="annotation-item__text" id="annotation-comment__text-<?php echo $comment->comment_ID; ?>"><?php echo $rel_user_name; ?><?php echo $text; ?></div>
    <div class="hide" data-username="<?php echo strip_tags( $rel_user_name ); ?>" id="annotation-comment__hidden-text-<?php echo $comment->comment_ID; ?>"><?php echo $text; ?></div>
	<?php if ( $post->post_status == 'pending' ) { ?>
        <div class="annotation-item__bottom">
            <button class="btn btn-main btn-answer btn-answer-comment" data-comment_ID="<?php echo $comment->comment_ID; ?>" data-pin_id="<?php echo $comment->comment_post_ID; ?>" type="button"><?php _e( 'Ответить', 'wescle' ); ?></button>
        </div>
	<?php } ?>
</div>