<?php
add_action( 'woocommerce_before_main_content', 'wescle_before_content', 10 );
add_action( 'woocommerce_after_main_content', 'wescle_after_content_seo', 5 );
add_action( 'woocommerce_after_main_content', 'wescle_after_content', 10 );

add_filter( 'woocommerce_before_shop_loop', 'wescle_show_product_subcategories', 3 );
add_filter( 'woocommerce_before_shop_loop', 'wescle_show_cat_brands', 3 );
add_filter( 'woocommerce_before_shop_loop', 'wescle_show_cat_tags', 4 );

add_action( 'woocommerce_before_shop_loop', 'wescle_before_shop_loop', 5 );
add_action( 'woocommerce_before_shop_loop', 'wescle_sorting_wrapper', 19 );
add_action( 'woocommerce_before_shop_loop', 'wescle_shop_filters', 20 );
add_action( 'woocommerce_before_shop_loop', 'wescle_views_mode', 21 );
add_action( 'woocommerce_before_shop_loop', 'wescle_sorting_wrapper_close', 99 );

add_filter( 'woocommerce_product_loop_start', 'wescle_product_loop_start', 5 );
add_filter( 'woocommerce_product_loop_end', 'wescle_product_loop_end', 15 );

add_action( 'woocommerce_after_shop_loop', 'wescle_goods_bottom_open', 5 );
add_action( 'woocommerce_after_shop_loop', 'wescle_goods_bottom_pagination', 20 );
add_action( 'woocommerce_after_shop_loop', 'wescle_goods_bottom_showing', 30 );
add_action( 'woocommerce_after_shop_loop', 'wescle_goods_bottom_close', 31 );
add_action( 'woocommerce_after_shop_loop', 'wescle_after_shop_loop', 99 );

add_action( 'woocommerce_before_single_product', 'wescle_before_single_product_wrap_open', 5 );
add_action( 'woocommerce_after_single_product', 'wescle_before_single_product_wrap_close', 5 );

add_action( 'woocommerce_before_main_content', 'wescle_woocommerce_breadcrumb', 20 );

add_action( 'woocommerce_after_add_to_cart_button', 'wescle_wishlist_after_cart_form' );
add_action( 'woocommerce_after_add_to_cart_button', 'wescle_compare_loop_item', 15 );

add_action( 'woocommerce_single_product_summary', 'wescle_product_features_html', 80 );
add_action( 'woocommerce_after_single_product_summary', 'wescle_product_additionally_html', 5 );
add_filter( 'woocommerce_product_tabs', 'wescle_product_features_tab' );

add_filter( 'woocommerce_loop_add_to_cart_link', 'wescle_loop_add_to_cart_link', 15, 3 );

add_action( 'init', 'position_stock_rating_in_loop', 5 );

add_action( 'woocommerce_before_quantity_input_field', 'wescle_before_quantity_input_field' );
add_action( 'woocommerce_after_quantity_input_field', 'wescle_after_quantity_input_field' );

function wescle_before_content() {
	?>
    <div class="content">
    <div class="container">
    <div class="row content__row">
    <div class="col content__col content__col_big">
    <div class="content__body">
	<?php
}

function wescle_after_content() {
	?>
    </div><!-- .content__body -->
    </div><!-- .content__col_big -->
	<?php woocommerce_get_sidebar(); ?>
    </div><!-- .row -->
    </div><!-- .container -->
    </div><!-- .content -->
	<?php
}

if ( ! function_exists( 'wescle_after_content_seo' ) ) {
	function wescle_after_content_seo() {
		if ( is_archive() ) {
			$text = get_term_meta( get_queried_object_id(), 'description_bottom', 1 );
			if ( $text ) {
				$text        = str_replace( [ '<h1>', '<h2>' ], [ '<h1 class="seo__title title title_divider">', '<h2 class="seo__title title title_divider">' ], $text );
				$label_open  = Helper::get_text_label( 'open' );
				$label_close = Helper::get_text_label( 'close' );
				?>
                <div class="seo" id="seo">
                    <div class="container">
                        <div class="seo__body">
                            <div class="seo__text">
								<?php echo wpautop( do_shortcode( $text ) ); ?>
                            </div>
                            <button class="btn_expand js-hide" type="button" data-text-open="<?php echo $label_open; ?>" data-text-close="<?php echo $label_close; ?>" data-height="200">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                    <g fill="none">
                                        <path d="M4 9l8 8l8-8" stroke="#626262" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </g>
                                </svg>
                                <span><?php echo $label_open; ?></span>
                            </button>
                        </div>
                    </div>
                </div>
				<?php
			}
		}
	}
}

function wescle_show_product_subcategories() {
	$html = woocommerce_maybe_show_product_subcategories();
	if ( $html ) {
		$slider_enable = get_theme_mod( 'category_slider_enable', true );
		$count_slides  = get_theme_mod( 'category_count_slides', 5 );
		$slider_speed  = intval( get_theme_mod( 'category_slider_speed', 8 ) ) * 1000;
		$slider_arrows = get_theme_mod( 'category_slider_arrows', true ) ? 'true' : 'false';
		$slider_dots   = get_theme_mod( 'category_slider_dots', false ) ? 'true' : 'false';

		$section_id    = 'goods-categories-noslider';
		$section_class = 'goods-categories-noslider goods-categories';
		if ( $slider_enable ) {
			$section_id    = 'goods-categories';
			$section_class = 'goods-slider-section goods-categories';
		}
		?>
        <div class="<?php echo $section_class; ?>" id="<?php echo $section_id; ?>">
            <div class="container">
				<?php if ( $slider_enable ) { ?>
                    <div class="slider-wrapper">
                        <div class="goods-categories__buttons slider-buttons">
                            <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                    <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                                </svg>
                            </button>
                            <button class="slider-buttons__item slider-buttons__item_next" type="button">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                    <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                                </svg>
                            </button>
                        </div>
                        <div class="goods-categories__slider" data-slides="<?php echo $count_slides; ?>" data-autoplay-speed="<?php echo $slider_speed; ?>" data-dots="<?php echo $slider_dots; ?>" data-arrows="<?php echo $slider_arrows; ?>">
		                    <?php echo $html; ?>
                        </div>
                    </div>
				<?php } else { ?>
                    <div class="goods-categories__grid _grid-<?php echo get_theme_mod( 'category_grid_count', 5 ); ?>">
						<?php echo $html; ?>
                    </div>
				<?php } ?>
            </div>
        </div>
		<?php
	}
}

function wescle_before_shop_loop() {
	if ( wc_get_loop_prop( 'total' ) ) {
		echo '<div class="goods">';
	}
}

function wescle_after_shop_loop() {
	if ( wc_get_loop_prop( 'total' ) ) {
		echo '</div>';
	}
}

function wescle_product_loop_start() {
	$columns = wc_get_default_products_per_row();
	if ( is_cart() ) {
		$columns = $columns + 1;
	}

	return '<div class="goods-body"><div class="goods-body__row products columns-' . $columns . '">';
}

function wescle_product_loop_end() {
	return '</div></div><!-- .goods-body -->';
}

function wescle_sorting_wrapper() {
	if ( wc_get_loop_prop( 'total' ) ) {
		echo '<div class="goods-header"><div class="goods-header__row">';
	}
}

function wescle_sorting_wrapper_close() {
	if ( wc_get_loop_prop( 'total' ) ) {
		echo '</div></div><!-- .goods-header -->';
	}
}

function wescle_goods_bottom_open() {
	if ( wc_get_loop_prop( 'total' ) ) {
		echo '<div class="goods-bottom"><div class="goods-bottom__row">';
	}
}

function wescle_goods_bottom_close() {
	if ( wc_get_loop_prop( 'total' ) ) {
		echo '</div></div><!-- .goods-bottom -->';
	}
}

function wescle_shop_filters() {
	if ( wc_get_loop_prop( 'total' ) ) {
		?>
        <div class="goods-header__col">
            <div class="goods-header__filters">
				<?php if ( Helper::is_shop_filter_active() ) { ?>
                    <div class="_goods-filter-wrap" type="button">
                        <button class="btn btn-main btn-main_blue">
                            <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img" width="1em" height="1em" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                <path fill="currentColor" d="M21 3H5a1 1 0 0 0-1 1v2.59c0 .523.213 1.037.583 1.407L10 13.414V21a1.001 1.001 0 0 0 1.447.895l4-2c.339-.17.553-.516.553-.895v-5.586l5.417-5.417c.37-.37.583-.884.583-1.407V4a1 1 0 0 0-1-1zm-6.707 9.293A.996.996 0 0 0 14 13v5.382l-2 1V13a.996.996 0 0 0-.293-.707L6 6.59V5h14.001l.002 1.583l-5.71 5.71z"></path>
                            </svg>
                            <span><?php _e( 'Фильтры', 'wescle' ); ?></span>
                        </button>
                    </div>
				<?php } ?>
				<?php woocommerce_catalog_ordering(); ?>
				<?php wescle_shop_filters_showing(); ?>
            </div>
        </div>
		<?php
	}
}

function wescle_shop_filters_showing() {
	$label        = __( 'Отображать', 'wescle' );
	$basic        = wc_get_default_products_per_row() * wc_get_default_product_rows_per_page();
	$numbers      = apply_filters( 'wescle_woo_showing', [
		$basic,
		$basic * 2,
		$basic * 3,
		$basic * 4,
	] );
	$current_show = isset( $_GET['show'] ) ? $_GET['show'] : '';
	if ( ! $numbers ) {
		return;
	}
	?>
    <form class="goods-showing" method="get">
		<?php woocommerce_result_count(); ?>
		<?php wc_query_string_form_fields( null, array( 'show', 'submit', 'paged', 'product-page' ) ); ?>
        <select name="show">
			<?php foreach ( $numbers as $number ) { ?>
                <option value="<?php echo $number; ?>" <?php selected( $number, $current_show ); ?>><?php echo $label; ?>: <?php echo $number; ?></option>
			<?php } ?>
        </select>
        <input type="hidden" name="paged" value="1"/>
    </form>
	<?php
}

function wescle_goods_bottom_pagination() {
	if ( wc_get_loop_prop( 'total' ) ) {
		?>
        <div class="goods-bottom__col">
			<?php woocommerce_pagination(); ?>
        </div>
		<?php
	}
}

function wescle_goods_bottom_showing() {
	if ( wc_get_loop_prop( 'total' ) ) {
		?>
        <div class="goods-bottom__col">
            <div class="goods-bottom__showing">
				<?php wescle_shop_filters_showing(); ?>
            </div>
        </div>
		<?php
	}
}

function wescle_views_mode() {
	if ( wc_get_loop_prop( 'total' ) ) {
		?>
        <div class="goods-header__col">
            <div class="display-mode"><a class="active" href="#grid" data-display-mode="grid">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 16 16">
                        <g fill="#626262">
                            <path d="M4 2v2H2V2h2zm1 12v-2a1 1 0 0 0-1-1H2a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1zm0-5V7a1 1 0 0 0-1-1H2a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1zm0-5V2a1 1 0 0 0-1-1H2a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1zm5 10v-2a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1zm0-5V7a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1zm0-5V2a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1zM9 2v2H7V2h2zm5 0v2h-2V2h2zM4 7v2H2V7h2zm5 0v2H7V7h2zm5 0h-2v2h2V7zM4 12v2H2v-2h2zm5 0v2H7v-2h2zm5 0v2h-2v-2h2zM12 1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1h-2zm-1 6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1h-2a1 1 0 0 1-1-1V7zm1 4a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1h-2z"></path>
                        </g>
                    </svg>
                </a><a href="#list" data-display-mode="list">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 512 512">
                        <path fill="#626262" d="M136 24H16v120h120zm-32 88H48V56h56z"></path>
                        <path fill="#626262" d="M136 200H16v120h120zm-32 88H48v-56h56z"></path>
                        <path fill="#626262" d="M136 376H16v120h120zm-32 88H48v-56h56z"></path>
                        <path fill="#626262" d="M176 23.998h320v32H176z"></path>
                        <path fill="#626262" d="M176 111.998h256v32H176z"></path>
                        <path fill="#626262" d="M176 199.998h320v32H176z"></path>
                        <path fill="#626262" d="M176 287.998h256v32H176z"></path>
                        <path fill="#626262" d="M176 463.998h256v32H176z"></path>
                        <path fill="#626262" d="M176 375.998h320v32H176z"></path>
                    </svg>
                </a></div>
        </div>
		<?php
	}
}

function wescle_before_single_product_wrap_open() {
	echo '<div class="goods">';
}

function wescle_before_single_product_wrap_close() {
	echo '</div>';
}

if ( ! function_exists( 'wescle_woocommerce_breadcrumb' ) ) {
	function wescle_woocommerce_breadcrumb() {
		get_template_part( 'template-parts/breadcrumbs' );
	}
}


if ( ! function_exists( 'wescle_cart_link' ) ) {
	function wescle_cart_link( $type = '' ) {
		if ( ! WC()->cart ) {
			return;
		}
		$cart_title = get_theme_mod( 'cart_title', Helper::get_default_theme_data( 'cart_title' ) );
		$svg_icon   = '<svg xmlns="http://www.w3.org/2000/svg" width="29.248" height="28.801" viewbox="0 0 29.248 28.801"> <path id="md-cart" d="M11.925,26.55a2.925,2.925,0,1,0,2.925,2.925A2.933,2.933,0,0,0,11.925,26.55ZM3.375,3.6V6.525H6.3L11.565,17.19l-2.2,3.583A2.808,2.808,0,0,0,9,22.163c0,1.958,1.338,2.925,3.152,2.925h17.1V22.275H12.508a.346.346,0,0,1-.366-.366,1.826,1.826,0,0,1,.155-.366l1.461-2.306h10.9A2.869,2.869,0,0,0,27.212,17.7l5.265-9.056a1.709,1.709,0,0,0,.146-.731,1.406,1.406,0,0,0-1.463-1.39H9.518L8.128,3.6Zm22.95,22.95a2.925,2.925,0,1,0,2.925,2.925A2.933,2.933,0,0,0,26.325,26.55Z" transform="translate(-3.375 -3.6)"></path> </svg>';
		if ( get_theme_mod( 'cart_icon_type' ) == 2 ) {
			$svg_icon = '<svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img" width="1em" height="1em" preserveaspectratio="xMidYMid meet" viewbox="0 0 32 32"> <path fill="currentColor" d="M16 3c-2.746 0-5 2.254-5 5v1H6.062L6 9.938l-1 18L4.937 29h22.125L27 27.937l-1-18L25.937 9H21V8c0-2.746-2.254-5-5-5zm0 2a3 3 0 0 1 3 3v1h-6V8a3 3 0 0 1 3-3zm-8.063 6H11v3h2v-3h6v3h2v-3h3.063l.875 16H7.063z"></path> </svg>';
		}
		if ( get_theme_mod( 'cart_icon_svg' ) ) {
			$svg_icon = get_theme_mod( 'cart_icon_svg' );
		}
		?>
        <a href="<?php echo esc_url( wc_get_cart_url() ); ?>" title="<?php esc_attr_e( 'Просмотреть корзину с покупками', 'wescle' ); ?>" class="cart-contents">
            <span><?php echo WC()->cart->get_cart_contents_count(); ?></span>
			<?php if ( Helper::is_header_store_center() ) { ?>
				<?php echo $svg_icon; ?>
				<?php if ( get_theme_mod( 'cart_title_visible', true ) ) { ?>
                    <strong><?php echo $cart_title; ?></strong>
				<?php } ?>
			<?php } else { ?>
				<?php echo $svg_icon; ?>
			<?php } ?>
        </a>
		<?php
	}
}

if ( ! function_exists( 'wescle_wishlist_link' ) ) {
	function wescle_wishlist_link( $type = '' ) {
		$wescle_wishlist_ids = ! empty( $_COOKIE['wescle_wishlist'] ) ? (array) explode( '|', wp_unslash( $_COOKIE['wescle_wishlist'] ) ) : array(); // @codingStandardsIgnoreLine

		$count = count( $wescle_wishlist_ids );
		$url   = Helper::get_wishlist_page_url();

		$wishlist_title = Helper::is_header_store_center() && $type == 'store-center' ? get_theme_mod( 'wishlist_title' ) : '';
		$svg_icon       = '<svg xmlns="http://www.w3.org/2000/svg" width="35.999" height="30.858" viewbox="0 0 35.999 30.858"><path id="heart" d="M18,30.857a1.2,1.2,0,0,1-.884-.362L4.58,18.4a6.656,6.656,0,0,1-.552-.522q-.351-.361-1.115-1.316A17.741,17.741,0,0,1,1.547,14.6,12.21,12.21,0,0,1,.472,12.174,8.767,8.767,0,0,1,0,9.4,9.215,9.215,0,0,1,2.551,2.491,9.664,9.664,0,0,1,9.6,0a8,8,0,0,1,2.541.432A10.319,10.319,0,0,1,14.555,1.6q1.116.733,1.918,1.376A18.929,18.929,0,0,1,18,4.339a18.485,18.485,0,0,1,1.527-1.366q.8-.643,1.919-1.376A10.293,10.293,0,0,1,23.857.432,8,8,0,0,1,26.4,0a9.662,9.662,0,0,1,7.051,2.491A9.215,9.215,0,0,1,36,9.4q0,4.44-4.6,9.04L18.883,30.5a1.2,1.2,0,0,1-.884.362Z"></path></svg>';
		if ( get_theme_mod( 'wishlist_icon_type' ) == 2 ) {
			$svg_icon = '<svg height="512" viewBox="0 0 32 32" width="512" xmlns="http://www.w3.org/2000/svg"><g id="love"><path d="m27.78 6.07a7.58 7.58 0 0 0 -10.7 0l-1.08 1.08-1.08-1.08a7.58 7.58 0 0 0 -10.7 0 7.59 7.59 0 0 0 0 10.71l11.07 11.07a1 1 0 0 0 1.42 0l11.07-11.07a7.59 7.59 0 0 0 0-10.71zm-1.41 9.29-10.37 10.37-10.37-10.37a5.57 5.57 0 0 1 0-7.87 5.58 5.58 0 0 1 7.88 0l1.78 1.78a1 1 0 0 0 1.42 0l1.78-1.78a5.58 5.58 0 0 1 7.88 0 5.57 5.57 0 0 1 0 7.87z"/></g></svg>';
		}
		if ( get_theme_mod( 'wishlist_icon_svg' ) ) {
			$svg_icon = get_theme_mod( 'wishlist_icon_svg' );
		}

		$link_class = $type == 'store-center' ? ' navigation-store__wishlist' : '';
		?>
        <a href="<?php echo $url; ?>" class="wishlist_products_counter<?php echo $link_class; ?>">
            <span class="wishlist_products_counter_number"><?php echo $count; ?></span>
			<?php echo $svg_icon; ?>
			<?php if ( $wishlist_title ) { ?>
                <strong><?php echo $wishlist_title; ?></strong>
			<?php } ?>
        </a>
		<?php
	}
}

if ( ! function_exists( 'wescle_compare_link' ) ) {
	function wescle_compare_link( $type = '' ) {
		if ( ! Helper::is_active_compare() ) {
			return;
		}

		$wescle_compare_ids = ! empty( $_COOKIE['wescle_compare'] ) ? (array) explode( '|', wp_unslash( $_COOKIE['wescle_compare'] ) ) : array(); // @codingStandardsIgnoreLine

		$count = count( $wescle_compare_ids );
		$url   = Helper::get_compare_page_url();

		$svg_icon = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 32 32"><path d="M28 6H18V4a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h10v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM4 15h6.17l-2.58 2.59L9 19l5-5l-5-5l-1.41 1.41L10.17 13H4V4h12v20H4zm12 13v-2a2 2 0 0 0 2-2V8h10v9h-6.17l2.58-2.59L23 13l-5 5l5 5l1.41-1.41L21.83 19H28v9z" fill="#626262"></path></svg>';
		?>
        <a class="_compare-toggle" href="<?php echo $url; ?>"><?php echo $svg_icon; ?><span><?php echo $count; ?></span></a>
		<?php
	}
}

if ( ! function_exists( 'wescle_product_label_sale' ) ) {
	function wescle_product_label_sale( $product ) {
		if ( $product->is_on_sale() && ! $product->is_type( 'variable' ) && ! $product->is_type( 'grouped' ) ) {
			$regular_price = (float) $product->get_regular_price(); // Regular price
			$sale_price    = (float) $product->get_price(); // Active price (the "Sale price" when on-sale)

			// "Saving price" calculation and formatting
			$saving_price = $regular_price - $sale_price;
			if ( $saving_price ) {
				$saving_price = wc_price( $regular_price - $sale_price );
				// <span class="product-cart__sale-amount">
				?>
                <div class="product-cart__sale">&minus;<?php echo $saving_price; ?></div>
				<?php
			}
		}
	}
}


function woocommerce_subcategory_thumbnail( $category ) {
	$small_thumbnail_size = apply_filters( 'subcategory_archive_thumbnail_size', 'woocommerce_thumbnail' );
	$dimensions           = wc_get_image_size( $small_thumbnail_size );
	$thumbnail_id         = get_term_meta( $category->term_id, 'thumbnail_id', true );

	if ( $thumbnail_id ) {
		$image        = wp_get_attachment_image_src( $thumbnail_id, $small_thumbnail_size );
		$image        = $image[0];
		$image_srcset = function_exists( 'wp_get_attachment_image_srcset' ) ? wp_get_attachment_image_srcset( $thumbnail_id, $small_thumbnail_size ) : false;
		$image_sizes  = function_exists( 'wp_get_attachment_image_sizes' ) ? wp_get_attachment_image_sizes( $thumbnail_id, $small_thumbnail_size ) : false;
	}
	else {
		$image        = wc_placeholder_img_src();
		$image_srcset = false;
		$image_sizes  = false;
	}

	if ( $image ) {
		// Prevent esc_url from breaking spaces in urls for image embeds.
		// Ref: https://core.trac.wordpress.org/ticket/23605.
		$image = str_replace( ' ', '%20', $image );

		// Add responsive image markup if available.
		if ( $image_srcset && $image_sizes ) {
			echo '<img loading="lazy" src="' . esc_url( $image ) . '" alt="' . esc_attr( $category->name ) . '" width="' . esc_attr( $dimensions['width'] ) . '" height="' . esc_attr( $dimensions['height'] ) . '" srcset="' . esc_attr( $image_srcset ) . '" sizes="' . esc_attr( $image_sizes ) . '" />';
		}
		else {
			echo '<img loading="lazy" src="' . esc_url( $image ) . '" alt="' . esc_attr( $category->name ) . '" width="' . esc_attr( $dimensions['width'] ) . '" height="' . esc_attr( $dimensions['height'] ) . '" />';
		}
	}
}

if ( ! function_exists( 'wescle_login_navigation' ) ) {
	function wescle_login_navigation() {
		$title = __( 'Перейти в личный кабинет', 'wescle' );
		$url   = wc_get_account_endpoint_url( 'dashboard' );
		?>
        <li class="navigation-store__acc">
            <a href="<?php echo $url; ?>" title="<?php echo $title; ?>">
                <div class="_enter">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="0.97em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 496 512">
                        <path d="M248 8C111 8 0 119 0 256s111 248 248 248s248-111 248-248S385 8 248 8zm0 96c48.6 0 88 39.4 88 88s-39.4 88-88 88s-88-39.4-88-88s39.4-88 88-88zm0 344c-58.7 0-111.3-26.6-146.5-68.2c18.8-35.4 55.6-59.8 98.5-59.8c2.4 0 4.8.4 7.1 1.1c13 4.2 26.6 6.9 40.9 6.9c14.3 0 28-2.7 40.9-6.9c2.3-.7 4.7-1.1 7.1-1.1c42.9 0 79.7 24.4 98.5 59.8C359.3 421.4 306.7 448 248 448z" fill="#626262"></path>
                    </svg>
                </div>
            </a>
        </li>
		<?php
	}
}

if ( ! function_exists( 'wescle_wishlist_after_cart_form' ) ) {
	function wescle_wishlist_after_cart_form() {
		global $product, $woocommerce_loop;

		if ( empty( $product ) ) {
			return;
		}

		if ( Helper::is_plugin_active( 'ti-woocommerce-wishlist/ti-woocommerce-wishlist.php' ) ) {
			$is_loop = is_singular( 'product' ) && ! $woocommerce_loop['name'] ? false : true;
			if ( $is_loop ) {
				?>
                <div class="product-cart__wishlist loop-<?php echo $is_loop; ?>">
					<?php echo do_shortcode( "[ti_wishlists_addtowishlist loop=yes]" ); ?>
                </div>
				<?php
			}
		}
		else {
			$tooltip_text = apply_filters( 'wescle_wishlist_tooltip_text', __( 'В избранное', 'wescle' ) );
			?>
            <div class="product-cart__wishlist">
                <div>
                    <a href="#" class="link_wishlist link_wishlist_<?php echo $product->get_id(); ?>" data-product_id="<?php echo $product->get_id(); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 1024 1024">
                            <path d="M923 283.6a260.04 260.04 0 0 0-56.9-82.8a264.4 264.4 0 0 0-84-55.5A265.34 265.34 0 0 0 679.7 125c-49.3 0-97.4 13.5-139.2 39c-10 6.1-19.5 12.8-28.5 20.1c-9-7.3-18.5-14-28.5-20.1c-41.8-25.5-89.9-39-139.2-39c-35.5 0-69.9 6.8-102.4 20.3c-31.4 13-59.7 31.7-84 55.5a258.44 258.44 0 0 0-56.9 82.8c-13.9 32.3-21 66.6-21 101.9c0 33.3 6.8 68 20.3 103.3c11.3 29.5 27.5 60.1 48.2 91c32.8 48.9 77.9 99.9 133.9 151.6c92.8 85.7 184.7 144.9 188.6 147.3l23.7 15.2c10.5 6.7 24 6.7 34.5 0l23.7-15.2c3.9-2.5 95.7-61.6 188.6-147.3c56-51.7 101.1-102.7 133.9-151.6c20.7-30.9 37-61.5 48.2-91c13.5-35.3 20.3-70 20.3-103.3c.1-35.3-7-69.6-20.9-101.9zM512 814.8S156 586.7 156 385.5C156 283.6 240.3 201 344.3 201c73.1 0 136.5 40.8 167.7 100.4C543.2 241.8 606.6 201 679.7 201c104 0 188.3 82.6 188.3 184.5c0 201.2-356 429.3-356 429.3z"
                                  fill="#626262"></path>
                        </svg>
						<?php if ( $tooltip_text ) { ?>
                            <span class="tooltip tooltip_top tooltip_top_center"><?php echo $tooltip_text; ?></span>
						<?php } ?>
                    </a>
                </div>
            </div>
			<?php
		}
	}
}

function wescle_show_cat_brands() {
	if ( ! get_theme_mod( 'woo_archive_brands_enabled' ) ) {
		return;
	}

	if ( ! is_shop() && ! is_product_category() ) {
		return;
	}

	$taxonomy = get_theme_mod( 'woo_brands_taxonomy' );
	if ( ! $taxonomy ) {
		return;
	}

	$tags = [];
	if ( is_shop() ) {
		$tags = get_terms( [
			'taxonomy' => $taxonomy,
			'orderby'  => 'count',
			'order'    => 'DESC',
			'number'   => get_theme_mod( 'woo_archive_brands_count', 10 ),
		] );
	}
	else {
		$tag_ids = get_term_meta( get_queried_object_id(), 'relation_brands', 1 );
		if ( ! is_array( $tag_ids ) ) {
			$tag_ids = Helper::get_category_tags( [
				'terms'         => get_queried_object_id(),
				'taxonomy_base' => 'product_cat',
				'taxonomy_find' => $taxonomy,
			] );
			update_term_meta( get_queried_object_id(), 'relation_brands', $tag_ids );
		}
		if ( $tag_ids ) {
			$tags = get_terms( [
				'taxonomy' => $taxonomy,
				'include'  => $tag_ids,
				'orderby'  => 'count',
				'order'    => 'DESC',
			] );
		}
	}

	if ( $tags && ! is_wp_error( $tags ) ) {
		get_template_part( 'template-parts/archive/section-brands', null, [ 'terms' => $tags ] );
	}
}

function wescle_show_cat_tags() {
	if ( false === get_theme_mod( 'woo_archive_tags_enabled', true ) ) {
		return;
	}

	if ( ! is_shop() && ! is_product_category() ) {
		return;
	}

	$tags = [];
	if ( is_shop() ) {
		$tags = get_terms( [
			'taxonomy' => 'product_tag',
			'orderby'  => 'count',
			'order'    => 'DESC',
			'number'   => get_theme_mod( 'woo_archive_tags_count', 10 )
		] );
	}
	else {
		$tag_ids = get_term_meta( get_queried_object_id(), 'relation_tags', 1 );
		if ( $tag_ids ) {
			$tags = get_terms( [
				'taxonomy' => 'product_tag',
				'include'  => $tag_ids,
				'orderby'  => 'count',
				'order'    => 'DESC',
			] );
		}
	}

	if ( $tags && ! is_wp_error( $tags ) ) {
		get_template_part( 'template-parts/archive/section-tags', null, [ 'terms' => $tags ] );
	}
}

function wescle_product_features_html() {
	global $post;

	$features_as_tabs = get_post_meta( $post->ID, 'wescle_product_features_as_tabs', true );
	if ( $features_as_tabs ) {
		return;
	}

	$features_title = get_post_meta( $post->ID, 'wescle_product_features_title', true );
	if ( ! $features_title ) {
		$features_title = __( 'Характеристики', 'wescle' );
	}

	$data_features = get_post_meta( $post->ID, 'wescle_product_features', true );
	$data_features = apply_filters( 'wescle_product_features', $data_features );
	if ( $data_features ) {
		get_template_part( 'template-parts/woo/features', null, [ 'data_features' => $data_features, 'title' => $features_title ] );
	}
}

function wescle_product_additionally_html() {
	global $post;

	$data_additionally = WsclWoocommerce::get_product_additionally( $post->ID );
	$data_additionally = apply_filters( 'wescle_product_additionally', $data_additionally );
	if ( $data_additionally ) {
		get_template_part( 'template-parts/woo/additionally', null, [ 'data_additionally' => $data_additionally ] );
	}
}

function wescle_product_features_tab( $tabs ) {
	global $post;

	$features_as_tabs = get_post_meta( $post->ID, 'wescle_product_features_as_tabs', true );
	if ( ! $features_as_tabs ) {
		return $tabs;
	}

	$features_title = get_post_meta( $post->ID, 'wescle_product_features_title', true );
	if ( ! $features_title ) {
		$features_title = __( 'Характеристики', 'wescle' );
	}

	$tabs['wescle_features'] = array(
		'title'    => $features_title,
		'priority' => 25,
		'callback' => 'wescle_features_tab_content'
	);

	return $tabs;
}

function wescle_features_tab_content() {
	global $post;

	$data_features = get_post_meta( $post->ID, 'wescle_product_features', true );
	$data_features = apply_filters( 'wescle_product_features', $data_features );
	if ( $data_features ) {
		get_template_part( 'template-parts/woo/features', null, [ 'data_features' => $data_features ] );
	}
}

function wescle_loop_add_to_cart_link( $link, $product, $args ) {
	$svg  = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 36 36"> <circle class="clr-i-outline clr-i-outline-path-1" cx="13.33" cy="29.75" r="2.25" fill="#626262"></circle> <circle class="clr-i-outline clr-i-outline-path-2" cx="27" cy="29.75" r="2.25" fill="#626262"></circle> <path class="clr-i-outline clr-i-outline-path-3" d="M33.08 5.37a1 1 0 0 0-.77-.37H11.49l.65 2H31l-2.67 12h-15L8.76 4.53a1 1 0 0 0-.66-.65L4 2.62a1 1 0 1 0-.59 1.92L7 5.64l4.59 14.5l-1.64 1.34l-.13.13A2.66 2.66 0 0 0 9.74 25A2.75 2.75 0 0 0 12 26h16.69a1 1 0 0 0 0-2H11.84a.67.67 0 0 1-.56-1l2.41-2h15.44a1 1 0 0 0 1-.78l3.17-14a1 1 0 0 0-.22-.85z" fill="#626262"></path></svg>';
	$link = sprintf(
		'<a href="%s" data-quantity="%s" class="%s" %s>%s ' . $svg . '</a>',
		esc_url( $product->add_to_cart_url() ),
		esc_attr( isset( $args['quantity'] ) ? $args['quantity'] : 1 ),
		esc_attr( isset( $args['class'] ) ? $args['class'] : 'button' ),
		isset( $args['attributes'] ) ? wc_implode_html_attributes( $args['attributes'] ) : '',
		esc_html( $product->add_to_cart_text() )
	);

	return $link;
}

if ( ! function_exists( 'woocommerce_template_single_sharing' ) ) {
	function woocommerce_template_single_sharing() {
		if ( get_theme_mod( 'product_share_enabled', true ) ) {
			get_template_part( 'template-parts/post/share' );
		}
	}
}

function position_stock_rating_in_loop() {
	$customizer_values = Helper::get_customizer_post_values();

	$product_stock_enabled = get_theme_mod( 'product_stock_enabled', false );
	if ( isset( $customizer_values['product_stock_enabled'] ) ) {
		$product_stock_enabled = $customizer_values['product_stock_enabled'];
	}

	$product_rating_enabled = get_theme_mod( 'product_rating_enabled', false );
	if ( isset( $customizer_values['product_rating_enabled'] ) ) {
		$product_rating_enabled = $customizer_values['product_rating_enabled'];
	}

	$product_sku_enabled = get_theme_mod( 'product_sku_enabled', false );
	if ( isset( $customizer_values['product_sku_enabled'] ) ) {
		$product_sku_enabled = $customizer_values['product_sku_enabled'];
	}

	if ( $product_stock_enabled ) {
		add_action( 'woocommerce_shop_loop_item_title', 'wescle_loop_stock_product', 5 );
		add_action( 'woocommerce_before_shop_loop_item_title', 'wescle_loop_stock_product', 5 );
	}

	if ( $product_rating_enabled ) {
		add_action( 'woocommerce_shop_loop_item_title', 'wescle_loop_rating_product', 5 );
		add_action( 'woocommerce_before_shop_loop_item_title', 'wescle_loop_rating_product', 5 );
	}

	if ( $product_sku_enabled ) {
		add_action( 'woocommerce_shop_loop_item_title', 'wescle_loop_sku_product', 4 );
		add_action( 'woocommerce_before_shop_loop_item_title', 'wescle_loop_sku_product', 5 );
		add_action( 'woocommerce_shop_loop_price', 'wescle_loop_sku_product', 4 );
	}
}

function wescle_before_quantity_input_field() {
	if ( Helper::is_active_quantity_togglers() ) {
		echo '<button type="button" class="wescle-minus">-</button>';
	}
}

function wescle_after_quantity_input_field() {
	if ( Helper::is_active_quantity_togglers() ) {
		echo '<button type="button" class="wescle-plus">+</button>';
	}
}

if ( ! function_exists( 'wescle_loop_stock_product' ) ) {
	function wescle_loop_stock_product() {
		global $product;

		$action_name = current_action();

		$post_values = Helper::get_customizer_post_values();
		$pos         = $post_values['product_stock_position'] ?? get_theme_mod( 'product_stock_position', 'before_title' );

		if ( 'after_title' === $pos && 'woocommerce_shop_loop_item_title' === $action_name ) {
			echo wc_get_stock_html( $product );
		}
        elseif ( 'before_title' === $pos && 'woocommerce_before_shop_loop_item_title' === $action_name ) {
	        echo wc_get_stock_html( $product );
        }
	}
}

if ( ! function_exists( 'wescle_loop_rating_product' ) ) {
	function wescle_loop_rating_product() {
		global $product;

		$action_name = current_action();

		$post_values = Helper::get_customizer_post_values();
		$pos         = $post_values['product_rating_position'] ?? get_theme_mod( 'product_rating_position', 'before_title' );

		$rating_count = $product->get_rating_count();
		$review_count = $product->get_review_count();
		$average      = $product->get_average_rating();

		$rating_html = wc_get_rating_html( $average, $rating_count );
		if ( $rating_html ) {
			ob_start();
			echo $rating_html;
			echo '<span class="count">(' . esc_html( $review_count ) . ')</span>';
			if ( comments_open( $product->get_id() ) ) {
				?>
                <a href="<?php echo $product->get_permalink(); ?>#reviews" class="woocommerce-review-link" rel="nofollow"></a>
				<?php
			}
			$html_rating = ob_get_clean();

			if ( 'after_title' === $pos && 'woocommerce_shop_loop_item_title' === $action_name ) {
				?>
                <div class="woocommerce-product-rating">
					<?php echo $html_rating; ?>
                </div>
				<?php
			}
            elseif ( 'before_title' === $pos && 'woocommerce_before_shop_loop_item_title' === $action_name ) {
				?>
                <div class="woocommerce-product-rating">
					<?php echo $html_rating; ?>
                </div>
				<?php
			}
		}
	}
}

if ( ! function_exists( 'wescle_loop_sku_product' ) ) {
	function wescle_loop_sku_product() {
		global $product;

		$action_name = current_action();

		$post_values = Helper::get_customizer_post_values();
		$pos         = $post_values['product_sku_position'] ?? get_theme_mod( 'product_sku_position', 'before_title' );

		$label = get_theme_mod( 'product_sku_label', Helper::get_default_theme_data( 'product_sku_label' ) );
		if ( $label ) {
			$label = '<span class="_vendor-code__title">' . $label . '</span>';
		}
		$sku_html = '<div class="_vendor-code">' . $label . '<span class="_vendor-code__value">' . $product->get_sku() . '</span></div>';

		if ( 'after_title' === $pos && 'woocommerce_shop_loop_item_title' === $action_name ) {
			echo $sku_html;
		}
        elseif ( 'before_title' === $pos && 'woocommerce_before_shop_loop_item_title' === $action_name ) {
			echo $sku_html;
		}
        elseif ( 'after_price' === $pos && 'woocommerce_shop_loop_price' === $action_name ) {
			echo $sku_html;
		}
	}
}

if ( ! function_exists( 'wescle_loop_badges_product' ) ) {
	function wescle_loop_badges_product() {
		global $post, $product, $woocommerce_loop;

		$html_sale = '';
		if ( $product->is_on_sale() && ! get_post_meta( $post->ID, 'product_hide_on_sale', 1 ) ) {
			$html_sale = apply_filters( 'woocommerce_sale_flash', '<span class="onsale">' . esc_html__( 'Sale!', 'woocommerce' ) . '</span>', $post, $product );
		}

		$html_sale_badges      = '';
		$wescle_product_badges = get_post_meta( $product->get_id(), 'wescle_product_badges', 1 );
		if ( $wescle_product_badges ) {
			$badge_data = Helper::get_badges_data();
			foreach ( $wescle_product_badges as $badge_id ) {
				if ( isset( $badge_data[ $badge_id ] ) ) {
					$bg_style = '';
					if ( $badge_data[ $badge_id ]['bg_color'] ) {
						$bg_style = ' style="background:' . $badge_data[ $badge_id ]['bg_color'] . '"';
					}

					$title_style = '';
					if ( $badge_data[ $badge_id ]['title_color'] ) {
						$title_style = ' style="color:' . $badge_data[ $badge_id ]['title_color'] . '"';
					}

					$title           = $badge_data[ $badge_id ]['title'];
					$badge_img_class = '';
					if ( $badge_data[ $badge_id ]['img'] ) {
						$bg_style    = '';
						$title_style = '';

						$img_width = $badge_data[ $badge_id ]['max_width'] ?: 30;

						$attr_title = $title;
						$title      = '<img src="' . $badge_data[ $badge_id ]['img'] . '" height="30" width="' . $img_width . '" title="' . esc_attr( $attr_title ) . '" loading="lazy" />';
						$title      .= '<span class="tooltip tooltip_bottom">' . $attr_title . '</span>';
						if ( $badge_data[ $badge_id ]['image_long'] ) {
							$badge_img_class = ' _badge-img-long';
						}
						else {
							$badge_img_class = ' _badge-img';
						}
					}

					$html_sale_badges .= '<div class="product-cart__badge' . $badge_img_class . '"' . $bg_style . '><span' . $title_style . '>' . $title . '</span></div>';
				}
			}
		}

		if ( $product->is_on_sale() || $html_sale_badges ) {
			?>
            <div class="product-cart__badges">
                <div class="product-cart__badges-inner">
					<?php echo $html_sale; ?>
					<?php echo $html_sale_badges; ?>
                </div>
				<?php
				if ( ! is_product() || ( is_product() && $woocommerce_loop['name'] ) ) {
					wescle_product_label_sale( $product );
				}
				?>
            </div>
			<?php
		}
	}
}

if ( ! function_exists( 'get_brand_image_html' ) ) {
	function get_brand_image_html( $term, $placeholder = true ) {
		$image_html = '';

		$brand_taxonomy = get_theme_mod( 'woo_brands_taxonomy' );
		if ( ! $brand_taxonomy && get_theme_mod( 'woo_brands_enabled' ) ) {
			$brand_taxonomy = 'product_brand';
		}

		if ( $term && $brand_taxonomy === $term->taxonomy ) {
			$img_url = get_term_meta( $term->term_id, 'brand_image_url', 1 );
			foreach ( [ 'thumbnail_id', '_thumbnail_id', 'pwb_brand_image' ] as $meta_key ) {
				$img_id = get_term_meta( $term->term_id, $meta_key, 1 );
				if ( $img_id ) {
					break;
				}
			}
			if ( ! $img_id && ! $img_url && $placeholder ) {
				$img_url = wc_placeholder_img_src();
			}

			if ( $img_url ) {
				$image_html = '<img src="' . $img_url . '" alt="' . esc_attr( $term->name ) . '" loading="lazy"/>';
			}
            elseif ( $img_id ) {
				$image_html = wp_get_attachment_image( $img_id, 'medium' );
			}
		}

		return $image_html;
	}
}

function woocommerce_taxonomy_archive_description() {
	if ( is_product_taxonomy() && 0 === absint( get_query_var( 'paged' ) ) ) {
		$term = get_queried_object();

		$image_html = get_brand_image_html( $term, false );

		if ( $term && $term->description ) {
			echo '<div class="term-description">' . $image_html . wc_format_content( wp_kses_post( $term->description ) ) . '</div>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		}
	}
}

if ( ! function_exists( 'wescle_compare_loop_item' ) ) {
	function wescle_compare_loop_item() {
		global $product;

		if ( ! Helper::is_active_compare() ) {
			return;
		}

		if ( ! $product ) {
			return;
		}

		$tooltip_text = apply_filters( 'wescle_compare_tooltip_text', __( 'В сравнение', 'wescle' ) );
		?>
        <div class="product-cart__compare">
            <a href="#" class="link_compare link_compare_<?php echo $product->get_id(); ?>" data-product_id="<?php echo $product->get_id(); ?>">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 32 32">
                    <path d="M28 6H18V4a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h10v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM4 15h6.17l-2.58 2.59L9 19l5-5l-5-5l-1.41 1.41L10.17 13H4V4h12v20H4zm12 13v-2a2 2 0 0 0 2-2V8h10v9h-6.17l2.58-2.59L23 13l-5 5l5 5l1.41-1.41L21.83 19H28v9z" fill="#626262"></path>
                </svg>
				<?php if ( $tooltip_text ) { ?>
                    <span class="tooltip tooltip_top tooltip_top_center"><?php echo $tooltip_text; ?></span>
				<?php } ?>
            </a>
        </div>
		<?php
	}
}

if ( ! function_exists( 'wescle_compare_list' ) ) {
	function wescle_compare_list( $compare_data = null ) {
		if ( null === $compare_data ) {
			$compare_data = Helper::get_compare_data();
		}

		$url = Helper::get_compare_page_url();

		ob_start();
		?>
        <ul class="_compare-modal__list">
			<?php foreach ( $compare_data as $cat_id => $ids ) { ?>
				<?php $term = get_term_by( 'id', $cat_id, 'product_cat' ); ?>
                <li class="_compare-modal-item">
                    <a class="_compare-modal-item__link" href="<?php echo add_query_arg( [ 'list' => $cat_id ], $url ); ?>">
                        <span class="_compare-modal-item__title"><?php echo $term->name; ?></span><span class="_compare-modal-item__count">(<?php echo count( $ids ); ?>)</span>
                    </a>
                    <button class="_compare-modal-item__remove" type="button" data-list_id="<?php echo $cat_id; ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img" width="1em" height="1em" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                            <path fill="currentColor" fill-rule="evenodd" d="M16 1.75V3h5.25a.75.75 0 0 1 0 1.5H2.75a.75.75 0 0 1 0-1.5H8V1.75C8 .784 8.784 0 9.75 0h4.5C15.216 0 16 .784 16 1.75zm-6.5 0a.25.25 0 0 1 .25-.25h4.5a.25.25 0 0 1 .25.25V3h-5V1.75z"></path>
                            <path fill="currentColor" d="M4.997 6.178a.75.75 0 1 0-1.493.144L4.916 20.92a1.75 1.75 0 0 0 1.742 1.58h10.684a1.75 1.75 0 0 0 1.742-1.581l1.413-14.597a.75.75 0 0 0-1.494-.144l-1.412 14.596a.25.25 0 0 1-.249.226H6.658a.25.25 0 0 1-.249-.226L4.997 6.178z"></path>
                            <path fill="currentColor" d="M9.206 7.501a.75.75 0 0 1 .793.705l.5 8.5A.75.75 0 1 1 9 16.794l-.5-8.5a.75.75 0 0 1 .705-.793zm6.293.793A.75.75 0 1 0 14 8.206l-.5 8.5a.75.75 0 0 0 1.498.088l.5-8.5z"></path>
                        </svg>
                    </button>
                </li>
			<?php } ?>
        </ul>
		<?php
		wescle_compare_list_empty();

		return ob_get_clean();
	}
}

if ( ! function_exists( 'wescle_compare_list_empty' ) ) {
	function wescle_compare_list_empty() {
		$img = '<img src="' . get_template_directory_uri() . '/assets/img/comparison-modal-dummy.svg" alt="">';
		if ( $img_id = get_theme_mod( 'compare_empty_image' ) ) {
			$img = wp_get_attachment_image( $img_id, 'medium_large' );
		}
		?>
        <div class="_compare-modal__empty">
            <div class="_compare-modal__empty-img"><?php echo $img; ?></div>
            <div class="_compare-modal__title"><?php echo get_theme_mod( 'compare_empty_title', Helper::get_default_theme_data( 'compare_empty_title' ) ); ?></div>
            <div class="_compare-modal__text"><?php echo get_theme_mod( 'compare_empty_text', Helper::get_default_theme_data( 'compare_empty_text' ) ); ?></div>
        </div>
		<?php
	}
}
