<?php
add_action( 'widgets_init', 'wescle_register_widgets' );
function wescle_register_widgets() {
	require get_template_directory() . '/includes/widgets/widget-Contacts.php';
	require get_template_directory() . '/includes/widgets/widget-Contacts-v2.php';
	require get_template_directory() . '/includes/widgets/widget-Tags.php';
	require get_template_directory() . '/includes/widgets/widget-Category.php';
	require get_template_directory() . '/includes/widgets/widget-Top-Authors.php';
	require get_template_directory() . '/includes/widgets/widget-Popular-Posts.php';
	require get_template_directory() . '/includes/widgets/widget-Form.php';
	require get_template_directory() . '/includes/widgets/widget-Simple-Image.php';
	require get_template_directory() . '/includes/widgets/widget-Portfolio.php';
	require get_template_directory() . '/includes/widgets/widget-News.php';

	register_widget( 'Wescle_Widget_Contacts' );
	register_widget( 'Wescle_Widget_Contacts_v2' );
	register_widget( 'Wescle_Widget_Tags' );
	register_widget( 'Wescle_Widget_Category' );
	register_widget( 'Wescle_Widget_Top_Authors' );
	register_widget( 'Wescle_Widget_Popular_Posts' );
	register_widget( 'Wescle_Widget_Form' );
	register_widget( 'Wescle_Simple_Image' );
	register_widget( 'Wescle_Widget_Portfolio' );
	register_widget( 'Wescle_Widget_News' );

	if ( Helper::is_woocommerce_active() ) {
		require get_template_directory() . '/includes/widgets/wc-widget-Product-Categories.php';
		register_widget( 'Wescle_Widget_Product_Categories' );

		if ( class_exists( 'WC_Widget_Products' ) ) {
			unregister_widget( 'WC_Widget_Products' );

			require get_template_directory() . '/includes/widgets/wc-widget-Products.php';
			register_widget( 'Wescle_Widget_Products' );
		}

		if ( class_exists( 'WC_Widget_Top_Rated_Products' ) ) {
			unregister_widget( 'WC_Widget_Top_Rated_Products' );

			require get_template_directory() . '/includes/widgets/wc-widget-Top-Products.php';
			register_widget( 'Wescle_Widget_Top_Products' );
		}

		if ( class_exists( 'WC_Widget_Recently_Viewed' ) ) {
			unregister_widget( 'WC_Widget_Recently_Viewed' );

			require get_template_directory() . '/includes/widgets/wc-widget-Viewed-Products.php';
			register_widget( 'Wescle_Widget_Viewed_Products' );
		}

		if ( class_exists( 'WC_Widget_Product_Tag_Cloud' ) ) {
			unregister_widget( 'WC_Widget_Product_Tag_Cloud' );

			require get_template_directory() . '/includes/widgets/wc-widget-Product-Tags.php';
			register_widget( 'Wescle_Widget_Product_Tags' );
		}

		if ( class_exists( 'WC_Widget_Layered_Nav' ) ) {
			unregister_widget( 'WC_Widget_Layered_Nav' );

			require get_template_directory() . '/includes/widgets/wc-widget-Layered-Nav.php';
			register_widget( 'Wescle_Widget_Layered_Nav' );
		}
	}

	if ( get_theme_mod( 'module_catalog_enabled' ) ) {
		require get_template_directory() . '/includes/widgets/widget-Catalog-Filter.php';
		require get_template_directory() . '/includes/widgets/widget-Catalog-Filter-Chosen.php';

		register_widget( 'Wescle_Widget_Catalog_Filter' );
		register_widget( 'Wescle_Widget_Catalog_Filter_Chosen' );
	}
}


if ( ! defined( 'SIW_DIR' ) ) {

	define( 'SIW_DIR', get_template_directory() . '/includes/widgets/plugins/simple-image-widget/' );
	define( 'SIW_URL', get_template_directory_uri() . '/includes/widgets/plugins/simple-image-widget/' );

	/**
	 * Include functions and libraries.
	 */
	require_once( SIW_DIR . 'includes/class-simple-image-widget-legacy.php' );
	require_once( SIW_DIR . 'includes/class-simple-image-widget-plugin.php' );

	// Initialize and load the plugin.
	$simple_image_widget = new Simple_Image_Widget_Plugin();
	$simple_image_widget->load();
}

