<?php

class Wescle_Widget_Tags extends WP_Widget {

	function __construct() {
		parent::__construct(
			THEME_SLUG . '_widget_tags',
			'Wescle: ' . __( 'Метки (теги)', 'wescle' ),
			array(
				'description'                 => __( 'Выводит блок с тегами.', 'wescle' ),
				'classname'                   => 'tags',
				'customize_selective_refresh' => true,
				'show_instance_in_rest'       => true,
			)
		);
	}

	public function widget( $args, $instance ) {
		$title   = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		$orderby = isset( $instance['orderby'] ) ? $instance['orderby'] : 'count';
		$order   = 'count' === $orderby ? 'DESC' : 'ASC';
		$limit   = isset( $instance['limit'] ) ? $instance['limit'] : 6;

		$args_terms = apply_filters( 'wescle_widget_post_tags_args', [
			'taxonomy'   => 'post_tag',
			'hide_empty' => true,
			'number'     => $limit,
			'orderby'    => $orderby,
			'order'      => $order,
		] );
		$terms      = get_terms( $args_terms );

		if ( ! $terms ) {
			return;
		}

		echo $args['before_widget'];

		if ( ! empty( $title ) ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}

		set_query_var( 'template_args', [ 'terms' => $terms ] );
		get_template_part( 'template-parts/widgets/widget', 'tags' );

		echo $args['after_widget'];
	}

	public function form( $instance ) {
		$instance = wp_parse_args(
			(array) $instance,
			array(
				'title'   => '',
				'limit'   => 6,
				'orderby' => 'count',
			)
		);
		$title    = sanitize_text_field( $instance['title'] );
		$limit    = absint( $instance['limit'] );
		?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Заголовок', 'wescle' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>"/>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'limit' ); ?>"><?php _e( 'Количество меток', 'wescle' ); ?></label>
            <input id="<?php echo $this->get_field_id( 'limit' ); ?>" class="tiny-text" name="<?php echo $this->get_field_name( 'limit' ); ?>" type="number" step="1" min="1" value="<?php echo $limit; ?>" size="3"/>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'orderby' ); ?>"><?php _e( 'Сортировать', 'wescle' ); ?></label>
            <select name="<?php echo $this->get_field_name( 'orderby' ); ?>" id="<?php echo $this->get_field_id( 'orderby' ); ?>" class="widefat">
                <option value="name"<?php selected( $instance['orderby'], 'name' ); ?>><?php _e( 'По имени', 'wescle' ); ?></option>
                <option value="count"<?php selected( $instance['orderby'], 'count' ); ?>><?php _e( 'По количеству записей', 'wescle' ); ?></option>
            </select>
        </p>
		<?php
	}

	public function update( $new_instance, $old_instance ) {
		$instance            = $old_instance;
		$instance['title']   = sanitize_text_field( $new_instance['title'] );
		$instance['limit']   = absint( $new_instance['limit'] );
		$instance['orderby'] = $new_instance['orderby'];

		return $instance;
	}
}