<?php

class Wescle_Widget_Portfolio extends WP_Widget {

	function __construct() {
		parent::__construct(
			THEME_SLUG . '_widget_portfolio',
			'Wescle: ' . __( 'Портфолио работ', 'wescle' ),
			array(
				'description'                 => __( 'Выводит блок с портфолио-работами.', 'wescle' ),
				'classname'                   => 'popular',
				'customize_selective_refresh' => true,
				'show_instance_in_rest'       => true,
			)
		);
	}

	public function widget( $args, $instance ) {
		$title    = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		$meta_key = '';
		$orderby  = isset( $instance['orderby'] ) ? $instance['orderby'] : 'views';
		if ( $orderby == 'views' ) {
			$orderby  = 'meta_value_num';
			$meta_key = 'views';
		}
		$order = 'title' === $orderby ? 'ASC' : 'DESC';
		$limit = isset( $instance['limit'] ) ? $instance['limit'] : 5;
		if ( ! $limit ) {
			$limit = 5;
		}

		$args_posts = array(
			'post_type'           => 'portfolio_wescle',
			'post_status'         => 'publish',
			'posts_per_page'      => $limit,
			'no_found_rows'       => true,
			'ignore_sticky_posts' => true,
			'orderby'             => $orderby,
			'order'               => $order,
			'meta_key'            => $meta_key,
			'suppress_filters'    => true,
		);

		if ( is_singular( 'portfolio_wescle' ) ) {
			global $post;
			$args_posts['post__not_in'] = [ $post->ID ];
		}

		if ( Helper::is_plugin_active( 'post-views-counter/post-views-counter.php' ) ) {
			$args_posts['suppress_filters'] = false;
			$args_posts['orderby']          = 'post_views';
			$args_posts['fields']           = '';
			$args_posts['meta_key']         = '';
		}

		$r = new WP_Query(
			apply_filters(
				THEME_SLUG . '_widget_posts_args',
				$args_posts,
				$instance
			)
		);

		if ( ! $r->have_posts() ) {
			return;
		}

		echo $args['before_widget'];

		if ( ! empty( $title ) ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}

		set_query_var( 'template_args', [ 'posts' => $r->posts, 'instance' => $instance ] );
		get_template_part( 'template-parts/widgets/widget', 'portfolio' );

		echo $args['after_widget'];
	}

	public function form( $instance ) {
		$instance = wp_parse_args(
			(array) $instance,
			array(
				'title'        => '',
				'limit'        => 5,
				'orderby'      => 'views',
				'show_excerpt' => 1,
			)
		);
		$title    = sanitize_text_field( $instance['title'] );
		$limit    = absint( $instance['limit'] );
		?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Заголовок', 'wescle' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>"/>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'limit' ); ?>"><?php _e( 'Количество работ', 'wescle' ); ?></label>
            <input id="<?php echo $this->get_field_id( 'limit' ); ?>" class="tiny-text" name="<?php echo $this->get_field_name( 'limit' ); ?>" type="number" step="1" min="1" value="<?php echo $limit; ?>" size="3"/>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'orderby' ); ?>"><?php _e( 'Сортировать', 'wescle' ); ?></label>
            <select name="<?php echo $this->get_field_name( 'orderby' ); ?>" id="<?php echo $this->get_field_id( 'orderby' ); ?>" class="widefat">
                <option value="title"<?php selected( $instance['orderby'], 'title' ); ?>><?php _e( 'По имени', 'wescle' ); ?></option>
                <option value="date"<?php selected( $instance['orderby'], 'date' ); ?>><?php _e( 'По дате', 'wescle' ); ?></option>
                <option value="views"<?php selected( $instance['orderby'], 'views' ); ?>><?php _e( 'По количеству просмотров', 'wescle' ); ?></option>
            </select>
        </p>

        <p>
            <input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id( 'show_excerpt' ); ?>" name="<?php echo $this->get_field_name( 'show_excerpt' ); ?>"<?php checked( $instance['show_excerpt'] ); ?> />
            <label for="<?php echo $this->get_field_id( 'show_excerpt' ); ?>"><?php _e( 'Отображать краткое описание?', 'wescle' ); ?></label>
        </p>
		<?php
	}

	public function update( $new_instance, $old_instance ) {
		$instance                 = $old_instance;
		$instance['title']        = sanitize_text_field( $new_instance['title'] );
		$instance['limit']        = (int) $new_instance['limit'];
		$instance['orderby']      = $new_instance['orderby'];
		$instance['show_excerpt'] = isset( $new_instance['show_excerpt'] ) ? 1 : 0;

		return $instance;
	}
}