<?php

class Wescle_Widget_Popular_Posts extends WP_Widget {

	function __construct() {
		parent::__construct(
			THEME_SLUG . '_widget_popular_posts',
			'Wescle: ' . __( 'Популярные записи', 'wescle' ),
			array(
				'description'                 => __( 'Выводит блок с записями.', 'wescle' ),
				'classname'                   => 'popular',
				'customize_selective_refresh' => true,
				'show_instance_in_rest'       => true,
			)
		);
	}

	public function widget( $args, $instance ) {
		$title    = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		$meta_key = '';
		$orderby  = isset( $instance['orderby'] ) ? $instance['orderby'] : 'views';
		if ( $orderby == 'views' ) {
			$orderby  = 'meta_value_num';
			$meta_key = 'views';
		}
		$order = 'title' === $orderby ? 'ASC' : 'DESC';
		$limit = isset( $instance['limit'] ) ? $instance['limit'] : 5;
		if ( ! $limit ) {
			$limit = 5;
		}
		$cat_id = isset( $instance['cat_id'] ) ? $instance['cat_id'] : 0;

		$args_posts = array(
			'post_type'           => 'post',
			'post_status'         => 'publish',
			'posts_per_page'      => $limit,
			'no_found_rows'       => true,
			'ignore_sticky_posts' => true,
			'orderby'             => $orderby,
			'order'               => $order,
			'meta_key'            => $meta_key,
			'suppress_filters'    => true,
		);

		if ( $cat_id ) {
			$args_posts['tax_query'] = [
				[
					'taxonomy' => 'category',
					'terms'    => [ $cat_id ],
				]
			];
		}

		if ( is_singular( 'post' ) ) {
			global $post;
			$args_posts['post__not_in'] = [ $post->ID ];
		}

		if ( Helper::is_plugin_active( 'post-views-counter/post-views-counter.php' ) ) {
			$args_posts['suppress_filters'] = false;
			$args_posts['orderby']          = 'post_views';
			$args_posts['fields']           = '';
			$args_posts['meta_key']         = '';
		}

		$r = new WP_Query(
			apply_filters(
				THEME_SLUG . '_widget_posts_args',
				$args_posts,
				$instance
			)
		);

		if ( ! $r->have_posts() ) {
			return;
		}

		echo $args['before_widget'];

		if ( ! empty( $title ) ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}

		set_query_var( 'template_args', [ 'posts' => $r->posts, 'instance' => $instance ] );
		get_template_part( 'template-parts/widgets/widget', 'posts' );

		echo $args['after_widget'];
	}

	public function form( $instance ) {
		$instance        = wp_parse_args(
			(array) $instance,
			array(
				'title'         => '',
				'limit'         => 5,
				'cat_id'        => 0,
				'orderby'       => 'views',
				'show_category' => 1,
				'show_author'   => 1,
				'show_date'     => 1,
				'show_comments' => 1,
				'show_views'    => 1,
			)
		);
		$title           = sanitize_text_field( $instance['title'] );
		$limit           = absint( $instance['limit'] );
		$selected_cat_id = $instance['cat_id'];
		?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Заголовок', 'wescle' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>"/>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'limit' ); ?>"><?php _e( 'Количество записей', 'wescle' ); ?></label>
            <input id="<?php echo $this->get_field_id( 'limit' ); ?>" class="tiny-text" name="<?php echo $this->get_field_name( 'limit' ); ?>" type="number" step="1" min="1" value="<?php echo $limit; ?>" size="3"/>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'cat_id' ); ?>"><?php _e( 'Рубрика записей', 'wescle' ); ?></label>
			<?php
			$cat_args = [
				'id'                => $this->get_field_id( 'cat_id' ),
				'name'              => $this->get_field_name( 'cat_id' ),
				'selected'          => $selected_cat_id,
				'show_option_none'  => __( 'Показывать записи со всех рубрик', 'wescle' ),
				'option_none_value' => 0,
				'class'             => 'widefat',
				'orderby'           => 'name',
				'order'             => 'ASC',
			];
			wp_dropdown_categories( apply_filters( THEME_SLUG . '_widget_categories_dropdown_args', $cat_args, $instance ) );
			?>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'orderby' ); ?>"><?php _e( 'Сортировать', 'wescle' ); ?></label>
            <select name="<?php echo $this->get_field_name( 'orderby' ); ?>" id="<?php echo $this->get_field_id( 'orderby' ); ?>" class="widefat">
                <option value="title"<?php selected( $instance['orderby'], 'title' ); ?>><?php _e( 'По имени', 'wescle' ); ?></option>
                <option value="date"<?php selected( $instance['orderby'], 'date' ); ?>><?php _e( 'По дате', 'wescle' ); ?></option>
                <option value="views"<?php selected( $instance['orderby'], 'views' ); ?>><?php _e( 'По количеству просмотров', 'wescle' ); ?></option>
            </select>
        </p>

        <p>
            <input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id( 'show_category' ); ?>" name="<?php echo $this->get_field_name( 'show_category' ); ?>"<?php checked( $instance['show_category'] ); ?> />
            <label for="<?php echo $this->get_field_id( 'show_category' ); ?>"><?php _e( 'Отображать категорию?', 'wescle' ); ?></label>
        </p>

        <p>
            <input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id( 'show_author' ); ?>" name="<?php echo $this->get_field_name( 'show_author' ); ?>"<?php checked( $instance['show_author'] ); ?> />
            <label for="<?php echo $this->get_field_id( 'show_author' ); ?>"><?php _e( 'Отображать автора?', 'wescle' ); ?></label>
        </p>

        <p>
            <input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id( 'show_date' ); ?>" name="<?php echo $this->get_field_name( 'show_date' ); ?>"<?php checked( $instance['show_date'] ); ?> />
            <label for="<?php echo $this->get_field_id( 'show_date' ); ?>"><?php _e( 'Отображать дату записи?', 'wescle' ); ?></label>
        </p>

        <p>
            <input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id( 'show_comments' ); ?>" name="<?php echo $this->get_field_name( 'show_comments' ); ?>"<?php checked( $instance['show_comments'] ); ?> />
            <label for="<?php echo $this->get_field_id( 'show_comments' ); ?>"><?php _e( 'Отображать комментарии?', 'wescle' ); ?></label>
        </p>

        <p>
            <input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id( 'show_views' ); ?>" name="<?php echo $this->get_field_name( 'show_views' ); ?>"<?php checked( $instance['show_views'] ); ?> />
            <label for="<?php echo $this->get_field_id( 'show_views' ); ?>"><?php _e( 'Отображать просмотры?', 'wescle' ); ?></label>
        </p>
		<?php
	}

	public function update( $new_instance, $old_instance ) {
		$instance                  = $old_instance;
		$instance['title']         = sanitize_text_field( $new_instance['title'] );
		$instance['limit']         = (int) $new_instance['limit'];
		$instance['cat_id']        = $new_instance['cat_id'];
		$instance['orderby']       = $new_instance['orderby'];
		$instance['show_category'] = isset( $new_instance['show_category'] ) ? 1 : 0;
		$instance['show_author']   = isset( $new_instance['show_author'] ) ? 1 : 0;
		$instance['show_date']     = isset( $new_instance['show_date'] ) ? 1 : 0;
		$instance['show_comments'] = isset( $new_instance['show_comments'] ) ? 1 : 0;
		$instance['show_views']    = isset( $new_instance['show_views'] ) ? 1 : 0;

		return $instance;
	}
}