<?php

class Wescle_Widget_News extends WP_Widget {

	function __construct() {
		parent::__construct(
			THEME_SLUG . '_widget_news',
			'Wescle: ' . __( 'Новости', 'wescle' ),
			array(
				'description'                 => __( 'Выводит блок с последними записями.', 'wescle' ),
				'classname'                   => 'news-widget',
				'customize_selective_refresh' => true,
				'show_instance_in_rest'       => true,
			)
		);
	}

	public function widget( $args, $instance ) {
		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );

		$orderby = 'date';
		$order   = 'title' === $orderby ? 'ASC' : 'DESC';

		$limit = isset( $instance['limit'] ) ? $instance['limit'] : 5;
		if ( ! $limit ) {
			$limit = 5;
		}
		$cat_id = isset( $instance['cat_id'] ) ? $instance['cat_id'] : 0;

		$args_posts = array(
			'post_type'           => 'post',
			'post_status'         => 'publish',
			'posts_per_page'      => $limit,
			'no_found_rows'       => true,
			'ignore_sticky_posts' => true,
			'orderby'             => $orderby,
			'order'               => $order,
			'suppress_filters'    => true,
		);

		if ( $cat_id ) {
			$args_posts['tax_query'] = [
				[
					'taxonomy' => 'category',
					'terms'    => [ $cat_id ],
				]
			];
		}

		if ( is_singular( 'portfolio_wescle' ) ) {
			global $post;
			$args_posts['post__not_in'] = [ $post->ID ];
		}

		$r = new WP_Query(
			apply_filters(
				THEME_SLUG . '_widget_news_posts_args',
				$args_posts,
				$instance
			)
		);

		if ( ! $r->have_posts() ) {
			return;
		}

		echo $args['before_widget'];

		if ( ! empty( $title ) ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}

		set_query_var( 'template_args', [ 'posts' => $r->posts, 'instance' => $instance ] );
		get_template_part( 'template-parts/widgets/widget', 'news' );

		echo $args['after_widget'];
	}

	public function form( $instance ) {
		$instance        = wp_parse_args(
			(array) $instance,
			array(
				'title'  => '',
				'limit'  => 5,
				'cat_id' => 0,
			)
		);
		$title           = sanitize_text_field( $instance['title'] );
		$limit           = absint( $instance['limit'] );
		$selected_cat_id = $instance['cat_id'];
		?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Заголовок', 'wescle' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>"/>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'limit' ); ?>"><?php _e( 'Количество записей', 'wescle' ); ?></label>
            <input id="<?php echo $this->get_field_id( 'limit' ); ?>" class="tiny-text" name="<?php echo $this->get_field_name( 'limit' ); ?>" type="number" step="1" min="1" value="<?php echo $limit; ?>" size="3"/>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'cat_id' ); ?>"><?php _e( 'Рубрика записей', 'wescle' ); ?></label>
			<?php
			$cat_args = [
				'id'                => $this->get_field_id( 'cat_id' ),
				'name'              => $this->get_field_name( 'cat_id' ),
				'selected'          => $selected_cat_id,
				'show_option_none'  => __( 'Показывать записи со всех рубрик', 'wescle' ),
				'option_none_value' => 0,
				'class'             => 'widefat',
				'orderby'           => 'name',
				'order'             => 'ASC',
			];
			wp_dropdown_categories( apply_filters( THEME_SLUG . '_widget_categories_dropdown_args', $cat_args, $instance ) );
			?>
        </p>
		<?php
	}

	public function update( $new_instance, $old_instance ) {
		$instance           = $old_instance;
		$instance['title']  = sanitize_text_field( $new_instance['title'] );
		$instance['limit']  = (int) $new_instance['limit'];
		$instance['cat_id'] = $new_instance['cat_id'];

		return $instance;
	}
}