<?php

class Wescle_Widget_Form extends WP_Widget {

	function __construct() {
		parent::__construct(
			THEME_SLUG . '_widget_form',
			'Wescle: ' . __( 'Форма CF7', 'wescle' ),
			array(
				'description'                 => __( 'Выводит блок с формой (подписки).', 'wescle' ),
				'classname'                   => 'newsletter',
				'customize_selective_refresh' => true,
				'show_instance_in_rest'       => true,
			)
		);
	}

	public function widget( $args, $instance ) {
		$title  = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		$cf7_id = isset( $instance['cf7_id'] ) ? $instance['cf7_id'] : 0;

		if ( ! $cf7_id ) {
			return;
		}

		echo $args['before_widget'];

		if ( ! empty( $title ) ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}

		set_query_var( 'template_args', [ 'instance' => $instance ] );
		get_template_part( 'template-parts/widgets/widget', 'form' );

		echo $args['after_widget'];
	}

	public function form( $instance ) {
		$instance = wp_parse_args(
			(array) $instance,
			array(
				'title'           => '',
				'cf7_id'          => 0,
				'text_after_form' => '',
			)
		);
		$title    = sanitize_text_field( $instance['title'] );
		$cf7_id   = $instance['cf7_id'];
		?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Заголовок', 'wescle' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>"/>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'cf7_id' ); ?>"><?php _e( 'Форма CF7', 'wescle' ); ?></label>
			<?php
			$label_select = __( 'Выбрать ...', 'wescle' );
			$cf7_posts    = Helper::get_posts( array(
				'posts_per_page' => - 1,
				'post_type'      => 'wpcf7_contact_form'
			) );
			$cf7_posts    = [ 0 => $label_select ] + $cf7_posts;
			?>
            <select name="<?php echo $this->get_field_name( 'cf7_id' ); ?>" id="<?php echo $this->get_field_id( 'cf7_id' ); ?>" class="widefat">
				<?php
				foreach ( $cf7_posts as $key => $value ) {
					echo '<option value="' . $key . '" ' . selected( $key, $cf7_id, false ) . '>' . $value . '</option>';
				}
				?>
            </select>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'text_after_form' ); ?>"><?php _e( 'Текст под формой', 'wescle' ); ?></label>
            <textarea class="widefat" rows="4" cols="20" id="<?php echo $this->get_field_id( 'text_after_form' ); ?>" name="<?php echo $this->get_field_name( 'text_after_form' ); ?>"><?php echo esc_textarea( $instance['text_after_form'] ); ?></textarea>
        </p>
		<?php
	}

	public function update( $new_instance, $old_instance ) {
		$instance           = $old_instance;
		$instance['title']  = sanitize_text_field( $new_instance['title'] );
		$instance['cf7_id'] = $new_instance['cf7_id'];

		if ( current_user_can( 'unfiltered_html' ) ) {
			$instance['text_after_form'] = $new_instance['text_after_form'];
		}
		else {
			$instance['text_after_form'] = wp_kses_post( $new_instance['text_after_form'] );
		}

		return $instance;
	}
}