<?php

class Wescle_Widget_Contacts extends WP_Widget {

	function __construct() {
		parent::__construct(
			THEME_SLUG . '_widget_contacts',
			'Wescle: ' . __( 'Контакты', 'wescle' ),
			array(
				'description'                 => __( 'Выводит блок с контактами.', 'wescle' ),
				'customize_selective_refresh' => true,
				'show_instance_in_rest'       => true,
			)
		);
	}

	public function widget( $args, $instance ) {
		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		$text  = isset( $instance['text'] ) ? $instance['text'] : '';

		$args['before_widget'] = str_replace( 'col footer__col', 'col footer__col footer__col_main', $args['before_widget'] );
		echo $args['before_widget'];

		if ( ! empty( $title ) ) {
			if ( strpos( $args['before_title'], 'title_aside' ) !== false ) {
				echo $args['before_title'] . $title . $args['after_title'];
			}
			else {
				echo '<div class="footer__label">' . $title . '</div>';
			}
		}

		get_template_part( 'template-parts/widgets/widget', 'contact', [ 'widget_text' => $text ] );

		echo $args['after_widget'];
	}

	public function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 'title' => '' ) );
		$title    = sanitize_text_field( $instance['title'] );
		$text     = isset( $instance['text'] ) ? $instance['text'] : '';
		$text     = sanitize_textarea_field( $text );

		echo '<p>';
		echo '<label for="' . $this->get_field_id( 'title' ) . '">' . __( 'Заголовок', 'wescle' ) . '</label>';
		echo '<input class="widefat" id="' . $this->get_field_id( 'title' ) . '" name="' . $this->get_field_name( 'title' ) . '" type="text" value="' . esc_attr( $title ) . '">';
		echo '</p>';

		echo '<p>';
		echo '<label for="' . $this->get_field_id( 'text' ) . '">' . __( 'Текст', 'wescle' ) . '</label>';
		echo '<textarea class="widefat" rows="4" cols="20" id="' . $this->get_field_id( 'text' ) . '" name="' . $this->get_field_name( 'text' ) . '">' . $text . '</textarea>';
		echo '</p>';
	}

	public function update( $new_instance, $old_instance ) {
		$instance          = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['text']  = sanitize_textarea_field( $new_instance['text'] );

		return $instance;
	}
}