<?php

class Wescle_Widget_Contacts_v2 extends WP_Widget {

	protected $registered = false;

	function __construct() {
		parent::__construct(
			THEME_SLUG . '_widget_contacts_v2',
			'Wescle: ' . __( 'Контакты 2.0', 'wescle' ),
			array(
				'description'                 => __( 'Выводит блок с контактами.', 'wescle' ),
				'classname'                   => 'aside-order',
				'customize_selective_refresh' => true,
				'show_instance_in_rest'       => true
			)
		);
	}

	public function _register_one( $number = - 1 ) {
		parent::_register_one( $number );
		if ( $this->registered ) {
			return;
		}
		$this->registered = true;

		add_action( 'admin_print_scripts-widgets.php', array( $this, 'enqueue_admin_scripts' ) );
	}

	public function enqueue_admin_scripts() {
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_script( 'wp-color-picker' );

		wp_enqueue_script( 'wescle-contact_v2-widgets', get_template_directory_uri() . '/assets/admin/js/widget-contact_v2.js', '', time(), true );
	}

	public function widget( $args, $instance ) {
		if ( ! $instance || ! isset( $instance['title_1'] ) ) {
			return;
		}

		$style                           = $this->get_button_style( $args, $instance );
		$instance['button_custom_class'] = '';

		if ( $instance && isset( $instance['button_type'] ) && isset( $instance['button_link'] ) ) {
			if ( 'animation' == $instance['button_type'] ) {
				$instance['button_custom_class'] .= ' btn-flare';
			}

			if ( strpos( $instance['button_link'], '#wescle-modal' ) !== false || strpos( $instance['button_link'], '#modal' ) !== false ) {
				$instance['button_custom_class'] .= ' _popup-link';
			}
		}

		echo $args['before_widget'];

		get_template_part( 'template-parts/widgets/widget', 'contact_v2', [ 'instance' => $instance, 'style' => $style ] );

		echo $args['after_widget'];
	}

	public function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array(
			'title_1'                  => '',
			'image_1'                  => '',
			'text_1'                   => '',
			'title_2'                  => '',
			'image_2'                  => '',
			'text_2'                   => '',
			'phones'                   => [],
			'phone_as_link'            => 0,
			'button_label'             => '',
			'button_link'              => '',
			'button_type'              => 'default',
			'button_color'             => '',
			'button_bg'                => '',
			'button_border'            => '',
			'button_blick_color'       => '',
			'button_color_hover'       => '',
			'button_bg_hover'          => '',
			'button_border_hover'      => '',
			'button_blick_color_hover' => '',
			'button_blick_speed'       => 4,
			'socials'                  => [],
		) );

		$title_1                  = $instance['title_1'];
		$text_1                   = esc_textarea( $instance['text_1'] );
		$image_1                  = $instance['image_1'];
		$title_2                  = $instance['title_2'];
		$text_2                   = esc_textarea( $instance['text_2'] );
		$image_2                  = $instance['image_2'];
		$phones                   = $instance['phones'];
		$button_label             = $instance['button_label'];
		$button_link              = $instance['button_link'];
		$button_type              = $instance['button_type'];
		$button_color             = $instance['button_color'];
		$button_bg                = $instance['button_bg'];
		$button_border            = $instance['button_border'];
		$button_blick_color       = $instance['button_blick_color'];
		$button_color_hover       = $instance['button_color_hover'];
		$button_bg_hover          = $instance['button_bg_hover'];
		$button_border_hover      = $instance['button_border_hover'];
		$button_blick_color_hover = $instance['button_blick_color_hover'];
		$button_blick_speed       = $instance['button_blick_speed'];
		$socials                  = $instance['socials'];

		$button_type_choices = [
			'default'   => esc_html__( 'От настроек базового цвета', 'wescle' ),
			'custom'    => esc_html__( 'Обычная кнопка', 'wescle' ),
			'animation' => esc_html__( 'Кнопка анимационная', 'wescle' ),
		];

		$label_remove = __( 'Удалить', 'wescle' );
		?>
        <p><strong><?php _e( 'Настройки блока', 'wescle' ); ?> 1</strong></p>

        <p>
            <label for="<?php echo $this->get_field_id( 'title_1' ) ?>"><?php _e( 'Заголовок', 'wescle' ) ?></label>
            <input class="widefat" id="<?php $this->get_field_id( 'title_1' ); ?>" name="<?php echo $this->get_field_name( 'title_1' ) ?>" type="text" value="<?php echo esc_attr( $title_1 ) ?>">
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'image_1' ) ?>"><?php _e( 'URL иконки', 'wescle' ) ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'image_1' ) ?>" name="<?php echo $this->get_field_name( 'image_1' ) ?>" type="text" value="<?php echo esc_url( $image_1 ) ?>">
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'text_1' ); ?>"><?php _e( 'Текст', 'wescle' ) ?></label>
            <textarea class="widefat" rows="4" cols="20" id="<?php echo $this->get_field_id( 'text_1' ) ?>" name="<?php echo $this->get_field_name( 'text_1' ) ?>"><?php echo $text_1 ?></textarea>
        </p>

        <p><strong><?php _e( 'Настройки блока', 'wescle' ); ?> 2</strong></p>

        <p>
            <label for="<?php echo $this->get_field_id( 'title_2' ) ?>"><?php _e( 'Заголовок', 'wescle' ) ?></label>
            <input class="widefat" id="<?php $this->get_field_id( 'title_2' ); ?>" name="<?php echo $this->get_field_name( 'title_2' ) ?>" type="text" value="<?php echo esc_attr( $title_2 ) ?>">
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'image_2' ) ?>"><?php _e( 'URL иконки', 'wescle' ) ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'image_2' ) ?>" name="<?php echo $this->get_field_name( 'image_2' ) ?>" type="text" value="<?php echo esc_url( $image_2 ) ?>">
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'text_2' ); ?>"><?php _e( 'Текст', 'wescle' ) ?></label>
            <textarea class="widefat" rows="4" cols="20" id="<?php echo $this->get_field_id( 'text_2' ) ?>" name="<?php echo $this->get_field_name( 'text_2' ) ?>"><?php echo $text_2 ?></textarea>
        </p>

        <div class="wrap-repeater-fields">
            <label><?php _e( 'Телефоны', 'wescle' ) ?></label>
            <div class="repeater-fields">
				<?php foreach ( $phones as $phone_item ) { ?>
                    <div class="repeater-row">
                        <div class="repeater-field">
                            <input type="tel" class="widefat" name="<?php echo $this->get_field_name( 'phones' ) ?>[]" value="<?php echo esc_attr( $phone_item ); ?>">
                        </div>
                        <div class="repeater-field alignright">
                            <button type="button" class="button-link button-link-delete"><?php echo $label_remove; ?></button>
                        </div>
                    </div>
				<?php } ?>
                <div class="repeater-field-hidden">
                    <div class="repeater-row">
                        <div class="repeater-field">
                            <input type="tel" class="widefat" name="<?php echo $this->get_field_name( 'phones' ) ?>[]" value="">
                        </div>
                        <div class="repeater-field alignright">
                            <button type="button" class="button-link button-link-delete"><?php echo $label_remove; ?></button>
                        </div>
                    </div>
                </div>
            </div>
            <button type="button" class="button-secondary repeater-add-item"><?php _e( 'Добавить телефон', 'wescle' ) ?></button>
        </div>

        <p>
            <input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id( 'phone_as_link' ); ?>" name="<?php echo $this->get_field_name( 'phone_as_link' ); ?>" value="1" <?php checked( $instance['phone_as_link'] ); ?> />
            <label for="<?php echo $this->get_field_id( 'phone_as_link' ); ?>"><?php _e( 'Отображать телефон как ссылку?', 'wescle' ); ?></label>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'button_label' ) ?>"><?php _e( 'Надпись на кнопке', 'wescle' ) ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'button_label' ) ?>" name="<?php echo $this->get_field_name( 'button_label' ) ?>" type="text" value="<?php echo esc_attr( $button_label ) ?>">
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'button_link' ) ?>"><?php _e( 'URL на кнопке', 'wescle' ) ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'button_link' ) ?>" name="<?php echo $this->get_field_name( 'button_link' ) ?>" type="text" value="<?php echo esc_attr( $button_link ) ?>">
        </p>

        <p class="button_type-radio_fields">
            <label><?php _e( 'Тип кнопки', 'wescle' ) ?></label>
			<?php foreach ( $button_type_choices as $key => $label ) { ?>
                <span class="field-radio">
                    <input type="radio" class="radio" id="<?php echo $this->get_field_id( 'button_type' ); ?>-<?php echo $key; ?>" name="<?php echo $this->get_field_name( 'button_type' ); ?>" value="<?php echo $key; ?>" <?php checked( $button_type, $key ); ?> />
                    <label for="<?php echo $this->get_field_id( 'button_type' ); ?>-<?php echo $key; ?>"><?php echo $label; ?></label>
                </span>
			<?php } ?>
        </p>
        <div class="button-color-settings">
            <p>
                <label class="label_color-picker" for="<?php echo $this->get_field_id( 'button_color' ); ?>"><?php _e( 'Цвет текста', 'wescle' ) ?></label>
                <input class="widefat color-picker" id="<?php echo $this->get_field_id( 'button_color' ); ?>" name="<?php echo $this->get_field_name( 'button_color' ); ?>" type="text" value="<?php echo esc_attr( $button_color ); ?>"/>
            </p>
            <p>
                <label class="label_color-picker" for="<?php echo $this->get_field_id( 'button_bg' ); ?>"><?php _e( 'Фон', 'wescle' ) ?></label>
                <input class="widefat color-picker" id="<?php echo $this->get_field_id( 'button_bg' ); ?>" name="<?php echo $this->get_field_name( 'button_bg' ); ?>" type="text" value="<?php echo esc_attr( $button_bg ); ?>"/>
            </p>
            <p>
                <label class="label_color-picker" for="<?php echo $this->get_field_id( 'button_border' ); ?>"><?php _e( 'Обводка', 'wescle' ) ?></label>
                <input class="widefat color-picker" id="<?php echo $this->get_field_id( 'button_border' ); ?>" name="<?php echo $this->get_field_name( 'button_border' ); ?>" type="text" value="<?php echo esc_attr( $button_border ); ?>"/>
            </p>
            <p class="wrap-button_blick_color">
                <label class="label_color-picker" for="<?php echo $this->get_field_id( 'button_blick_color' ); ?>"><?php _e( 'Цвет блика анимационного', 'wescle' ) ?></label>
                <input class="widefat color-picker" id="<?php echo $this->get_field_id( 'button_blick_color' ); ?>" name="<?php echo $this->get_field_name( 'button_blick_color' ); ?>" type="text" value="<?php echo esc_attr( $button_blick_color ); ?>"/>
            </p>
            <p>
                <label class="label_color-picker" for="<?php echo $this->get_field_id( 'button_color_hover' ); ?>"><?php _e( 'Цвет текста', 'wescle' ); ?>&nbsp;<?php esc_html_e( 'при наведении', 'wescle' ) ?></label>
                <input class="widefat color-picker" id="<?php echo $this->get_field_id( 'button_color_hover' ); ?>" name="<?php echo $this->get_field_name( 'button_color_hover' ); ?>" type="text" value="<?php echo esc_attr( $button_color_hover ); ?>"/>
            </p>
            <p>
                <label class="label_color-picker" for="<?php echo $this->get_field_id( 'button_bg_hover' ); ?>"><?php _e( 'Фон', 'wescle' ); ?>&nbsp;<?php esc_html_e( 'при наведении', 'wescle' ) ?></label>
                <input class="widefat color-picker" id="<?php echo $this->get_field_id( 'button_bg_hover' ); ?>" name="<?php echo $this->get_field_name( 'button_bg_hover' ); ?>" type="text" value="<?php echo esc_attr( $button_bg_hover ); ?>"/>
            </p>
            <p>
                <label class="label_color-picker" for="<?php echo $this->get_field_id( 'button_border_hover' ); ?>"><?php _e( 'Обводка', 'wescle' ); ?>&nbsp;<?php esc_html_e( 'при наведении', 'wescle' ) ?></label>
                <input class="widefat color-picker" id="<?php echo $this->get_field_id( 'button_border_hover' ); ?>" name="<?php echo $this->get_field_name( 'button_border_hover' ); ?>" type="text" value="<?php echo esc_attr( $button_border_hover ); ?>"/>
            </p>
            <p class="wrap-button_blick_color_hover">
                <label class="label_color-picker" for="<?php echo $this->get_field_id( 'button_blick_color_hover' ); ?>"><?php _e( 'Цвет блика анимационного', 'wescle' ); ?>&nbsp;<?php esc_html_e( 'при наведении', 'wescle' ) ?></label>
                <input class="widefat color-picker" id="<?php echo $this->get_field_id( 'button_blick_color_hover' ); ?>" name="<?php echo $this->get_field_name( 'button_blick_color_hover' ); ?>" type="text" value="<?php echo esc_attr( $button_blick_color_hover ); ?>"/>
            </p>
            <p class="wrap-button_blick_speed">
                <label class="label_color-picker" for="<?php echo $this->get_field_id( 'button_blick_speed' ); ?>"><?php _e( 'Скорость анимации на кнопке', 'wescle' ); ?></label>
                <input class="small-text" id="<?php echo $this->get_field_id( 'button_blick_speed' ); ?>" name="<?php echo $this->get_field_name( 'button_blick_speed' ); ?>" type="number" min="0" value="<?php echo esc_attr( $button_blick_speed ); ?>"/>
            </p>
        </div>

        <div class="wrap-repeater-fields">
            <label><?php _e( 'Социальные сети', 'wescle' ) ?></label>
            <div class="repeater-fields">
				<?php foreach ( $socials as $social_item ) { ?>
                    <div class="repeater-row">
                        <div class="repeater-field">
                            <label>
                                <span class="label"><?php _e( 'Выбор соц сети', 'wescle' ) ?></span>
                                <select name="<?php echo $this->get_field_name( 'socials' ) ?>[type][]">
									<?php echo $this->get_socials_select_options( $social_item['type'] ); ?>
                                </select>
                            </label>
                        </div>
                        <div class="repeater-field">
                            <label>
                                <span class="label"><?php _e( 'Надпись', 'wescle' ) ?></span>
                                <input type="text" class="widefat" name="<?php echo $this->get_field_name( 'socials' ) ?>[label][]" value="<?php echo esc_attr( $social_item['label'] ); ?>">
                            </label>
                        </div>
                        <div class="repeater-field">
                            <label>
                                <span class="label"><?php _e( 'URL', 'wescle' ) ?></span>
                                <input type="text" class="widefat" name="<?php echo $this->get_field_name( 'socials' ) ?>[url][]" value="<?php echo $social_item['url']; ?>">
                            </label>
                        </div>
                        <div class="repeater-field alignright">
                            <button type="button" class="button-link button-link-delete"><?php echo $label_remove; ?></button>
                        </div>
                    </div>
				<?php } ?>
                <div class="repeater-field-hidden">
                    <div class="repeater-row">
                        <div class="repeater-field">
                            <label>
                                <span class="label"><?php _e( 'Выбор соц сети', 'wescle' ) ?></span>
                                <select name="<?php echo $this->get_field_name( 'socials' ) ?>[type][]">
									<?php echo $this->get_socials_select_options(); ?>
                                </select>
                            </label>
                        </div>
                        <div class="repeater-field">
                            <label>
                                <span class="label"><?php _e( 'Надпись', 'wescle' ) ?></span>
                                <input type="text" class="widefat" name="<?php echo $this->get_field_name( 'socials' ) ?>[label][]" value="">
                            </label>
                        </div>
                        <div class="repeater-field">
                            <label>
                                <span class="label"><?php _e( 'URL', 'wescle' ) ?></span>
                                <input type="text" class="widefat" name="<?php echo $this->get_field_name( 'socials' ) ?>[url][]" value="">
                            </label>
                        </div>
                        <div class="repeater-field alignright">
                            <button type="button" class="button-link button-link-delete"><?php echo $label_remove; ?></button>
                        </div>
                    </div>
                </div>
            </div>
            <button type="button" class="button-secondary repeater-add-item"><?php _e( 'Добавить сеть', 'wescle' ) ?></button>
        </div>

        <input type="hidden" class="widget-contact_v2-input-hidden">
		<?php
	}

	public function get_socials_select_options( $selected = '' ) {
		$html                = '';
		$social_type_choices = apply_filters( 'wescle_widget_socials_options', [
			''         => __( 'Выбрать...', 'wescle' ),
			'facebook' => __( 'Facebook', 'wescle' ),
			'telegram' => __( 'Telegram', 'wescle' ),
			'viber'    => __( 'Viber', 'wescle' ),
			'whatsapp' => __( 'WhatsApp', 'wescle' ),
			'skype'    => __( 'Skype', 'wescle' ),
			'wechat'   => __( 'WeChat', 'wescle' ),
		] );

		foreach ( $social_type_choices as $key => $label ) {
			$html .= '<option value="' . $key . '" ' . selected( $selected, $key, false ) . '>' . $label . '</option>';
		}

		return $html;
	}

	public function update( $new_instance, $old_instance ) {
		$instance            = $old_instance;
		$instance['title_1'] = sanitize_text_field( $new_instance['title_1'] );
		$instance['image_1'] = $new_instance['image_1'];
		$instance['text_1']  = $new_instance['text_1'];

		$instance['title_2'] = sanitize_text_field( $new_instance['title_2'] );
		$instance['image_2'] = $new_instance['image_2'];
		$instance['text_2']  = $new_instance['text_2'];

		$phones = [];
		foreach ( $new_instance['phones'] as $item ) {
			if ( $item ) {
				$phones[] = $item;
			}
		}
		$instance['phones'] = $phones;

		$instance['phone_as_link']            = $new_instance['phone_as_link'] ?? false;
		$instance['button_label']             = $new_instance['button_label'];
		$instance['button_link']              = $new_instance['button_link'];
		$instance['button_type']              = $new_instance['button_type'];
		$instance['button_color']             = $new_instance['button_color'];
		$instance['button_bg']                = $new_instance['button_bg'];
		$instance['button_border']            = $new_instance['button_border'];
		$instance['button_blick_color']       = $new_instance['button_blick_color'];
		$instance['button_color_hover']       = $new_instance['button_color_hover'];
		$instance['button_bg_hover']          = $new_instance['button_bg_hover'];
		$instance['button_border_hover']      = $new_instance['button_border_hover'];
		$instance['button_blick_color_hover'] = $new_instance['button_blick_color_hover'];
		$instance['button_blick_speed']       = $new_instance['button_blick_speed'];

		$socials = [];
		foreach ( $new_instance['socials']['label'] as $key => $label ) {
			if ( $label ) {
				$socials[] = [
					'type'  => $new_instance['socials']['type'][ $key ],
					'label' => $label,
					'url'   => $new_instance['socials']['url'][ $key ],
				];
			}
		}

		$instance['socials'] = $socials;

		return $instance;
	}

	public function get_button_style( $args, $instance ) {
		$css_style    = '';
		$button_class = '';
		if ( isset( $args['widget_id'] ) ) {
			$button_class = '#' . $args['widget_id'] . ' .btn-main';
		}

		$button_type = $instance['button_type'];

		if ( 'custom' == $button_type || 'animation' == $button_type ) {
			$color    = $instance['button_color'];
			$color_bg = $instance['button_bg'];
			$border   = $instance['button_border'];

			$styles = [];
			if ( $color ) {
				$styles[] = 'color:' . $color;
			}
			if ( $color_bg ) {
				$styles[] = 'background-color:' . $color_bg;
			}
			if ( $border ) {
				$styles[] = 'border-color:' . $border;
			}
			if ( $styles && $button_class ) {
				$css_style .= $button_class . '{' . implode( ';', $styles ) . '}';
			}

			$color    = $instance['button_color_hover'];
			$color_bg = $instance['button_bg_hover'];
			$border   = $instance['button_border_hover'];

			$styles = [];
			if ( $color ) {
				$styles[] = 'color:' . $color;
			}
			if ( $color_bg ) {
				$styles[] = 'background-color:' . $color_bg;
			}
			if ( $border ) {
				$styles[] = 'border-color:' . $border;
			}
			if ( $styles && $button_class ) {
				$css_style .= $button_class . ':hover{' . implode( ';', $styles ) . '}';
			}

			if ( 'animation' == $button_type ) {
				$styles         = [];
				$color_bg       = $instance['button_blick_color'];
				$color_bg_hover = $instance['button_blick_color_hover'];
				$speed          = $instance['button_blick_speed'];
				if ( $speed != 4 ) {
					$styles[] = '-webkit-animation-duration:' . $speed . 's';
					$styles[] = 'animation-duration:' . $speed . 's';
				}
				if ( $color_bg ) {
					$styles[] = 'background:' . $color_bg;
				}
				if ( $styles && $button_class ) {
					$css_style .= $button_class . '.btn-flare:after{' . implode( ';', $styles ) . '}';
				}

				if ( $color_bg_hover && $button_class ) {
					$css_style .= $button_class . '.btn-flare:hover:after{background:' . $color_bg_hover . '}';
				}
			}

			if ( $css_style ) {
				$css_style = '<style>' . $css_style . '</style>';
			}
		}

		return $css_style;
	}
}