<?php

class Wescle_Widget_Catalog_Filter_Chosen extends WP_Widget {

	function __construct() {
		$this->label_title = __( 'Активные фильтры', 'wescle' );

		parent::__construct(
			THEME_SLUG . '_widget_catalog_filter_chosen',
			'Wescle: ' . __( 'Активные фильтры каталога', 'wescle' ),
			array(
				'description'                 => __( 'Отображать список активных фильтров каталога', 'wescle' ),
				'classname'                   => 'widget_layered_nav_filters',
				'customize_selective_refresh' => true,
				'show_instance_in_rest'       => true,
			)
		);
	}

	public function widget( $args, $instance ) {
		if ( ! is_page_template( 'templates/template-catalog_wescle.php' ) && ! is_tax( Helper::get_catalog_taxs() ) ) {
			return;
		}

		$instance       = wp_parse_args(
			(array) $instance,
			array(
				'title' => $this->label_title,
			)
		);
		$title          = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		$chosen_filters = WsclAdminFilters::get_filter_nav_chosen();
		$base_link      = WsclAdminFilters::get_current_page_url();

		if ( 0 < count( $chosen_filters ) ) {

			echo $args['before_widget'];

			if ( ! empty( $title ) ) {
				echo $args['before_title'] . $title . $args['after_title'];
			}

			echo '<ul>';

			// Filters.
			foreach ( $chosen_filters as $taxonomy => $data ) {
				foreach ( $data['terms'] as $term_slug ) {
					$term = get_term_by( 'slug', $term_slug, $taxonomy );
					if ( ! $term ) {
						continue;
					}

					$filter_name    = 'filters_' . str_replace( 'filter_', '', $taxonomy );
					$current_filter = isset( $_GET[ $filter_name ] ) ? explode( ',', wp_unslash( $_GET[ $filter_name ] ) ) : array(); // WPCS: input var ok, CSRF ok.
					$current_filter = array_map( 'sanitize_title', $current_filter );
					$new_filter     = array_diff( $current_filter, array( $term_slug ) );

					$link = remove_query_arg( array( $filter_name ), $base_link );

					if ( count( $new_filter ) > 0 ) {
						$link = add_query_arg( $filter_name, implode( ',', $new_filter ), $link );
					}

					$filter_classes = array( 'chosen', 'chosen-' . sanitize_html_class( str_replace( 'filter_', '', $taxonomy ) ), 'chosen-' . sanitize_html_class( str_replace( 'filter_', '', $taxonomy ) . '-' . $term_slug ) );

					echo '<li class="' . esc_attr( implode( ' ', $filter_classes ) ) . '"><a rel="nofollow" aria-label="' . esc_attr__( 'Удалить фильтр', 'wescle' ) . '" href="' . esc_url( $link ) . '">' . esc_html( $term->name ) . '</a></li>';
				}
			}

			echo '</ul>';

			$label_reset = __( 'Сбросить', 'wescle' );
			$clear_link  = WsclAdminFilters::get_current_page_url( true );
			echo '<a rel="nofollow" class="btn btn-main btn-reset" aria-label="' . esc_attr( $label_reset ) . '" href="' . esc_url( $clear_link ) . '">' . esc_html( $label_reset ) . '</a>';

			echo $args['after_widget'];
		}
	}

	public function form( $instance ) {
		$instance = wp_parse_args(
			(array) $instance,
			array(
				'title' => $this->label_title,
			)
		);

		$title = sanitize_text_field( $instance['title'] );
		?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Заголовок', 'wescle' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
        </p>
		<?php
	}

	public function update( $new_instance, $old_instance ) {
		$instance          = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );

		return $instance;
	}
}