<?php

class Wescle_Widget_Viewed_Products extends WC_Widget_Recently_Viewed {

	public function widget( $args, $instance ) {
		$viewed_products = ! empty( $_COOKIE['woocommerce_recently_viewed'] ) ? (array) explode( '|', wp_unslash( $_COOKIE['woocommerce_recently_viewed'] ) ) : array(); // @codingStandardsIgnoreLine
		$viewed_products = array_reverse( array_filter( array_map( 'absint', $viewed_products ) ) );

		if ( empty( $viewed_products ) ) {
			return;
		}

		ob_start();

		$number = ! empty( $instance['number'] ) ? absint( $instance['number'] ) : $this->settings['number']['std'];

		$query_args = array(
			'posts_per_page' => $number,
			'no_found_rows'  => 1,
			'post_status'    => 'publish',
			'post_type'      => 'product',
			'post__in'       => $viewed_products,
			'orderby'        => 'post__in',
		);

		if ( 'yes' === get_option( 'woocommerce_hide_out_of_stock_items' ) ) {
			$query_args['tax_query'] = array(
				array(
					'taxonomy' => 'product_visibility',
					'field'    => 'name',
					'terms'    => 'outofstock',
					'operator' => 'NOT IN',
				),
			); // WPCS: slow query ok.
		}

		$r = new WP_Query( apply_filters( 'woocommerce_recently_viewed_products_widget_query_args', $query_args ) );

		if ( $r->have_posts() ) {

			$this->widget_start( $args, $instance );

			?>
            <div class="latest-products__row">
				<?php
				while ( $r->have_posts() ) {
					$r->the_post();
					global $product;
					?>
                    <div class="latest-products__col">
                        <div class="latest-products-item">
                            <div class="latest-products-item__grid">
                                <div class="latest-products-item__grid-inner">
                                    <div class="latest-products-item__body">
                                        <figure>
                                            <a class="latest-products-item__image" href="<?php echo $product->get_permalink(); ?>">
												<?php echo $product->get_image( 'medium' ); ?>
                                            </a>
                                        </figure>
                                    </div>
                                    <h3 class="latest-products-item__name"><a href="<?php echo $product->get_permalink(); ?>"><?php echo $product->get_title(); ?></a></h3>
                                    <div class="latest-products-item__meta">
                                        <span class="price product-cart__price"><?php echo $product->get_price_html(); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
					<?php
				}
				?>
            </div>
			<?php

			$this->widget_end( $args );
		}

		wp_reset_postdata();

		$content = ob_get_clean();

		echo $content; // WPCS: XSS ok.
	}
}