<?php

class Wescle_Widget_Top_Products extends WC_Widget_Top_Rated_Products {

	public function widget( $args, $instance ) {

		if ( $this->get_cached_widget( $args ) ) {
			return;
		}

		ob_start();

		$number = ! empty( $instance['number'] ) ? absint( $instance['number'] ) : $this->settings['number']['std'];

		$query_args = apply_filters(
			'woocommerce_top_rated_products_widget_args',
			array(
				'posts_per_page' => $number,
				'no_found_rows'  => 1,
				'post_status'    => 'publish',
				'post_type'      => 'product',
				'meta_key'       => '_wc_average_rating',
				'orderby'        => 'meta_value_num',
				'order'          => 'DESC',
				'meta_query'     => WC()->query->get_meta_query(),
				'tax_query'      => WC()->query->get_tax_query(),
			)
		); // WPCS: slow query ok.

		$r = new WP_Query( $query_args );

		if ( $r->have_posts() ) {

			$this->widget_start( $args, $instance );
			?>
            <div class="latest-products__row">
				<?php
				while ( $r->have_posts() ) {
					$r->the_post();
					global $product;
					?>
                    <div class="latest-products__col">
                        <div class="latest-products-item">
                            <div class="latest-products-item__grid">
                                <div class="latest-products-item__grid-inner">
                                    <div class="latest-products-item__body">
                                        <figure>
                                            <a class="latest-products-item__image" href="<?php echo $product->get_permalink(); ?>">
												<?php echo $product->get_image( 'medium' ); ?>
                                            </a>
                                        </figure>
                                    </div>
                                    <h3 class="latest-products-item__name"><a href="<?php echo $product->get_permalink(); ?>"><?php echo $product->get_title(); ?></a></h3>
                                    <div class="latest-products-item__meta">
                                        <span class="price product-cart__price"><?php echo $product->get_price_html(); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
					<?php
				}
				?>
            </div>
			<?php

			$this->widget_end( $args );
		}

		wp_reset_postdata();

		$content = ob_get_clean();

		echo $content; // WPCS: XSS ok.

		$this->cache_widget( $args, $content );
	}
}