<?php

class Wescle_Widget_Products extends WC_Widget_Products {

	public function widget( $args, $instance ) {
		if ( $this->get_cached_widget( $args ) ) {
			return;
		}

		ob_start();

		$products = $this->get_products( $args, $instance );
		if ( $products && $products->have_posts() ) {
			$this->widget_start( $args, $instance );
			?>
            <div class="latest-products__row">
				<?php
				while ( $products->have_posts() ) {
					$products->the_post();
					global $product;
					?>
                    <div class="latest-products__col">
                        <div class="latest-products-item">
                            <div class="latest-products-item__grid">
                                <div class="latest-products-item__grid-inner">
                                    <div class="latest-products-item__body">
                                        <figure>
                                            <a class="latest-products-item__image" href="<?php echo $product->get_permalink(); ?>">
												<?php echo $product->get_image( 'medium' ); ?>
                                            </a>
                                        </figure>
                                    </div>
                                    <h3 class="latest-products-item__name"><a href="<?php echo $product->get_permalink(); ?>"><?php echo $product->get_title(); ?></a></h3>
                                    <div class="latest-products-item__meta">
                                        <span class="price product-cart__price"><?php echo $product->get_price_html(); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
					<?php
				}
				?>
            </div>
			<?php
			$this->widget_end( $args );
		}

		wp_reset_postdata();

		echo $this->cache_widget( $args, ob_get_clean() ); // WPCS: XSS ok.
	}
}