<?php

class Wescle_Widget_Product_Tags extends WC_Widget_Product_Tag_Cloud {

	public function widget( $args, $instance ) {
		$current_taxonomy = $this->get_current_taxonomy( $instance );

		if ( empty( $instance['title'] ) ) {
			$taxonomy          = get_taxonomy( $current_taxonomy );
			$instance['title'] = $taxonomy->labels->name;
		}

		$args_terms = apply_filters( 'wescle_widget_product_tags_args', [
			'taxonomy'   => 'product_tag',
			'hide_empty' => true,
			'number'     => 10,
			'orderby'    => 'count',
			'order'      => 'DESC',
		] );
		$terms      = get_terms( $args_terms );

		if ( ! $terms ) {
			return;
		}

		$this->widget_start( $args, $instance );

		$show_count = true;

		if ( $terms ) {
			$current_term_id = 0;
			if ( is_tax( 'product_tag' ) ) {
				$current_term_id = get_queried_object_id();
			}

			echo '<div class="row tags__row tags">';
			foreach ( $terms as $term ) {
				$title = '<span class="category__title">#' . $term->name . '</span>';
				if ( $show_count ) {
					$title .= '<span class="category__count">' . $term->count . '</span>';
				}

				if ( $img_id = get_term_meta( $term->term_id, '_thumbnail_id', 1 ) ) {
					$title = '<div class="category__img">' . wp_get_attachment_image( $img_id, 'thumbnail' ) . '</div>' . $title;
				}

				if ( $term->term_id == $current_term_id ) {
					$term_item = '<span class="category">#' . $title . '</span>';
				}
				else {
					$term_item = '<a class="category" href="' . esc_url( get_term_link( $term ) ) . '">' . $title . '</a>';
				}

				echo '<div class="col tags__col">';
				echo '<div class="tags__item">' . $term_item . '</div>';
				echo '</div>';
			}
			echo '</div>';
		}

		$this->widget_end( $args );
	}
}