<?php

class Wescle_Widget_Product_Categories extends WP_Widget {

	function __construct() {
		parent::__construct(
			THEME_SLUG . '_widget_store_product_categories',
			'Wescle Store: ' . __( 'Категории товаров', 'wescle' ),
			array(
				'description'                 => __( 'Выводит блок с категориями товаров', 'wescle' ),
				'classname'                   => 'aside-store-categories',
				'customize_selective_refresh' => true,
				'show_instance_in_rest'       => true,
			)
		);
	}

	public function widget( $args, $instance ) {
		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
		/*
		$orderby = isset( $instance['orderby'] ) ? $instance['orderby'] : 'count';
		$order   = 'count' === $orderby ? 'DESC' : 'ASC';
		*/

		$show_image    = isset( $instance['show_image'] ) ? $instance['show_image'] : 1;
		$show_count    = isset( $instance['show_count'] ) ? $instance['show_count'] : 1;
		$show_children = isset( $instance['show_children'] ) ? $instance['show_children'] : 1;

		$terms_data = WsclWoocommerce::get_shop_categories();

		if ( ! $terms_data ) {
			return;
		}

		echo $args['before_widget'];

		if ( ! empty( $title ) ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}

		$template_args = [ 'terms_data' => $terms_data, 'show_image' => $show_image, 'show_count' => $show_count, 'show_children' => $show_children ];
		get_template_part( 'template-parts/widgets/widget', 'product_cats', $template_args );

		echo $args['after_widget'];
	}

	public function form( $instance ) {
		$instance      = wp_parse_args(
			(array) $instance,
			array(
				'title'         => __( 'Категории товаров', 'wescle' ),
				'limit'         => 10,
				'orderby'       => 'name',
				'show_image'    => 1,
				'show_count'    => 1,
				'show_children' => 1,
			)
		);
		$title         = sanitize_text_field( $instance['title'] );
		$show_image    = $instance['show_image'];
		$show_count    = $instance['show_count'];
		$show_children = $instance['show_children'];
		?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Заголовок', 'wescle' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>"/>
        </p>
		<?php
		/*
		<p>
			<label for="<?php echo $this->get_field_id( 'limit' ); ?>"><?php _e( 'Количество категорий', 'wescle' ); ?></label>
			<input id="<?php echo $this->get_field_id( 'limit' ); ?>" class="tiny-text" name="<?php echo $this->get_field_name( 'limit' ); ?>" type="number" step="1" min="1" value="<?php echo $limit; ?>" size="3"/>
		</p>
        */
		?>
        <!--
        <p>
            <label for="<?php echo $this->get_field_id( 'orderby' ); ?>"><?php _e( 'Сортировать', 'wescle' ); ?></label>
            <select name="<?php echo $this->get_field_name( 'orderby' ); ?>" id="<?php echo $this->get_field_id( 'orderby' ); ?>" class="widefat">
                <option value="name"<?php selected( $instance['orderby'], 'name' ); ?>><?php _e( 'По имени', 'wescle' ); ?></option>
                <option value="count"<?php selected( $instance['orderby'], 'count' ); ?>><?php _e( 'По количеству товаров', 'wescle' ); ?></option>
                <option value="menu_order"<?php selected( $instance['orderby'], 'menu_order' ); ?>><?php _e( 'По порядку категорий', 'wescle' ); ?></option>
            </select>
        </p>
        -->

        <p>
            <input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id( 'show_image' ); ?>" name="<?php echo $this->get_field_name( 'show_image' ); ?>"<?php checked( $show_image ); ?> />
            <label for="<?php echo $this->get_field_id( 'show_image' ); ?>"><?php _e( 'Показывать изображение категорий', 'wescle' ); ?></label>
        </p>

        <p>
            <input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id( 'show_count' ); ?>" name="<?php echo $this->get_field_name( 'show_count' ); ?>"<?php checked( $show_count ); ?> />
            <label for="<?php echo $this->get_field_id( 'show_count' ); ?>"><?php _e( 'Отображать число товаров', 'wescle' ); ?></label>
        </p>

        <p>
            <input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id( 'show_children' ); ?>" name="<?php echo $this->get_field_name( 'show_children' ); ?>"<?php checked( $show_children ); ?> />
            <label for="<?php echo $this->get_field_id( 'show_children' ); ?>"><?php _e( 'Показывать дочерние категории', 'wescle' ); ?></label>
        </p>
		<?php
	}

	public function update( $new_instance, $old_instance ) {
		$instance          = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		/*$instance['limit']         = absint( $new_instance['limit'] );*/
		/*$instance['orderby']       = $new_instance['orderby'];*/
		$instance['show_image']    = isset( $new_instance['show_image'] ) ? 1 : 0;
		$instance['show_count']    = isset( $new_instance['show_count'] ) ? 1 : 0;
		$instance['show_children'] = isset( $new_instance['show_children'] ) ? 1 : 0;

		return $instance;
	}
}