<?php

class Wescle_Widget_Layered_Nav extends WC_Widget_Layered_Nav {
	public function __construct() {
		$this->widget_cssclass    = 'aside-store-checkboxes woocommerce widget_layered_nav woocommerce-widget-layered-nav';
		$this->widget_description = __( 'Display a list of attributes to filter products in your store.', 'woocommerce' );
		$this->widget_id          = 'woocommerce_layered_nav';
		$this->widget_name        = __( 'Filter Products by Attribute', 'woocommerce' );
		WC_Widget::__construct();
	}

	/**
	 * Show list based layered nav.
	 *
	 * @param array $terms Terms.
	 * @param string $taxonomy Taxonomy.
	 * @param string $query_type Query Type.
	 *
	 * @return bool   Will nav display?
	 */
	protected function layered_nav_list( $terms, $taxonomy, $query_type ) {

		echo '<div class="aside-store-checkboxes__body">';
		echo '<ul class="aside-store-checkboxes__list" aria-expanded="false">';

		$term_counts        = $this->get_filtered_term_product_counts( wp_list_pluck( $terms, 'term_id' ), $taxonomy, $query_type );
		$_chosen_attributes = WC_Query::get_layered_nav_chosen_attributes();
		$found              = false;
		$base_link          = $this->get_current_page_url();

		$loop = 0;
		foreach ( $terms as $term ) {
			$current_values = isset( $_chosen_attributes[ $taxonomy ]['terms'] ) ? $_chosen_attributes[ $taxonomy ]['terms'] : array();
			$option_is_set  = in_array( $term->slug, $current_values, true );
			$count          = isset( $term_counts[ $term->term_id ] ) ? $term_counts[ $term->term_id ] : 0;

			// Skip the term for the current archive.
			if ( $this->get_current_term_id() === $term->term_id ) {
				continue;
			}

			// Only show options with count > 0.
			if ( 0 < $count ) {
				$found = true;
			}
            elseif ( 0 === $count && ! $option_is_set ) {
				continue;
			}

			$filter_name = 'filter_' . wc_attribute_taxonomy_slug( $taxonomy );
			// phpcs:ignore WordPress.Security.NonceVerification.Recommended
			$current_filter = isset( $_GET[ $filter_name ] ) ? explode( ',', wc_clean( wp_unslash( $_GET[ $filter_name ] ) ) ) : array();
			$current_filter = array_map( 'sanitize_title', $current_filter );

			if ( ! in_array( $term->slug, $current_filter, true ) ) {
				$current_filter[] = $term->slug;
			}

			$link = remove_query_arg( $filter_name, $base_link );

			// Add current filters to URL.
			foreach ( $current_filter as $key => $value ) {
				// Exclude query arg for current term archive term.
				if ( $value === $this->get_current_term_slug() ) {
					unset( $current_filter[ $key ] );
				}

				// Exclude self so filter can be unset on click.
				if ( $option_is_set && $value === $term->slug ) {
					unset( $current_filter[ $key ] );
				}
			}

			if ( ! empty( $current_filter ) ) {
				asort( $current_filter );
				$link = add_query_arg( $filter_name, implode( ',', $current_filter ), $link );

				// Add Query type Arg to URL.
				if ( 'or' === $query_type && ! ( 1 === count( $current_filter ) && $option_is_set ) ) {
					$link = add_query_arg( 'query_type_' . wc_attribute_taxonomy_slug( $taxonomy ), 'or', $link );
				}
				$link = str_replace( '%2C', ',', $link );
			}

			$term_check = '<div class="aside-store-checkboxes__check"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 16 16"><g fill="#08c"><path fill-rule="evenodd" d="M10.97 4.97a.75.75 0 0 1 1.071 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093l3.473-4.425a.236.236 0 0 1 .02-.022z"></path></g></svg></div>';
			if ( get_term_meta( $term->term_id, 'term_color', 1 ) ) {
				$term_color = '<div class="aside-store-checkboxes__color" data-color="black"></div>';
			}
			else {
				$term_color = '<div class="aside-store-checkboxes__image"><img width="150" height="150" src="http://wscl-store.test/wp-content/uploads/2021/06/beanie-2-150x150.jpg" class="attachment-thumbnail size-thumbnail" alt="" loading="lazy" srcset="http://wscl-store.test/wp-content/uploads/2021/06/beanie-2-150x150.jpg 150w, http://wscl-store.test/wp-content/uploads/2021/06/beanie-2-100x100.jpg 100w, http://wscl-store.test/wp-content/uploads/2021/06/beanie-2-600x600.jpg 600w, http://wscl-store.test/wp-content/uploads/2021/06/beanie-2-300x300.jpg 300w, http://wscl-store.test/wp-content/uploads/2021/06/beanie-2-768x768.jpg 768w, http://wscl-store.test/wp-content/uploads/2021/06/beanie-2-31x31.jpg 31w, http://wscl-store.test/wp-content/uploads/2021/06/beanie-2-71x71.jpg 71w, http://wscl-store.test/wp-content/uploads/2021/06/beanie-2-120x120.jpg 120w, http://wscl-store.test/wp-content/uploads/2021/06/beanie-2-450x450.jpg 450w, http://wscl-store.test/wp-content/uploads/2021/06/beanie-2.jpg 801w" sizes="(max-width: 150px) 100vw, 150px"></div>';
			}

			$term_name  = '<span class="aside-store-checkboxes__name">' . esc_html( $term->name ) . '</span>';
			$term_count = apply_filters( 'woocommerce_layered_nav_count', '<span class="aside-store-checkboxes__count">(' . absint( $count ) . ')</span>', $count, $term );

			$term_data = $term_check . $term_name . $term_count;

			if ( $count > 0 || $option_is_set ) {
				$link      = apply_filters( 'woocommerce_layered_nav_link', $link, $term, $taxonomy );
				$term_html = '<a rel="nofollow" href="' . esc_url( $link ) . '">' . $term_data . '</a>';
			}
			else {
				$link      = false;
				$term_html = '<span>' . $term_data . '</span>';
			}

			echo '<li class="woocommerce-widget-layered-nav-list__item wc-layered-nav-term ' . ( $option_is_set ? 'woocommerce-widget-layered-nav-list__item--chosen chosen' : '' ) . '">';
			// phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.EscapeOutput.OutputNotEscaped
			echo apply_filters( 'woocommerce_layered_nav_term_html', $term_html, $term, $link, $count );
			echo '</li>';

			$loop ++;
		}

		echo '</ul>';
		if ( $loop > 6 ) {
			$open_text  = Helper::get_text_label( 'show_more' );
			$close_text = Helper::get_text_label( 'close' );

			echo '<a class="view-more" href="#" aria-expanded="false" data-open-name="' . $open_text . '" data-close-name="' . $close_text . '">' . $open_text . '</a>';
		}
		echo '</div>';

		return $found;
	}
}