<?php

function renderPortfolios( $block_attributes ) {
	global $post;

	unset( $block_attributes['pages'] );

	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? Helper::get_default_theme_data( 'home_portfolio_title' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';
	$text       = $block_attributes['about'] ?? '';

	$link    = '';
	$link_id = $block_attributes['link'] ?? '';
	if ( $link_id ) {
		$link = get_permalink( $link_id );
	}
	$link_text = $block_attributes['allServices'] ?? Helper::get_default_theme_data( 'home_portfolio_link_text' );
	$more_text = $block_attributes['button'] ?? Helper::get_default_theme_data( 'home_portfolio_more_text' );

	$portfolio_post_ids  = [];
	$home_portfolio_data = [];
	$portfolio_sizes     = [];
	if ( isset( $block_attributes['services'] ) && $block_attributes['services'] ) {
		foreach ( $block_attributes['services'] as $item ) {
			$post_id = $item['service']['id'];

			$portfolio_post_ids[] = $post_id;

			$size = 'default';
			if ( isset( $item['isBig'] ) && $item['isBig'] ) {
				$size = 'big';
			}
			$home_portfolio_data[ $post_id ]['size'] = $size;
			$portfolio_sizes[]                       = $size;
		}
	}

	$posts_per_page = $block_attributes['itemsOnPage'] ?? 4;
	$post__in       = [];
	$orderby        = 'date';
	if ( $portfolio_post_ids ) {
		$posts_per_page = count( $portfolio_post_ids );
		$post__in       = $portfolio_post_ids;
		$orderby        = 'post__in';
	}

	$args            = [
		'post_type'        => 'portfolio_wescle',
		'posts_per_page'   => $posts_per_page,
		'post__in'         => $post__in,
		'orderby'          => $orderby,
		'suppress_filters' => false
	];
	$portfolio_posts = get_posts( $args );
	if ( ! $portfolio_posts ) {
		return;
	}

	$args_next = $args;
	unset( $args_next['post__in'] );
	unset( $args_next['orderby'] );
	$args_next['posts_per_page'] = $posts_per_page + 1;
	$args_next['fields']         = 'ids';

	$portfolio_posts_next = get_posts( $args_next );

	$section_class = '';

	$style_bg = '';
	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	ob_start();
	?>
    <div class="wp-block-wescle-blocks-work-performed work-performed <?php echo $section_class; ?>" <?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
			<?php
			if ( $title ) {
				printf( '<%1$s class="work-performed__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
            <div class="work-performed__about">
				<?php if ( isset( $block_attributes['aboutImg'] ) ) { ?>
					<?php echo wp_get_attachment_image( $block_attributes['aboutImg']['id'], 'medium_large' ); ?>
				<?php } ?>
				<?php if ( $text ) { ?>
                    <div class="work-performed__text"><?php echo $text; ?></div>
				<?php } ?>
				<?php if ( $link && $link_text ) { ?>
                    <a class="work-performed__link" href="<?php echo $link; ?>"><?php echo esc_html( $link_text ); ?></a>
				<?php } ?>
            </div>
            <div class="row work-performed-items">
				<?php
				set_query_var( 'template_args', [ 'portfolio_data' => $home_portfolio_data ] );
				$portfolio_post_ids = [];
				foreach ( $portfolio_posts as $post ) {
					setup_postdata( $post );
					$portfolio_post_ids[] = $post->ID;

					get_template_part( 'template-parts/content/portfolio', 'item' );
				}
				wp_reset_postdata();
				?>
            </div>
			<?php if ( $more_text && count( $portfolio_posts_next ) > $posts_per_page ) { ?>
                <div class="work-performed__more">
                    <a class="work-performed__btn btn btn-main btn-more-work" data-paged="1" data-portfolio_sizes="<?php echo implode( ',', $portfolio_sizes ); ?>" data-portfolio_post_ids="<?php echo implode( ',', $portfolio_post_ids ); ?>" href="#"><?php echo $more_text; ?></a>
                </div>
			<?php } ?>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/work-performed', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderPortfolios'
) );