<?php

function renderWescleCatalogCats( $block_attributes ) {

	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? __( 'Категории', 'wescle' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';

	$text      = $block_attributes['about'] ?? '';
	$link_url  = $block_attributes['linkURL'] ?? '';
	$link_text = $block_attributes['linkText'] ?? '';

	$taxonomy = $block_attributes['selectedTaxonomy'] ?? '';
	if ( ! $taxonomy ) {
		return;
	}

	$terms_args        = [
		'taxonomy'   => $taxonomy,
		'hide_empty' => false,
		'orderby'    => 'menu_order',
	];
	$category_selected = $block_attributes['categoriesByID'] ?? '';
	if ( $category_selected ) {
		$category_selected     = array_map( 'trim', explode( ',', $category_selected ) );
		$terms_args['include'] = $category_selected;
		$terms_args['orderby'] = 'include';
	}
	else {
		$limit = $block_attributes['categoriesOnPage'] ?? '';
		if ( $limit < 1 ) {
			$limit = 10;
		}
		$terms_args['number'] = $limit;
	}
	$terms = get_terms( $terms_args );
	if ( ! $terms || is_wp_error( $terms ) ) {
		return;
	}

	$category_shadow       = $block_attributes['categoriesShadow'] ?? true;
	$category_count_at_img = $block_attributes['categoriesCountAtImg'] ?? false;
	$category_show_count   = $block_attributes['categoriesCount'] ?? true;

	$slider_enabled = $block_attributes['withCarousel'] ?? true;
	$slides_count   = $block_attributes['slidesCount'] ?? 5;
	if ( ! $slider_enabled ) {
		$slides_count = $block_attributes['gridColumns'] ?? 5;
	}
	$slider_speed = $block_attributes['sliderSpeed'] ?? 8;
	$slider_speed = $slider_speed * 1000;

	$slider_dots          = isset( $block_attributes['dotsVisible'] ) && $block_attributes['dotsVisible'] ? 'true' : 'false';
	$slider_arrows        = isset( $block_attributes['arrowsVisible'] ) && ! $block_attributes['arrowsVisible'] ? 'false' : 'true';
	$slider_arrows_mobile = isset( $block_attributes['hideArrowsMobile'] ) && ! $block_attributes['hideArrowsMobile'] ? '_hide-arrows-mobile' : '';


	$style_bg      = '';
	$section_class = 'wp-block-wescle-blocks-wescle-categories wescle-categories wescle-categories-noslider';
	if ( $slider_enabled ) {
		$section_class = 'wp-block-wescle-blocks-wescle-categories wescle-categories';
	}

	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	if ( ! $category_shadow ) {
		$section_class .= ' _without-shadow';
	}
	if ( $category_count_at_img ) {
		$section_class .= ' _count-at-img';
	}

	ob_start();
	unset( $block_attributes['blocks'] );
	?>
    <div class="wp-block-wescle-blocks-wescle-catalog-advantages wescle-catalog-advantages <?php echo $section_class; ?>" <?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
			<?php include get_template_directory() . '/template-parts/home/catalogcats-container.php'; ?>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/wescle-categories', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderWescleCatalogCats'
) );