<?php

function renderWescleCatalog( $block_attributes ) {
	static $key_block = 0;
	$key_block ++;

	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? Helper::get_default_theme_data( 'home_block_titles', 'home_catalog' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';

	$text       = $block_attributes['about'] ?? 'Vestibulum ac diam sit amet quam vehicula elementum sed sit amet dui. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque in ipsum id orci porta dapibus.';
	$aboutImage = $block_attributes['aboutImage'] ?? '';
	$link       = '';
	$link_id    = $block_attributes['link'] ?? '';
	if ( $link_id ) {
		$link = get_permalink( $link_id );
	}
	$link_text = $block_attributes['linkText'] ?? Helper::get_default_theme_data( 'module_catalog_link_text' );
	$more_text = $block_attributes['showMore'] ?? Helper::get_default_theme_data( 'module_catalog_more_text' );

	$section_class = '';
	$style_bg      = '';

	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	ob_start();

	unset( $block_attributes['pages'] );
	unset( $block_attributes['products'] );

	foreach ( $block_attributes['services'] as $key => $item ) {
		unset( $block_attributes['services'][ $key ]['arrayProductsByID'] );
		unset( $block_attributes['services'][ $key ]['arrayProductsByCategories'] );
	}
	?>
    <div class="wp-block-wescle-blocks-wescle-transport wescle-transport <?php echo $section_class; ?>" <?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
			<?php
			if ( $title ) {
				printf( '<%1$s class="wescle-transport__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
			<?php if ( $text || $link ) { ?>
                <div class="wescle-transport__about _section-about">
					<?php if ( $aboutImage && isset( $aboutImage['id'] ) ) { ?>
						<?php echo wp_get_attachment_image( $aboutImage['id'], 'medium' ); ?>
					<?php } ?>
					<?php if ( $text ) { ?>
                        <div class="_section-about__text"><?php echo $text; ?></div>
					<?php } ?>
					<?php if ( $link && $link_text ) { ?>
                        <a class="wescle-transport__link" href="<?php echo $link; ?>"><?php echo esc_html( $link_text ); ?></a>
					<?php } ?>
                </div>
			<?php } ?>
			<?php
			$module_catalog_tabs = [];
			foreach ( $block_attributes['services'] as $item ) {
				$module_catalog_tabs[] = [
					'catalog_tab_title'    => $item['title'],
					'catalog_tab_category' => wp_list_pluck( $item['productsByCategories'], 'id' ),
					'catalog_tab_limit'    => $item['goodsOnPage'],
					'catalog_tab_item_ids' => $item['productsByID'],
				];
			}
			$args = [
				'module_catalog_tabs' => $module_catalog_tabs,
				'more_text'           => $more_text,
			];
			get_template_part( 'template-parts/home/catalog-tabs', null, $args );
			?>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/wescle-catalog', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderWescleCatalog'
) );