<?php

function renderWescleCatalogOptions( $block_attributes ) {
	static $key_block = 0;
	$key_block ++;

	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? __( 'Заголовок', 'wescle' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';

	$info_ids   = isset( $block_attributes['selectedBlocks'] ) && $block_attributes['selectedBlocks'] ? wp_list_pluck( $block_attributes['selectedBlocks'], 'id' ) : [];
	$info_items = get_posts( [
		'post_type'      => 'info_catalog',
		'posts_per_page' => $info_ids ? count( $info_ids ) : - 1,
		'post__in'       => $info_ids,
		'orderby'        => $info_ids ? 'post__in' : [ 'title' => 'ASC', 'date' => 'DESC' ],
	] );
	if ( ! $info_items ) {
		return;
	}

	$section_class = '';
	$style_bg      = '';

	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	ob_start();
	unset( $block_attributes['blocks'] );
	?>
    <div class="wp-block-wescle-blocks-wescle-catalog-options wescle-catalog-options <?php echo $section_class; ?>" <?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
			<?php
			if ( $title ) {
				printf( '<%1$s class="title" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
            <div class="wescle-catalog-options__list">
				<?php
				foreach ( $info_items as $item ) {
					$title   = $item->post_title;
					$icon_id = get_post_meta( $item->ID, 'icon_id', 1 );
					?>
                    <div class="wescle-catalog-options-item">
						<?php echo wp_get_attachment_image( $icon_id, 'medium' ); ?>
                        <div class="wescle-catalog-options-item__title"><?php echo $title; ?></div>
                    </div>
					<?php
				}
				?>
            </div>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/wescle-catalog-options', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderWescleCatalogOptions'
) );