<?php

function renderVideoSlider( $block_attributes ) {
	global $post;

	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? __( 'Видео карусель', 'wescle' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';

	$text       = $block_attributes['about'] ?? '';
	$aboutImage = $block_attributes['aboutImage'] ?? '';

	$items_video_posts = $block_attributes['items'] ?? [];

	$video_post_ids = [];
	foreach ( $items_video_posts as $item ) {
		if ( isset( $item['video'] ) ) {
			$item = $item['video'];
			if ( $item['id'] ) {
				$video_post_ids[] = $item['id'];
			}
		}
	}

	$posts_per_page = 10;
	$post__in       = [];
	$orderby        = [ 'menu_order' => 'ASC', 'date' => 'DESC' ];

	if ( $video_post_ids ) {
		$posts_per_page = count( $video_post_ids );
		$post__in       = $video_post_ids;
		$orderby        = 'post__in';
	}

	$args        = [
		'post_type'        => 'video_wescle',
		'posts_per_page'   => $posts_per_page,
		'post__in'         => $post__in,
		'orderby'          => $orderby,
		'suppress_filters' => false
	];
	$video_posts = get_posts( $args );
	if ( ! $video_posts ) {
		return;
	}

	$section_class = '';

	$style_bg = '';
	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	$slides_count         = $block_attributes['slidesCount'] ?? 4;
	$slider_speed         = $block_attributes['sliderSpeed'] ?? 8;
	$slider_speed         = $slider_speed * 1000;
	$slider_dots          = isset( $block_attributes['dotsVisible'] ) && ! $block_attributes['dotsVisible'] ? 'false' : 'true';
	$slider_arrows        = isset( $block_attributes['arrowsVisible'] ) && ! $block_attributes['arrowsVisible'] ? 'false' : 'true';
	$slider_arrows_mobile = isset( $block_attributes['hideArrowsMobile'] ) && ! $block_attributes['hideArrowsMobile'] ? '_hide-arrows-mobile' : '';

	ob_start();

	unset( $block_attributes['options'] );
	unset( $block_attributes['items'] );
	?>
    <div class="wp-block-wescle-blocks-videos-slider videos-slider <?php echo $section_class; ?>" <?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
			<?php
			if ( $title ) {
				printf( '<%1$s class="videos-slider__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
            <div class="slider-wrapper <?php echo $slider_arrows_mobile; ?>">
                <div class="videos-slider__top _section-about">
					<?php if ( $aboutImage && isset( $aboutImage['id'] ) ) { ?>
						<?php echo wp_get_attachment_image( $aboutImage['id'], 'medium' ); ?>
					<?php } ?>
					<?php if ( $text ) { ?>
                        <div class="_section-about__text">
							<?php echo $text; ?>
                        </div>
					<?php } ?>
                    <div class="videos-slider__buttons slider-buttons">
                        <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                            </svg>
                        </button>
                        <button class="slider-buttons__item slider-buttons__item_next" type="button">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                            </svg>
                        </button>
                    </div>
                </div>
                <div class="videos-slider__slider" data-slides="<?php echo $slides_count; ?>" data-autoplay-speed="<?php echo $slider_speed; ?>" data-dots="<?php echo $slider_dots; ?>" data-arrows="<?php echo $slider_arrows; ?>">
					<?php
					foreach ( $video_posts as $post ) {
						setup_postdata( $post );
						?>
                        <div class="videos-slider__slide">
							<?php get_template_part( 'template-parts/content/video', 'item' ); ?>
                        </div>
						<?php
					}
					wp_reset_postdata();
					?>
                </div>
            </div>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/videos-slider', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderVideoSlider'
) );