<?php

function renderVideosSection( $block_attributes ) {
	global $post;

	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? __( 'Видео', 'wescle' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';

	$text       = $block_attributes['about'] ?? '';
	$aboutImage = $block_attributes['aboutImage'] ?? '';

	$items_video_posts = $block_attributes['items'] ?? [];

	$video_post_ids = [];
	foreach ( $items_video_posts as $item ) {
		if ( isset( $item['video'] ) ) {
			$item = $item['video'];
			if ( $item['id'] ) {
				$video_post_ids[] = $item['id'];
			}
		}
	}

	$posts_per_page = 10;
	$post__in       = [];
	$orderby        = [ 'menu_order' => 'ASC', 'date' => 'DESC' ];

	if ( $video_post_ids ) {
		$posts_per_page = count( $video_post_ids );
		$post__in       = $video_post_ids;
		$orderby        = 'post__in';
	}

	$args        = [
		'post_type'        => 'video_wescle',
		'posts_per_page'   => $posts_per_page,
		'post__in'         => $post__in,
		'orderby'          => $orderby,
		'suppress_filters' => false
	];
	$video_posts = get_posts( $args );
	if ( ! $video_posts ) {
		return;
	}

	$section_class = '';

	$style_bg = '';
	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	ob_start();

	unset( $block_attributes['options'] );
	unset( $block_attributes['items'] );
	?>
    <div class="wp-block-wescle-blocks-video-section video-section <?php echo $section_class; ?>" <?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
			<?php
			if ( $title ) {
				printf( '<%1$s class="video-section__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
			<?php if ( $text ) { ?>
                <div class="_section-about">
					<?php if ( $aboutImage && isset( $aboutImage['id'] ) ) { ?>
						<?php echo wp_get_attachment_image( $aboutImage['id'], 'medium' ); ?>
					<?php } ?>
                    <div class="video-section__text"><?php echo $text; ?></div>
                </div>
			<?php } ?>
            <div class="video-section__grid">
				<?php
				foreach ( $video_posts as $post ) {
					setup_postdata( $post );

					get_template_part( 'template-parts/content/video_cpt', 'item' );
				}
				wp_reset_postdata();
				?>
            </div>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/videos-section', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderVideosSection'
) );