<?php

function renderVideosMax( $block_attributes ) {
	global $post;

	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? __( 'Видео MAX', 'wescle' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';

	$text         = $block_attributes['about'] ?? '';
	$aboutImage   = $block_attributes['aboutImage'] ?? '';
	$button_title = $block_attributes['btnLabel'] ?? __( 'Кнопка', 'wescle' );
	$button_url   = $block_attributes['btnCustomLink'] ?? '';
	if ( ! $button_url ) {
		$button_link_id = $block_attributes['link'] ?? '';
		if ( $button_link_id ) {
			$button_url = get_permalink( $button_link_id );
		}
	}
	$button_target_blank = isset( $block_attributes['inNewTab'] ) ? 'target="_blank" rel="noopener noreferrer"' : '';

	$items_video_posts = $block_attributes['items'] ?? [];

	$video_post_ids = [];
	foreach ( $items_video_posts as $item ) {
		if ( isset( $item['video'] ) ) {
			$item = $item['video'];
			if ( $item['id'] ) {
				$video_post_ids[] = $item['id'];
			}
		}
	}

	$posts_per_page = 10;
	$post__in       = [];
	$orderby        = [ 'menu_order' => 'ASC', 'date' => 'DESC' ];

	if ( $video_post_ids ) {
		$posts_per_page = count( $video_post_ids );
		$post__in       = $video_post_ids;
		$orderby        = 'post__in';
	}

	$args        = [
		'post_type'        => 'video_wescle',
		'posts_per_page'   => $posts_per_page,
		'post__in'         => $post__in,
		'orderby'          => $orderby,
		'suppress_filters' => false
	];
	$video_posts = get_posts( $args );
//	if ( ! $video_posts ) {
//		return;
//	}

	$section_class = '';

	$style_bg = '';
	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	ob_start();

	unset( $block_attributes['options'] );
	unset( $block_attributes['items'] );
	unset( $block_attributes['pages'] );
	?>
    <div class="wp-block-wescle-blocks-video-max video-max <?php echo $section_class; ?>" <?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
			<?php
			if ( $title ) {
				printf( '<%1$s class="video-max__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
			<?php if ( $text ) { ?>
                <div class="_section-about">
					<?php if ( $aboutImage && isset( $aboutImage['id'] ) ) { ?>
						<?php echo wp_get_attachment_image( $aboutImage['id'], 'medium' ); ?>
					<?php } ?>
                    <div class="video-max__text"><?php echo $text; ?></div>
                </div>
			<?php } ?>
            <div class="video-max__grid">
                <div class="video-max-main">
                    <div class="video-max-main__video">
						<?php
						$img          = '';
						$previewImage = $block_attributes['previewImage'] ?? '';
						if ( $previewImage && isset( $previewImage['id'] ) ) {
							$img = wp_get_attachment_image_src( $previewImage['id'], 'large' );
						}
						foreach ( $video_posts as $post ) {
							setup_postdata( $post );
							$video_id = Helper::get_youtube_video_id( get_post_meta( $post->ID, 'youtube_link', 1 ) );
							if ( ! $video_id ) {
								continue;
							}
							if ( ! $img ) {
								$img = wp_get_attachment_image_src( get_post_thumbnail_id(), 'large' );
							}
							?>
                            <div class="_video-iframe" data-src="<?php echo $video_id; ?>" style="background-image: url('<?php echo $img[0]; ?>');">
                                <div class="btn-play">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 448 512">
                                        <path d="M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z" fill="white"></path>
                                    </svg>
                                </div>
                            </div>
							<?php
							break;
						}
						?>
                    </div>
                </div>
                <div class="video-max-list">
					<?php if ( $button_url && $button_title ) { ?>
                        <div class="video-max-block video-max-block_all">
                            <a class="video-max-block__btn btn btn-main" <?php echo $button_target_blank; ?> href="<?php echo $button_url; ?>"><?php echo $button_title; ?></a>
                        </div>
					<?php } ?>
					<?php
					foreach ( $video_posts as $post ) {
						setup_postdata( $post );
						$video_id = Helper::get_youtube_video_id( get_post_meta( $post->ID, 'youtube_link', 1 ) );
						if ( ! $video_id ) {
							continue;
						}
						?>
                        <a class="video-max-block" href="#" data-src="<?php echo $video_id; ?>">
                            <div class="video-max-block__img">
								<?php echo wp_get_attachment_image( get_post_thumbnail_id(), 'medium' ); ?>
                            </div>
                            <div class="video-max-block__body">
                                <div class="video-max-block__title"><?php the_title(); ?></div>
                                <div class="video-max-block__text">
									<?php
									if ( $post->post_excerpt ) {
										$text = $post->post_excerpt;
									}
									else {
										$text = wp_strip_all_tags( $post->post_content );
									}
									echo Helper::short_string( $text, 100 );
									?>
                                </div>
                            </div>
                        </a>
						<?php
					}
					wp_reset_postdata();
					?>
                </div>
            </div>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/videos-max', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderVideosMax'
) );