<?php

function renderTimeLeft( $block_attributes ) {
	unset( $block_attributes['formHtml'] );

	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? Helper::get_default_theme_data( 'home_special_title' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';
	$text       = $block_attributes['about'] ?? '';

	$home_special_action_label     = $block_attributes['counterTitle'] ?? '';
	$home_special_action_date      = $block_attributes['endByDate'] ?? '';
	$home_special_action_hours     = $block_attributes['endByTime'] ?? '';
	$home_special_progress_percent = $block_attributes['barProgress'] ?? 15;
	$home_special_progress_label   = $block_attributes['barTitle'] ?? Helper::get_default_theme_data( 'home_special_progress_label' );
	$home_special_cf7_position     = isset( $block_attributes['formPosition'] ) && $block_attributes['formPosition'] == 2 ? 'reverse' : '';
	$home_special_cf7              = $block_attributes['form'] ?? 0;
	$home_special_cf7              = intval( $home_special_cf7 );

	$timer_type = $block_attributes['endType'] ?? '';
	if ( 'byTime' == $timer_type ) {
		$timer_data_attr = 'data-timer-by="' . $home_special_action_hours . '"';
	}
	else {
		$timer_data_attr = 'data-timer-stop="' . $home_special_action_date . '"';
	}

	$section_class = '';

	$style_bg = '';
	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	ob_start();
	?>
    <div class="wp-block-wescle-blocks-time-left time-left <?php echo $section_class; ?>" <?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
            <div class="time-left__grid <?php echo $home_special_cf7_position; ?>">
                <div class="time-left-form">
					<?php
					if ( $home_special_cf7 ) {
						echo do_shortcode( '[contact-form-7 id="' . $home_special_cf7 . '"]' );
					}
					?>
                </div>
                <div class="time-left-info">
					<?php
					if ( $title ) {
						printf( '<%1$s class="time-left__title title title_divider title_center" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
					}
					?>
					<?php echo $text; ?>
                    <div class="timer-block" id="timer-block">
						<?php if ( $home_special_action_date ) { ?>
							<?php if ( $home_special_action_label ) { ?>
                                <div class="timer-block__title"><?php echo $home_special_action_label; ?></div>
							<?php } ?>
                            <div class="timer-block__time" id="timer-deadline" <?php echo $timer_data_attr; ?>>
                                <div class="timer-block__item"><span id="days" data-days="">00</span><span class="timer-block__name"><?php _ex( 'дней', 'timer', 'wescle' ); ?></span></div>
                                <div class="timer-block__separator"></div>
                                <div class="timer-block__item"><span id="hours" data-hours="">00</span><span class="timer-block__name"><?php _ex( 'часов', 'timer', 'wescle' ); ?></span></div>
                                <div class="timer-block__separator"></div>
                                <div class="timer-block__item"><span id="minutes" data-minutes="">00</span><span class="timer-block__name"><?php _ex( 'минут', 'timer', 'wescle' ); ?></span></div>
                                <div class="timer-block__separator"></div>
                                <div class="timer-block__item"><span id="seconds" data-seconds="">00</span><span class="timer-block__name"><?php _ex( 'секунд', 'timer', 'wescle' ); ?></span></div>
                            </div>
                            <div class="timer-block__progress">
								<?php if ( $home_special_progress_percent ) { ?>
                                    <div class="timer-block__progress-wrap">
                                        <div class="timer-block__progress-line" data-progress-percent="<?php echo $home_special_progress_percent; ?>"></div>
                                    </div>
								<?php } ?>
								<?php if ( $home_special_progress_label ) { ?>
                                    <div class="timer-block__progress-about"><?php echo $home_special_progress_label; ?></div>
								<?php } ?>
                            </div>
						<?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/time-left', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderTimeLeft'
) );