<?php

function renderTeamCPT( $block_attributes ) {
	global $post;

	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? __( 'Команда 3', 'wescle' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';

	$text       = $block_attributes['about'] ?? '';
	$aboutImage = $block_attributes['aboutImage'] ?? '';
	$post_ids   = [];
	if ( isset( $block_attributes['selectedPeoples'] ) ) {
		foreach ( $block_attributes['selectedPeoples'] as $item ) {
			$post_ids[] = $item['id'];
		}
	}

	$team_posts = get_posts( [
		'post_type'        => 'team_wescle',
		'posts_per_page'   => - 1,
		'post__in'         => $post_ids,
		'orderby'          => 'post__in',
		'suppress_filters' => false
	] );

	$section_class = '';

	$style_bg = '';
	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	ob_start();

	unset( $block_attributes['formHtml'] );
	?>
    <div class="wp-block-wescle-blocks-about-team about-team <?php echo $section_class; ?>" <?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
			<?php
			if ( $title ) {
				printf( '<%1$s class="about-team__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
            <div class="about-team__body">
				<?php if ( $aboutImage && isset( $aboutImage['id'] ) ) { ?>
					<?php echo wp_get_attachment_image( $aboutImage['id'], 'medium_large' ); ?>
				<?php } ?>
				<?php if ( $text ) { ?>
                    <div class="about-team__text"><?php echo $text; ?></div>
				<?php } ?>
                <div class="about-team-list">
					<?php
					foreach ( $team_posts as $post ) {
						setup_postdata( $post );

						get_template_part( 'template-parts/content/team', 'item' );
					}
					wp_reset_postdata();
					?>
                </div>
            </div>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/team3', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderTeamCPT'
) );