<?php

function renderStories( $block_attributes ) {
	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? __( 'Сторис', 'wescle' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';

	$text   = $block_attributes['about'] ?? '';
	$img_id = isset( $block_attributes['aboutImg'] ) && $block_attributes['aboutImg']['id'] ? $block_attributes['aboutImg']['id'] : '';

	$section_class = '';

	$style_bg = '';
	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	ob_start();
	?>
    <div class="wp-block-wescle-blocks-stories-section stories-section <?php echo $section_class; ?>" <?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
			<?php if ( $img_id ) { ?>
                <div class="stories-section__banner banner-block">
                    <div class="banner-block__img">
						<?php echo wp_get_attachment_image( $img_id, 'full' ); ?>
                    </div>
                    <div class="banner-block__body">
						<?php
						if ( $title ) {
							$title = str_replace( '%', '%%', $title );

							printf( '<%1$s class="banner-block__title" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
						}
						?>
						<?php if ( $text ) { ?>
                            <div class="banner-block__text"><?php echo $text; ?></div>
						<?php } ?>
                    </div>
                </div>
			<?php } ?>
            <div class="stories-wrapper">
                <div id="stories"></div>
                <div class="stories-pc-nav">
                    <button class="stories-pc-nav-prev" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                            <g fill="none">
                                <path d="M8 4l8 8l-8 8" stroke="#0088cc" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"></path>
                            </g>
                        </svg>
                    </button>
                    <button class="stories-pc-nav-next" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                            <g fill="none">
                                <path d="M8 4l8 8l-8 8" stroke="#0088cc" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"></path>
                            </g>
                        </svg>
                    </button>
                </div>
            </div>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/stories', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderStories'
) );