<?php

function renderStoreBlock( $block_attributes ) {
	if ( isset( $block_attributes['moveOut'] ) && $block_attributes['moveOut'] ) {
		return;
	}

	static $key_block = 0;
	$key_block ++;

	$title      = $block_attributes['title'] ?? Helper::get_default_theme_data( 'woo_block_products_title' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';

	$codeBefore = $block_attributes['codeBefore'] ?? '';
	$codeAfter  = $block_attributes['codeAfter'] ?? '';
	$blockType  = $block_attributes['blockType'] ?? 'products';

	$slides_count         = $block_attributes['slidesCount'] ?? 4;
	$slider_speed         = $block_attributes['sliderSpeed'] ?? 8;
	$slider_speed         = $slider_speed * 1000;
	$slider_dots          = isset( $block_attributes['dotsVisible'] ) && $block_attributes['dotsVisible'] ? 'true' : 'false';
	$slider_arrows        = isset( $block_attributes['arrowsVisible'] ) && ! $block_attributes['arrowsVisible'] ? 'false' : 'true';
	$slider_arrows_mobile = isset( $block_attributes['hideArrowsMobile'] ) && ! $block_attributes['hideArrowsMobile'] ? '_hide-arrows-mobile' : '';

	$woo_block_category = [];
	if ( isset( $block_attributes['productsByCategories'] ) ) {
		foreach ( $block_attributes['productsByCategories'] as $item ) {
			$woo_block_category[] = $item['id'];
		}
	}

	$woo_block_cat_category = [];
	if ( isset( $block_attributes['selectedCategories'] ) ) {
		foreach ( $block_attributes['selectedCategories'] as $item ) {
			$woo_block_cat_category[] = $item['id'];
		}
	}

	$section_class = 'wp-block-wescle-blocks-goods-slider-section ';
	$color_bg      = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg || ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) ) {
		$section_class .= '_with-bg ';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= '_section-' . $section_position . ' ';
	}

	$slider_enabled = true;
	if ( isset( $block_attributes['withCarousel'] ) && ! $block_attributes['withCarousel'] ) {
		$slider_enabled = false;
	}
	$grid_count = 4;
	if ( isset( $block_attributes['gridColumns'] ) ) {
		$grid_count = $block_attributes['gridColumns'];
	}

	$block = [
		'woo_block_id_block'              => $block_attributes['blockID'] ?? '',
		'woo_block_title'                 => $title,
		'woo_block_title_type'            => $title_type,
		'woo_block_text'                  => $block_attributes['about'] ?? Helper::get_default_theme_data( 'woo_block_products_text' ),
		'woo_block_link_url'              => $block_attributes['linkURL'] ?? '',
		'woo_block_link_id'               => $block_attributes['link'] ?? '',
		'woo_block_link_text'             => $block_attributes['linkText'] ?? '',
		'woo_block_product_type'          => $block_attributes['productsType'] ?? 'sale',
		'woo_block_limit'                 => $block_attributes['goodsOnPage'] ?? 10,
		'woo_block_color_bg'              => $block_attributes['backgroundColor'] ?? '',
		'woo_block_color_title'           => $block_attributes['titleColor'] ?? '',
		'slider_enabled'                  => $slider_enabled,
		'grid_count'                      => $grid_count,
		'slides_count'                    => $slides_count,
		'slider_speed'                    => $slider_speed,
		'slider_dots'                     => $slider_dots,
		'slider_arrows'                   => $slider_arrows,
		'slider_arrows_mobile'            => $slider_arrows_mobile,
		'woo_block_category'              => $woo_block_category,
		'woo_block_products'              => $block_attributes['productsByID'] ?? '',
		'woo_block_category_select'       => $woo_block_cat_category,
		'woo_block_category_limit'        => $block_attributes['goodsOnPage'] ?? 10,
		'section_class'                   => $section_class,
		'woo_block_category_shadow'       => $block_attributes['categoriesShadow'] ?? true,
		'woo_block_category_count_at_img' => $block_attributes['categoriesCountAtImg'] ?? false,
		'woo_block_category_show_count'   => $block_attributes['categoriesCount'] ?? true,
	];

	ob_start();

	unset( $block_attributes['products'] );
	unset( $block_attributes['productsByType'] );
	unset( $block_attributes['currentProductsByCategories'] );
	unset( $block_attributes['currentProductsByID'] );
	unset( $block_attributes['categories'] );
	unset( $block_attributes['pages'] );

	if ( $codeBefore ) {
		set_query_var( 'template_args', [ 'code' => $codeBefore, 'container' => true ] );
		get_template_part( 'template-parts/section/advt', '' );
	}

	if ( 'categories' == $blockType ) {
		get_template_part( 'template-parts/section/woo', 'category', [ 'block' => $block, 'key_block' => $key_block, 'block_attributes' => $block_attributes ] );
	}
	elseif ( 'products' == $blockType ) {
		get_template_part( 'template-parts/section/woo', 'products', [ 'block' => $block, 'key_block' => $key_block, 'block_attributes' => $block_attributes ] );
	}

	if ( $codeAfter ) {
		set_query_var( 'template_args', [ 'code' => $codeAfter, 'container' => true ] );
		get_template_part( 'template-parts/section/advt', '' );
	}

	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/store-products', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderStoreBlock'
) );