<?php

function renderProductsTabsBlock( $block_attributes ) {
	static $key_block = 0;
	$key_block ++;

	$title      = $block_attributes['title'] ?? Helper::get_default_theme_data( 'woo_block_products_title' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';

	$section_class = ' wp-block-wescle-blocks-goods-slider-section';
	$color_bg      = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg || ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) ) {
		$section_class .= ' _with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	$block = [
		'woo_block_id_block'     => $block_attributes['blockID'] ?? '',
		'woo_block_title'        => $title,
		'woo_block_title_type'   => $title_type,
		'woo_block_text'         => $block_attributes['about'] ?? Helper::get_default_theme_data( 'woo_block_products_text' ),
		'woo_block_link_url'     => $block_attributes['linkURL'] ?? '',
		'woo_block_link_id'      => $block_attributes['link'] ?? '',
		'woo_block_link_text'    => $block_attributes['linkText'] ?? '',
		'woo_block_product_type' => $block_attributes['productsType'] ?? 'sale',
		'woo_block_limit'        => $block_attributes['goodsOnPage'] ?? 10,
		'woo_block_color_bg'     => $block_attributes['backgroundColor'] ?? '',
		'woo_block_color_title'  => $block_attributes['titleColor'] ?? '',
		'section_class'          => $section_class,
	];

	ob_start();

	unset( $block_attributes['pages'] );
//	unset( $block_attributes['services'][0]['products'] );
//	unset( $block_attributes['services'][1]['products'] );
	unset( $block_attributes['products'] );

	get_template_part( 'template-parts/home/product_tabs', null, [ 'block' => $block, 'key_block' => $key_block, 'block_attributes' => $block_attributes ] );

	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/store-products-tabs', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderProductsTabsBlock'
) );