<?php

function renderReviews( $block_attributes ) {
	global $post;

	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? __( 'Отзывы', 'wescle' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';

	$link_id = $block_attributes['link'] ?? '';
	if ( intval( $link_id ) ) {
		$link = get_permalink( $link_id );
	}
	$link_text     = $block_attributes['title'] ?? __( 'Все отзывы', 'wescle' );
	$button_text   = $block_attributes['buttonText'] ?? __( 'Подробнее', 'wescle' );
	$button_source = $block_attributes['sourceButton'] ?? __( 'Источник', 'wescle' );

	$slider_speed       = $block_attributes['sliderSpeed'] ?? 8;
	$slider_speed       = $slider_speed * 1000;
	$slider_arrows_show = isset( $block_attributes['arrowsVisible'] ) && ! $block_attributes['arrowsVisible'] ? 'false' : 'true';
	$slider_dots        = isset( $block_attributes['dotsVisible'] ) && ! $block_attributes['dotsVisible'] ? 'false' : 'true';
	$mobile_arrows_show = isset( $block_attributes['hideArrowsMobile'] ) && ! $block_attributes['hideArrowsMobile'] ? 'false' : 'true';

	$review_post_ids = [];
	if ( isset( $block_attributes['selectedReviewsList'] ) ) {
		foreach ( $block_attributes['selectedReviewsList'] as $item ) {
			$review_post_ids[] = $item['id'];
		}
	}

	$orderby = 'date';
	if ( isset( $block_attributes['sorting'] ) ) {
		$orderby = $block_attributes['sorting'];
	}

	$posts_per_page = 10;
	$post__in       = [];
	if ( $review_post_ids ) {
		$posts_per_page = count( $review_post_ids );
		$post__in       = $review_post_ids;
		$orderby        = 'post__in';
	}

	$review_posts = get_posts( [
		'post_type'        => 'review',
		'posts_per_page'   => $posts_per_page,
		'post__in'         => $post__in,
		'orderby'          => $orderby,
		'suppress_filters' => false
	] );
	if ( ! $review_posts ) {
		return;
	}

	$section_class = '';

	$style_bg = '';
	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	$btn_flare     = '';
	$parse_content = parse_blocks( $post->post_content );
	foreach ( $parse_content as $item ) {
		if ( $item['blockName'] == 'wescle-blocks/events' ) {

			$button_type = $item['attrs']['buttonsView'] ?? '';
			if ( $button_type == 'animate' ) {
				$btn_flare = 'btn-flare';
			}
		}
	}

	ob_start();

	unset( $block_attributes['reviews'] );
	unset( $block_attributes['pages'] );
	unset( $block_attributes['formHtml'] );
	unset( $block_attributes['selectedReviewsList'] );
	?>
    <div class="wp-block-wescle-blocks-reviews reviews <?php echo $section_class; ?>" <?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
            <div class="slider-wrapper <?php echo( $mobile_arrows_show == 'true' ? '' : '_hide-arrows-mobile' ); ?>">
				<?php
				if ( $title ) {
					printf( '<%1$s class="reviews__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
				}
				?>
                <div class="reviews__top">
					<?php if ( $link_id && $link_text ) { ?>
                        <a class="reviews__link" href="<?php echo $link; ?>"><?php echo esc_html( $link_text ); ?></a>
					<?php } ?>
					<?php
					if ( $slider_arrows_show === 'true' ) { ?>
                        <div class="reviews__buttons slider-buttons">
                            <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                    <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                                </svg>
                            </button>
                            <button class="slider-buttons__item slider-buttons__item_next" type="button">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                    <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                                </svg>
                            </button>
                        </div>
					<?php } ?>
                </div>
                <div class="reviews__body">
                    <div class="reviews__slider reviews-slider" data-autoplay-speed="<?php echo $slider_speed; ?>" data-dots="<?php echo $slider_dots; ?>" data-arrows="<?php echo $slider_arrows_show; ?>">
						<?php
						foreach ( $review_posts as $post ) {
							setup_postdata( $post );
							?>
                            <div class="reviews-slider__slide">
								<?php get_template_part( 'template-parts/content/review', 'item', [ 'button_text' => $button_text, 'btn_flare' => $btn_flare, 'button_source' => $button_source ] ); ?>
                            </div>
							<?php
						}
						wp_reset_postdata();
						?>
                    </div>
                </div>
            </div>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/reviews', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderReviews'
) );