<?php

// TODO: Write html contact Block
function renderWescleProducts( $block_attributes ) {
	global $post;

	static $block_count;
	$block_count ++;

	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? Helper::get_default_theme_data( 'wescle_blocks_prodwescle_title' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';

	$text    = $block_attributes['about'] ?? '';
	$link    = '';
	$link_id = $block_attributes['link'] ?? 0;
	if ( $link_id && $link_id != '0' ) {
		$link = get_permalink( $link_id );
	}
	$link_text = $block_attributes['allGoods'] ?? '';
	$more_text = $block_attributes['button'] ?? Helper::get_default_theme_data( 'home_prodwescle_more_text' );

	$posts_per_page = $block_attributes['goodsOnPage'] ?? 8;
	$args           = [
		'post_type'      => 'product_wescle',
		'post_status'    => 'publish',
		'posts_per_page' => $posts_per_page,
		'tax_query'      => [],
		'orderby'        => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
	];

	$posts_include = [];
	$terms_include = [];
	if ( isset( $block_attributes['selectedProductsList'] ) ) {
		foreach ( $block_attributes['selectedProductsList'] as $item ) {
			$posts_include[] = $item['id'];
		}
	}
    elseif ( isset( $block_attributes['selectedCategories'] ) ) {
		foreach ( $block_attributes['selectedCategories'] as $item ) {
			$terms_include[] = $item['id'];
		}
		if ( $terms_include ) {
			$args['tax_query'][] = [
				'taxonomy' => 'productcat_wescle',
				'terms'    => $terms_include,
			];
		}
	}

	if ( $posts_include && $posts_include[0] ) {
		$args['post__in']       = $posts_include;
		$args['posts_per_page'] = count( $posts_include );
		$args['orderby']        = 'post__in';
	}

	$query_prodwescle = new WP_Query( $args );
	$posts_prodwescle = $query_prodwescle->posts;

	$section_class = '';

	$style_bg = '';
	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	$btn_flare     = '';
	$parse_content = parse_blocks( $post->post_content );
	foreach ( $parse_content as $item ) {
		if ( $item['blockName'] == 'wescle-blocks/products' ) {
			$button_type = $item['attrs']['buttonsView'] ?? '';
			if ( $button_type == 'animate' ) {
				$btn_flare = 1;
			}
		}
	}

	ob_start();

	$block_class = 'products-section-' . $block_count;
	?>
    <div class="wp-block-wescle-blocks-products products-section <?php echo $block_class; ?> <?php echo $section_class; ?>"<?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
			<?php
			if ( $title ) {
				printf( '<%1$s class="products-section__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
			<?php if ( $text || $link ) { ?>
                <div class="products-section__about">
                    <div class="products-section__text">
						<?php if ( isset( $block_attributes['aboutImg'] ) ) { ?>
							<?php echo wp_get_attachment_image( $block_attributes['aboutImg']['id'], 'medium_large' ); ?>
						<?php } ?>
						<?php echo $text; ?>
                    </div>
					<?php if ( $link && $link_text ) { ?>
                        <a class="products-section__link" href="<?php echo $link; ?>"><?php echo $link_text; ?></a>
					<?php } ?>
                </div>
			<?php } ?>
            <div class="products-section__grid">
				<?php
				foreach ( $posts_prodwescle as $post ) {
					setup_postdata( $post );

					get_template_part( 'template-parts/content/product', 'item', [ 'btn_flare' => $btn_flare ] );
				}
				wp_reset_postdata();
				?>
            </div>
			<?php if ( $more_text && $query_prodwescle->max_num_pages > 1 ) { ?>
                <div class="products-section__more">
                    <a class="btn btn-main btn-prodwescle-more" href="#" data-paged="1" data-args="<?php echo htmlspecialchars( json_encode( $query_prodwescle->query_vars ), ENT_QUOTES, 'UTF-8' ); ?>"><?php echo $more_text; ?></a>
                </div>
			<?php } ?>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

function initProductBlock() {
	register_block_type( 'wescle-blocks/products', array(
		'style'           => 'wescle-blocks-style',
		'editor_script'   => 'wescle-blocks',
		'editor_style'    => 'wescle-blocks-editor-style',
		'render_callback' => 'renderWescleProducts'
	) );
}

initProductBlock();