<?php

function renderPriceList( $block_attributes ) {
	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? __( 'Прайс-лист', 'wescle' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';

	$text           = $block_attributes['about'] ?? '';
	$price_post_ids = [];
	if ( isset( $block_attributes['selectedPrices'] ) ) {
		foreach ( $block_attributes['selectedPrices'] as $item ) {
			$price_post_ids[] = $item['id'];
		}
	}

	$posts_per_page = - 1;
	$post__in       = [];
	$orderby        = [ 'menu_order' => 'ASC', 'date' => 'DESC' ];
	if ( $price_post_ids ) {
		$posts_per_page = count( $price_post_ids );
		$post__in       = $price_post_ids;
		$orderby        = 'post__in';
	}
	$price_posts = get_posts( [
		'post_type'        => 'price_wescle',
		'posts_per_page'   => $posts_per_page,
		'post__in'         => $post__in,
		'orderby'          => $orderby,
		'suppress_filters' => false
	] );
	if ( ! $price_posts ) {
		return;
	}

	$section_class = '';

	$style_bg = '';
	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	ob_start();
	?>
    <div class="wp-block-wescle-blocks-price-list price-list <?php echo $section_class; ?>" <?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
			<?php
			if ( $title ) {
				printf( '<%1$s class="price-list__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
			<?php
			if ( isset( $block_attributes['aboutImg'] ) && $block_attributes['aboutImg']['id'] ) {
				echo wp_get_attachment_image( $block_attributes['aboutImg']['id'], 'medium_large' );
			}
			?>
			<?php if ( $text ) { ?>
                <div class="price-list__text"><?php echo $text; ?></div>
			<?php } ?>
            <div class="accardeon">
				<?php foreach ( $price_posts as $item ) { ?>
					<?php
					$active_class = get_post_meta( $item->ID, 'is_open', 1 ) ? 'active' : '';
					?>
                    <div class="price-list-item">
                        <button class="price-list-item__title accardeon__title <?php echo $active_class; ?>"><span><?php echo $item->post_title; ?></span>
                            <svg class="feather feather-plus" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewbox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <line x1="12" y1="5" x2="12" y2="19"></line>
                                <line x1="5" y1="12" x2="19" y2="12"></line>
                            </svg>
                        </button>
                        <div class="price-list-item__body">
							<?php
							$content = preg_replace( '/<table.+?>/', '<table class="main-table">', $item->post_content );
							$content = str_replace( [ '<table', '</table>' ], [ '<div class="main-table-wrap"><table', '</table></div>' ], $content );
							echo do_shortcode( $content );
							?>
                        </div>
                    </div>
				<?php } ?>
            </div>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/price-list', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderPriceList'
) );