<?php

function renderPackageInc( $block_attributes ) {
	global $post;

	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title        = $block_attributes['title'] ?? __( 'Что входит', 'wescle' );
	$title        = str_replace( '%', '%%', $title );
	$title_type   = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';
	$optionTitle  = $block_attributes['optionTitle'] ?? __( 'Что входит в пакет', 'wescle' ) . ':';
	$button_label = $block_attributes['buttonText'] ?? Helper::get_default_theme_data( 'home_price_table_button' );

	$text       = $block_attributes['about'] ?? '';
	$aboutImage = $block_attributes['aboutImage'] ?? '';

	$package_post_ids = [];
	if ( isset( $block_attributes['selectedPackagesLists'] ) ) {
		foreach ( $block_attributes['selectedPackagesLists'] as $item ) {
			$package_post_ids[] = $item['id'];
		}
	}

	$posts_per_page = 4;
	$post__in       = [];
	$orderby        = [ 'menu_order' => 'ASC', 'date' => 'DESC' ];
	if ( $package_post_ids ) {
		$post__in = $package_post_ids;
		$orderby  = 'post__in';
	}
	$package_posts = get_posts( [
		'post_type'        => 'pricepackage_wescle',
		'posts_per_page'   => $posts_per_page,
		'post__in'         => $post__in,
		'orderby'          => $orderby,
		'suppress_filters' => false
	] );
	if ( ! $package_posts ) {
		return;
	}

	$package_thead_data = [
		$optionTitle
	];
	foreach ( $package_posts as $item_post ) {
		$package_thead_data[ $item_post->ID ] = $item_post->post_title;
	}

	$package_tbody_data = [];
	$option_posts       = get_posts( [
		'post_type'        => 'optionpackage_wescle',
		'posts_per_page'   => - 1,
		'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
		'suppress_filters' => false
	] );
	foreach ( $option_posts as $option_post ) {
		$package_tbody_data[ $option_post->ID ]          = [];
		$package_tbody_data[ $option_post->ID ]['title'] = $option_post->post_title;
	}

	$section_class = '';

	$style_bg = '';
	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	$btn_flare     = '';
	$parse_content = parse_blocks( $post->post_content );
	foreach ( $parse_content as $item ) {
		if ( $item['blockName'] == 'wescle-blocks/packages-include' ) {
			$button_type = $item['attrs']['buttonsView'] ?? '';
			if ( $button_type == 'animate' ) {
				$btn_flare = 'btn-flare';
			}
		}
	}

	ob_start();
	?>
    <div class="wp-block-wescle-blocks-packages-include packages-include <?php echo $section_class; ?>" <?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
			<?php
			if ( $title ) {
				printf( '<%1$s class="packages-include__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
			<?php if ( $text ) { ?>
                <div class="_section-about">
					<?php if ( $aboutImage && isset( $aboutImage['id'] ) ) { ?>
						<?php echo wp_get_attachment_image( $aboutImage['id'], 'medium' ); ?>
					<?php } ?>
                    <div class="_section-about__text"><?php echo $text; ?></div>
                </div>
			<?php } ?>
            <div class="packages-include__body">
                <div class="main-table-wrap">
                    <table class="main-table packages-include__table">
                        <thead>
                        <tr>
							<?php foreach ( $package_thead_data as $key => $th ) { ?>
                                <th class="packages-<?php echo $key; ?>"><?php echo $th; ?></th>
							<?php } ?>
                        </tr>
                        </thead>
                        <tbody>
						<?php
						foreach ( $option_posts as $option_post ) {
							$price_package_ids = get_post_meta( $option_post->ID, 'price_package_ids', 1 );
							if ( ! $price_package_ids ) {
								$price_package_ids = [];
							}
							?>
                            <tr>
                                <td><?php echo $option_post->post_title; ?></td>
								<?php foreach ( $package_posts as $item_post ) { ?>
                                    <td class="packages-<?php echo $item_post->ID; ?>">
										<?php if ( in_array( $item_post->ID, $price_package_ids ) ) { ?>
                                            <div class="packages-include__icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 16 16">
                                                    <g>
                                                        <path fill-rule="evenodd" d="M10.97 4.97a.75.75 0 0 1 1.071 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093l3.473-4.425a.236.236 0 0 1 .02-.022z"></path>
                                                    </g>
                                                </svg>
                                            </div>
										<?php } ?>
                                    </td>
								<?php } ?>
                            </tr>
						<?php } ?>
                        </tbody>
                        <tfoot>
                        <tr>
                            <td></td>
							<?php foreach ( $package_posts as $item_post ) {
								$price_old  = get_post_meta( $item_post->ID, 'price_old', 1 );
								$price      = get_post_meta( $item_post->ID, 'price', 1 );
								$text_after = get_post_meta( $item_post->ID, 'label_after_button', 1 );

								$url = trim( get_post_meta( $item_post->ID, 'button_url', 1 ) );
								if ( ! $url || $url == '#' ) {
									$url = '#modal-order_package';
								}

								$color_class = '';
								$block_color = get_post_meta( $item_post->ID, 'block_color', 1 );
								if ( $block_color ) {
									$color_class = 'packages-custom_color ';
								}
								?>
                                <td class="packages-include__table-info <?php echo $color_class; ?>packages-<?php echo $item_post->ID; ?>">
									<?php if ( $price_old || $price ) { ?>
                                        <div class="packages-include__table-price">
											<?php if ( $price_old ) { ?>
                                                <span class="packages-include__table-price-old"><?php echo $price_old; ?></span>
											<?php } ?>
                                            <span class="packages-include__table-price-current"><?php echo $price; ?></span>
                                        </div>
									<?php } ?>
									<?php if ( $button_label ) { ?>
										<?php if ( $url == '#modal-order_package' ) { ?>
                                            <a class="btn btn-main btn-order_package _popup-link <?php echo $btn_flare; ?>" data-name="<?php echo esc_attr( $item_post->post_title ); ?>" href="<?php echo $url; ?>"><span><?php echo $button_label; ?></span></a>
										<?php } else { ?>
                                            <span class="btn btn-main js-link <?php echo $btn_flare; ?>" data-link="<?php echo $url; ?>"><span><?php echo $button_label; ?></span></span>
										<?php } ?>
									<?php } ?>
									<?php if ( $text_after ) { ?>
                                        <div class="packages-include__table-residue"><?php echo $text_after; ?></div>
									<?php } ?>
                                </td>
							<?php } ?>
                        </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/packages-include', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderPackageInc'
) );