<?php

function renderGallery( $block_attributes ) {
	global $post;

	unset( $block_attributes['posts'] ); // hideAllButton

	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? Helper::get_default_theme_data( 'home_gallery_title' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';
	$text       = $block_attributes['about'] ?? '';

	$term_ids = [];
	if ( isset( $block_attributes['services'] ) && $block_attributes['services'] ) {
		foreach ( $block_attributes['services'] as $item ) {
			$term_ids[] = intval( $item['service']['id'] );
		}
	}

	$terms = get_terms( [
		'taxonomy' => 'gallerycat_wescle',
		'include'  => $term_ids,
		'orderby'  => 'include',
	] );
	$terms = array_values( $terms );

	$args = [
		'post_type'        => 'gallery_wescle',
		'posts_per_page'   => - 1,
		'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
		'suppress_filters' => false
	];
	if ( $term_ids ) {
		$args['tax_query'] = [
			[
				'taxonomy' => 'gallerycat_wescle',
				'terms'    => $term_ids
			]
		];
	}
	$posts_gallery = get_posts( $args );
	if ( ! $posts_gallery ) {
		return;
	}

	$section_class = '';

	$style_bg = '';
	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	$btn_flare     = '';
	$parse_content = parse_blocks( $post->post_content );
	foreach ( $parse_content as $item ) {
		if ( $item['blockName'] == 'wescle-blocks/our-works' ) {
			$button_type = $item['attrs']['buttonsView'] ?? '';
			if ( $button_type == 'animate' ) {
				$btn_flare = 'btn-flare';
			}
		}
	}

	$hide_button_all = isset( $block_attributes['hideAllButton'] ) ? true : false;

	ob_start();
	?>
    <div class="wp-block-wescle-blocks-our-works our-works <?php echo $section_class; ?>" <?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
			<?php include get_template_directory() . '/template-parts/home/gallery-grid.php'; ?>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/our-works', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderGallery'
) );