<?php

function renderMosaicBlock( $block_attributes ) {
	static $key_block = 0;
	$key_block ++;

	$block_id = $block_attributes['blockID'] ?? '';
	if ( $block_id ) {
		$block_id = ' id="' . $block_id . '"';
	}
	$title      = $block_attributes['title'] ?? __( 'Плитки-мозаика', 'wescle' );
	$title      = str_replace( '%', '%%', $title );
	$title_type = isset( $block_attributes['typeOfTitle'] ) ? 'h' . $block_attributes['typeOfTitle'] : 'div';

	$text       = $block_attributes['about'] ?? 'Vestibulum ac diam sit amet quam vehicula elementum sed sit amet dui. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque in ipsum id orci porta dapibus.';
	$aboutImage = $block_attributes['aboutImage'] ?? '';

	$link         = $block_attributes['linkUrl'] ?? '#';
	$link_text    = $block_attributes['linkText'] ?? __( 'Ссылка', 'wescle' );
	$target_blank = isset( $block_attributes['linkInNewTab'] ) ? 'target="_blank" rel="noopener noreferrer"' : '';
	$per_page     = $block_attributes['blocksCount'] ?? 12;
	$more_text    = $block_attributes['showMore'] ?? '';

	if ( ! isset( $block_attributes['services'] ) || empty( $block_attributes['services'] ) ) {
		$term_ids = [];
	}
	else {
		$term_ids = wp_list_pluck( $block_attributes['services'], 'tabId' );
	}
	$terms = get_terms( [
		'taxonomy' => 'mosaiccat_wescle',
		'include'  => $term_ids,
		'orderby'  => 'include'
	] );
	if ( ! $terms ) {
		return;
	}
	$terms = array_values( $terms );

	$section_class = '';
	$style_bg      = '';

	$color_bg = $block_attributes['backgroundColor'] ?? '';
	if ( $color_bg ) {
		$style_bg      = ' style="background-color:' . $color_bg . ';"';
		$section_class = '_with-bg';
	}

	$style_title = '';
	$color       = $block_attributes['titleColor'] ?? '';
	if ( $color ) {
		$style_title = 'style="color:' . $color . ';"';
	}

	if ( isset( $block_attributes['backgroundImage']['url'] ) && $block_attributes['backgroundImage']['url'] ) {
		$section_class = '_with-bg';
	}

	$section_position = $block_attributes['blockPosition'] ?? 'default';
	if ( 'default' != $section_position ) {
		$section_class .= ' _section-' . $section_position;
	}

	ob_start();

	unset( $block_attributes['pages'] );
	unset( $block_attributes['blocks'] );
	unset( $block_attributes['categories'] );
	?>
    <div class="wp-block-wescle-blocks-wescle-places wescle-places <?php echo $section_class; ?>" <?php echo $style_bg; ?><?php echo $block_id; ?>>
		<?php wescle_blocks_bg_image( $block_attributes ); ?>
        <div class="container">
			<?php
			if ( $title ) {
				printf( '<%1$s class="wescle-places__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
			<?php if ( $text ) { ?>
                <div class="wescle-places__about _section-about">
					<?php if ( $aboutImage && isset( $aboutImage['id'] ) ) { ?>
						<?php echo wp_get_attachment_image( $aboutImage['id'], 'medium' ); ?>
					<?php } ?>
                    <div class="_section-about__text"><?php echo $text; ?></div>
					<?php if ( $link && $link_text ) { ?>
                        <a class="wescle-places__link" href="<?php echo $link; ?>" <?php echo $target_blank; ?>><?php echo $link_text; ?></a>
					<?php } ?>
                </div>
			<?php } ?>
			<?php get_template_part( 'template-parts/home/mosaic-tabs', null, [ 'terms' => $terms, 'more_text' => $more_text, 'per_page' => $per_page ] ); ?>
        </div>
    </div>
	<?php
	$return_html = ob_get_clean();

	return $return_html;
}

register_block_type( 'wescle-blocks/mosaic-tile', array(
	'style'           => 'wescle-blocks-style',
	'editor_script'   => 'wescle-blocks',
	'editor_style'    => 'wescle-blocks-editor-style',
	'render_callback' => 'renderMosaicBlock'
) );